# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20180828


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class ResourceAnchorSummary(object):
    """
    Summary information about a ResourceAnchor.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new ResourceAnchorSummary object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param id:
            The value to assign to the id property of this ResourceAnchorSummary.
        :type id: str

        :param display_name:
            The value to assign to the display_name property of this ResourceAnchorSummary.
        :type display_name: str

        :param compartment_id:
            The value to assign to the compartment_id property of this ResourceAnchorSummary.
        :type compartment_id: str

        :param compartment_name:
            The value to assign to the compartment_name property of this ResourceAnchorSummary.
        :type compartment_name: str

        :param partner_cloud_account_identifier:
            The value to assign to the partner_cloud_account_identifier property of this ResourceAnchorSummary.
        :type partner_cloud_account_identifier: str

        :param csp_resource_anchor_id:
            The value to assign to the csp_resource_anchor_id property of this ResourceAnchorSummary.
        :type csp_resource_anchor_id: str

        :param csp_resource_anchor_name:
            The value to assign to the csp_resource_anchor_name property of this ResourceAnchorSummary.
        :type csp_resource_anchor_name: str

        :param csp_additional_properties:
            The value to assign to the csp_additional_properties property of this ResourceAnchorSummary.
        :type csp_additional_properties: dict(str, str)

        :param time_created:
            The value to assign to the time_created property of this ResourceAnchorSummary.
        :type time_created: datetime

        :param time_updated:
            The value to assign to the time_updated property of this ResourceAnchorSummary.
        :type time_updated: datetime

        :param lifecycle_state:
            The value to assign to the lifecycle_state property of this ResourceAnchorSummary.
        :type lifecycle_state: str

        :param lifecycle_details:
            The value to assign to the lifecycle_details property of this ResourceAnchorSummary.
        :type lifecycle_details: str

        :param freeform_tags:
            The value to assign to the freeform_tags property of this ResourceAnchorSummary.
        :type freeform_tags: dict(str, str)

        :param defined_tags:
            The value to assign to the defined_tags property of this ResourceAnchorSummary.
        :type defined_tags: dict(str, dict(str, object))

        :param subscription_id:
            The value to assign to the subscription_id property of this ResourceAnchorSummary.
        :type subscription_id: str

        :param system_tags:
            The value to assign to the system_tags property of this ResourceAnchorSummary.
        :type system_tags: dict(str, dict(str, object))

        :param linked_compartment_id:
            The value to assign to the linked_compartment_id property of this ResourceAnchorSummary.
        :type linked_compartment_id: str

        :param linked_compartment_name:
            The value to assign to the linked_compartment_name property of this ResourceAnchorSummary.
        :type linked_compartment_name: str

        """
        self.swagger_types = {
            'id': 'str',
            'display_name': 'str',
            'compartment_id': 'str',
            'compartment_name': 'str',
            'partner_cloud_account_identifier': 'str',
            'csp_resource_anchor_id': 'str',
            'csp_resource_anchor_name': 'str',
            'csp_additional_properties': 'dict(str, str)',
            'time_created': 'datetime',
            'time_updated': 'datetime',
            'lifecycle_state': 'str',
            'lifecycle_details': 'str',
            'freeform_tags': 'dict(str, str)',
            'defined_tags': 'dict(str, dict(str, object))',
            'subscription_id': 'str',
            'system_tags': 'dict(str, dict(str, object))',
            'linked_compartment_id': 'str',
            'linked_compartment_name': 'str'
        }
        self.attribute_map = {
            'id': 'id',
            'display_name': 'displayName',
            'compartment_id': 'compartmentId',
            'compartment_name': 'compartmentName',
            'partner_cloud_account_identifier': 'partnerCloudAccountIdentifier',
            'csp_resource_anchor_id': 'cspResourceAnchorId',
            'csp_resource_anchor_name': 'cspResourceAnchorName',
            'csp_additional_properties': 'cspAdditionalProperties',
            'time_created': 'timeCreated',
            'time_updated': 'timeUpdated',
            'lifecycle_state': 'lifecycleState',
            'lifecycle_details': 'lifecycleDetails',
            'freeform_tags': 'freeformTags',
            'defined_tags': 'definedTags',
            'subscription_id': 'subscriptionId',
            'system_tags': 'systemTags',
            'linked_compartment_id': 'linkedCompartmentId',
            'linked_compartment_name': 'linkedCompartmentName'
        }
        self._id = None
        self._display_name = None
        self._compartment_id = None
        self._compartment_name = None
        self._partner_cloud_account_identifier = None
        self._csp_resource_anchor_id = None
        self._csp_resource_anchor_name = None
        self._csp_additional_properties = None
        self._time_created = None
        self._time_updated = None
        self._lifecycle_state = None
        self._lifecycle_details = None
        self._freeform_tags = None
        self._defined_tags = None
        self._subscription_id = None
        self._system_tags = None
        self._linked_compartment_id = None
        self._linked_compartment_name = None

    @property
    def id(self):
        """
        **[Required]** Gets the id of this ResourceAnchorSummary.
        The `OCID`__ of the ResourceAnchor.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :return: The id of this ResourceAnchorSummary.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this ResourceAnchorSummary.
        The `OCID`__ of the ResourceAnchor.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :param id: The id of this ResourceAnchorSummary.
        :type: str
        """
        self._id = id

    @property
    def display_name(self):
        """
        **[Required]** Gets the display_name of this ResourceAnchorSummary.
        A user-friendly name. Does not have to be unique, and it's changeable.


        :return: The display_name of this ResourceAnchorSummary.
        :rtype: str
        """
        return self._display_name

    @display_name.setter
    def display_name(self, display_name):
        """
        Sets the display_name of this ResourceAnchorSummary.
        A user-friendly name. Does not have to be unique, and it's changeable.


        :param display_name: The display_name of this ResourceAnchorSummary.
        :type: str
        """
        self._display_name = display_name

    @property
    def compartment_id(self):
        """
        **[Required]** Gets the compartment_id of this ResourceAnchorSummary.
        The `OCID`__ of the compartment.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :return: The compartment_id of this ResourceAnchorSummary.
        :rtype: str
        """
        return self._compartment_id

    @compartment_id.setter
    def compartment_id(self, compartment_id):
        """
        Sets the compartment_id of this ResourceAnchorSummary.
        The `OCID`__ of the compartment.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :param compartment_id: The compartment_id of this ResourceAnchorSummary.
        :type: str
        """
        self._compartment_id = compartment_id

    @property
    def compartment_name(self):
        """
        Gets the compartment_name of this ResourceAnchorSummary.
        The name assigned to the compartment during creation.


        :return: The compartment_name of this ResourceAnchorSummary.
        :rtype: str
        """
        return self._compartment_name

    @compartment_name.setter
    def compartment_name(self, compartment_name):
        """
        Sets the compartment_name of this ResourceAnchorSummary.
        The name assigned to the compartment during creation.


        :param compartment_name: The compartment_name of this ResourceAnchorSummary.
        :type: str
        """
        self._compartment_name = compartment_name

    @property
    def partner_cloud_account_identifier(self):
        """
        Gets the partner_cloud_account_identifier of this ResourceAnchorSummary.
        Partner Cloud Account Identifier of the Cloud Service Provider.


        :return: The partner_cloud_account_identifier of this ResourceAnchorSummary.
        :rtype: str
        """
        return self._partner_cloud_account_identifier

    @partner_cloud_account_identifier.setter
    def partner_cloud_account_identifier(self, partner_cloud_account_identifier):
        """
        Sets the partner_cloud_account_identifier of this ResourceAnchorSummary.
        Partner Cloud Account Identifier of the Cloud Service Provider.


        :param partner_cloud_account_identifier: The partner_cloud_account_identifier of this ResourceAnchorSummary.
        :type: str
        """
        self._partner_cloud_account_identifier = partner_cloud_account_identifier

    @property
    def csp_resource_anchor_id(self):
        """
        Gets the csp_resource_anchor_id of this ResourceAnchorSummary.
        Resource Anchor Id in the Cloud Service Provider.


        :return: The csp_resource_anchor_id of this ResourceAnchorSummary.
        :rtype: str
        """
        return self._csp_resource_anchor_id

    @csp_resource_anchor_id.setter
    def csp_resource_anchor_id(self, csp_resource_anchor_id):
        """
        Sets the csp_resource_anchor_id of this ResourceAnchorSummary.
        Resource Anchor Id in the Cloud Service Provider.


        :param csp_resource_anchor_id: The csp_resource_anchor_id of this ResourceAnchorSummary.
        :type: str
        """
        self._csp_resource_anchor_id = csp_resource_anchor_id

    @property
    def csp_resource_anchor_name(self):
        """
        Gets the csp_resource_anchor_name of this ResourceAnchorSummary.
        Resource Anchor Name in the Cloud Service Provider.


        :return: The csp_resource_anchor_name of this ResourceAnchorSummary.
        :rtype: str
        """
        return self._csp_resource_anchor_name

    @csp_resource_anchor_name.setter
    def csp_resource_anchor_name(self, csp_resource_anchor_name):
        """
        Sets the csp_resource_anchor_name of this ResourceAnchorSummary.
        Resource Anchor Name in the Cloud Service Provider.


        :param csp_resource_anchor_name: The csp_resource_anchor_name of this ResourceAnchorSummary.
        :type: str
        """
        self._csp_resource_anchor_name = csp_resource_anchor_name

    @property
    def csp_additional_properties(self):
        """
        Gets the csp_additional_properties of this ResourceAnchorSummary.
        CSP Specific Additional Properties, AzureSubnetId for Azure


        :return: The csp_additional_properties of this ResourceAnchorSummary.
        :rtype: dict(str, str)
        """
        return self._csp_additional_properties

    @csp_additional_properties.setter
    def csp_additional_properties(self, csp_additional_properties):
        """
        Sets the csp_additional_properties of this ResourceAnchorSummary.
        CSP Specific Additional Properties, AzureSubnetId for Azure


        :param csp_additional_properties: The csp_additional_properties of this ResourceAnchorSummary.
        :type: dict(str, str)
        """
        self._csp_additional_properties = csp_additional_properties

    @property
    def time_created(self):
        """
        **[Required]** Gets the time_created of this ResourceAnchorSummary.
        The date and time the ResourceAnchor was created, in the format defined by `RFC 3339`__.

        Example: `2016-08-25T21:10:29.600Z`

        __ https://tools.ietf.org/html/rfc3339


        :return: The time_created of this ResourceAnchorSummary.
        :rtype: datetime
        """
        return self._time_created

    @time_created.setter
    def time_created(self, time_created):
        """
        Sets the time_created of this ResourceAnchorSummary.
        The date and time the ResourceAnchor was created, in the format defined by `RFC 3339`__.

        Example: `2016-08-25T21:10:29.600Z`

        __ https://tools.ietf.org/html/rfc3339


        :param time_created: The time_created of this ResourceAnchorSummary.
        :type: datetime
        """
        self._time_created = time_created

    @property
    def time_updated(self):
        """
        Gets the time_updated of this ResourceAnchorSummary.
        The date and time the ResourceAnchor was updated, in the format defined by `RFC 3339`__.

        Example: `2016-08-25T21:10:29.600Z`

        __ https://tools.ietf.org/html/rfc3339


        :return: The time_updated of this ResourceAnchorSummary.
        :rtype: datetime
        """
        return self._time_updated

    @time_updated.setter
    def time_updated(self, time_updated):
        """
        Sets the time_updated of this ResourceAnchorSummary.
        The date and time the ResourceAnchor was updated, in the format defined by `RFC 3339`__.

        Example: `2016-08-25T21:10:29.600Z`

        __ https://tools.ietf.org/html/rfc3339


        :param time_updated: The time_updated of this ResourceAnchorSummary.
        :type: datetime
        """
        self._time_updated = time_updated

    @property
    def lifecycle_state(self):
        """
        **[Required]** Gets the lifecycle_state of this ResourceAnchorSummary.
        The current state of the ResourceAnchor.


        :return: The lifecycle_state of this ResourceAnchorSummary.
        :rtype: str
        """
        return self._lifecycle_state

    @lifecycle_state.setter
    def lifecycle_state(self, lifecycle_state):
        """
        Sets the lifecycle_state of this ResourceAnchorSummary.
        The current state of the ResourceAnchor.


        :param lifecycle_state: The lifecycle_state of this ResourceAnchorSummary.
        :type: str
        """
        self._lifecycle_state = lifecycle_state

    @property
    def lifecycle_details(self):
        """
        Gets the lifecycle_details of this ResourceAnchorSummary.
        A message that describes the current state of the ResourceAnchor in more detail. For example,
        can be used to provide actionable information for a resource in the Failed state.


        :return: The lifecycle_details of this ResourceAnchorSummary.
        :rtype: str
        """
        return self._lifecycle_details

    @lifecycle_details.setter
    def lifecycle_details(self, lifecycle_details):
        """
        Sets the lifecycle_details of this ResourceAnchorSummary.
        A message that describes the current state of the ResourceAnchor in more detail. For example,
        can be used to provide actionable information for a resource in the Failed state.


        :param lifecycle_details: The lifecycle_details of this ResourceAnchorSummary.
        :type: str
        """
        self._lifecycle_details = lifecycle_details

    @property
    def freeform_tags(self):
        """
        **[Required]** Gets the freeform_tags of this ResourceAnchorSummary.
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace.
        For more information, see `Resource Tags`__.

        Example: `{\"Department\": \"Finance\"}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :return: The freeform_tags of this ResourceAnchorSummary.
        :rtype: dict(str, str)
        """
        return self._freeform_tags

    @freeform_tags.setter
    def freeform_tags(self, freeform_tags):
        """
        Sets the freeform_tags of this ResourceAnchorSummary.
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace.
        For more information, see `Resource Tags`__.

        Example: `{\"Department\": \"Finance\"}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :param freeform_tags: The freeform_tags of this ResourceAnchorSummary.
        :type: dict(str, str)
        """
        self._freeform_tags = freeform_tags

    @property
    def defined_tags(self):
        """
        **[Required]** Gets the defined_tags of this ResourceAnchorSummary.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        For more information, see `Resource Tags`__.

        Example: `{\"Operations\": {\"CostCenter\": \"42\"}}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :return: The defined_tags of this ResourceAnchorSummary.
        :rtype: dict(str, dict(str, object))
        """
        return self._defined_tags

    @defined_tags.setter
    def defined_tags(self, defined_tags):
        """
        Sets the defined_tags of this ResourceAnchorSummary.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        For more information, see `Resource Tags`__.

        Example: `{\"Operations\": {\"CostCenter\": \"42\"}}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :param defined_tags: The defined_tags of this ResourceAnchorSummary.
        :type: dict(str, dict(str, object))
        """
        self._defined_tags = defined_tags

    @property
    def subscription_id(self):
        """
        **[Required]** Gets the subscription_id of this ResourceAnchorSummary.
        Oracle Cloud Infrastructure Subscription Id


        :return: The subscription_id of this ResourceAnchorSummary.
        :rtype: str
        """
        return self._subscription_id

    @subscription_id.setter
    def subscription_id(self, subscription_id):
        """
        Sets the subscription_id of this ResourceAnchorSummary.
        Oracle Cloud Infrastructure Subscription Id


        :param subscription_id: The subscription_id of this ResourceAnchorSummary.
        :type: str
        """
        self._subscription_id = subscription_id

    @property
    def system_tags(self):
        """
        Gets the system_tags of this ResourceAnchorSummary.
        System tags for this resource. Each key is predefined and scoped to a namespace.

        Example: `{\"orcl-cloud\": {\"free-tier-retained\": \"true\"}}`


        :return: The system_tags of this ResourceAnchorSummary.
        :rtype: dict(str, dict(str, object))
        """
        return self._system_tags

    @system_tags.setter
    def system_tags(self, system_tags):
        """
        Sets the system_tags of this ResourceAnchorSummary.
        System tags for this resource. Each key is predefined and scoped to a namespace.

        Example: `{\"orcl-cloud\": {\"free-tier-retained\": \"true\"}}`


        :param system_tags: The system_tags of this ResourceAnchorSummary.
        :type: dict(str, dict(str, object))
        """
        self._system_tags = system_tags

    @property
    def linked_compartment_id(self):
        """
        Gets the linked_compartment_id of this ResourceAnchorSummary.
        Optional - Oracle Cloud Infrastructure compartment Id (OCID) which was created or linked by customer with resource anchor.
        This compartmentId is different from where resource Anchor live.


        :return: The linked_compartment_id of this ResourceAnchorSummary.
        :rtype: str
        """
        return self._linked_compartment_id

    @linked_compartment_id.setter
    def linked_compartment_id(self, linked_compartment_id):
        """
        Sets the linked_compartment_id of this ResourceAnchorSummary.
        Optional - Oracle Cloud Infrastructure compartment Id (OCID) which was created or linked by customer with resource anchor.
        This compartmentId is different from where resource Anchor live.


        :param linked_compartment_id: The linked_compartment_id of this ResourceAnchorSummary.
        :type: str
        """
        self._linked_compartment_id = linked_compartment_id

    @property
    def linked_compartment_name(self):
        """
        Gets the linked_compartment_name of this ResourceAnchorSummary.
        The name assigned to the compartment which was created or linked by customer with resource anchor. This compartment is different from where resource Anchor live.


        :return: The linked_compartment_name of this ResourceAnchorSummary.
        :rtype: str
        """
        return self._linked_compartment_name

    @linked_compartment_name.setter
    def linked_compartment_name(self, linked_compartment_name):
        """
        Sets the linked_compartment_name of this ResourceAnchorSummary.
        The name assigned to the compartment which was created or linked by customer with resource anchor. This compartment is different from where resource Anchor live.


        :param linked_compartment_name: The linked_compartment_name of this ResourceAnchorSummary.
        :type: str
        """
        self._linked_compartment_name = linked_compartment_name

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
