# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20190415


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class SecureConnectionDetails(object):
    """
    Secure connection configuration details.
    """

    #: A constant which can be used with the certificate_generation_type property of a SecureConnectionDetails.
    #: This constant has a value of "SYSTEM"
    CERTIFICATE_GENERATION_TYPE_SYSTEM = "SYSTEM"

    #: A constant which can be used with the certificate_generation_type property of a SecureConnectionDetails.
    #: This constant has a value of "BYOC"
    CERTIFICATE_GENERATION_TYPE_BYOC = "BYOC"

    def __init__(self, **kwargs):
        """
        Initializes a new SecureConnectionDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param certificate_id:
            The value to assign to the certificate_id property of this SecureConnectionDetails.
        :type certificate_id: str

        :param certificate_generation_type:
            The value to assign to the certificate_generation_type property of this SecureConnectionDetails.
            Allowed values for this property are: "SYSTEM", "BYOC", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type certificate_generation_type: str

        """
        self.swagger_types = {
            'certificate_id': 'str',
            'certificate_generation_type': 'str'
        }
        self.attribute_map = {
            'certificate_id': 'certificateId',
            'certificate_generation_type': 'certificateGenerationType'
        }
        self._certificate_id = None
        self._certificate_generation_type = None

    @property
    def certificate_id(self):
        """
        Gets the certificate_id of this SecureConnectionDetails.
        The OCID of the certificate to use.


        :return: The certificate_id of this SecureConnectionDetails.
        :rtype: str
        """
        return self._certificate_id

    @certificate_id.setter
    def certificate_id(self, certificate_id):
        """
        Sets the certificate_id of this SecureConnectionDetails.
        The OCID of the certificate to use.


        :param certificate_id: The certificate_id of this SecureConnectionDetails.
        :type: str
        """
        self._certificate_id = certificate_id

    @property
    def certificate_generation_type(self):
        """
        **[Required]** Gets the certificate_generation_type of this SecureConnectionDetails.
        Select whether to use MySQL Database Service-managed certificate (SYSTEM) or your own certificate (BYOC).

        Allowed values for this property are: "SYSTEM", "BYOC", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The certificate_generation_type of this SecureConnectionDetails.
        :rtype: str
        """
        return self._certificate_generation_type

    @certificate_generation_type.setter
    def certificate_generation_type(self, certificate_generation_type):
        """
        Sets the certificate_generation_type of this SecureConnectionDetails.
        Select whether to use MySQL Database Service-managed certificate (SYSTEM) or your own certificate (BYOC).


        :param certificate_generation_type: The certificate_generation_type of this SecureConnectionDetails.
        :type: str
        """
        allowed_values = ["SYSTEM", "BYOC"]
        if not value_allowed_none_or_none_sentinel(certificate_generation_type, allowed_values):
            certificate_generation_type = 'UNKNOWN_ENUM_VALUE'
        self._certificate_generation_type = certificate_generation_type

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
