# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20230501


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class SecurityRuleMatchCriteria(object):
    """
    Criteria to evaluate against network traffic.
    A match occurs when at least one item in the array associated with each specified property corresponds with the relevant aspect of the traffic.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new SecurityRuleMatchCriteria object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param source_address:
            The value to assign to the source_address property of this SecurityRuleMatchCriteria.
        :type source_address: list[str]

        :param destination_address:
            The value to assign to the destination_address property of this SecurityRuleMatchCriteria.
        :type destination_address: list[str]

        :param application:
            The value to assign to the application property of this SecurityRuleMatchCriteria.
        :type application: list[str]

        :param service:
            The value to assign to the service property of this SecurityRuleMatchCriteria.
        :type service: list[str]

        :param url:
            The value to assign to the url property of this SecurityRuleMatchCriteria.
        :type url: list[str]

        """
        self.swagger_types = {
            'source_address': 'list[str]',
            'destination_address': 'list[str]',
            'application': 'list[str]',
            'service': 'list[str]',
            'url': 'list[str]'
        }
        self.attribute_map = {
            'source_address': 'sourceAddress',
            'destination_address': 'destinationAddress',
            'application': 'application',
            'service': 'service',
            'url': 'url'
        }
        self._source_address = None
        self._destination_address = None
        self._application = None
        self._service = None
        self._url = None

    @property
    def source_address(self):
        """
        Gets the source_address of this SecurityRuleMatchCriteria.
        An array of IP address list names to be evaluated against the traffic source address.


        :return: The source_address of this SecurityRuleMatchCriteria.
        :rtype: list[str]
        """
        return self._source_address

    @source_address.setter
    def source_address(self, source_address):
        """
        Sets the source_address of this SecurityRuleMatchCriteria.
        An array of IP address list names to be evaluated against the traffic source address.


        :param source_address: The source_address of this SecurityRuleMatchCriteria.
        :type: list[str]
        """
        self._source_address = source_address

    @property
    def destination_address(self):
        """
        Gets the destination_address of this SecurityRuleMatchCriteria.
        An array of IP address list names to be evaluated against the traffic destination address.


        :return: The destination_address of this SecurityRuleMatchCriteria.
        :rtype: list[str]
        """
        return self._destination_address

    @destination_address.setter
    def destination_address(self, destination_address):
        """
        Sets the destination_address of this SecurityRuleMatchCriteria.
        An array of IP address list names to be evaluated against the traffic destination address.


        :param destination_address: The destination_address of this SecurityRuleMatchCriteria.
        :type: list[str]
        """
        self._destination_address = destination_address

    @property
    def application(self):
        """
        Gets the application of this SecurityRuleMatchCriteria.
        An array of application list names to be evaluated against the traffic protocol and protocol-specific parameters.


        :return: The application of this SecurityRuleMatchCriteria.
        :rtype: list[str]
        """
        return self._application

    @application.setter
    def application(self, application):
        """
        Sets the application of this SecurityRuleMatchCriteria.
        An array of application list names to be evaluated against the traffic protocol and protocol-specific parameters.


        :param application: The application of this SecurityRuleMatchCriteria.
        :type: list[str]
        """
        self._application = application

    @property
    def service(self):
        """
        Gets the service of this SecurityRuleMatchCriteria.
        An array of service list names to be evaluated against the traffic protocol and protocol-specific parameters.


        :return: The service of this SecurityRuleMatchCriteria.
        :rtype: list[str]
        """
        return self._service

    @service.setter
    def service(self, service):
        """
        Sets the service of this SecurityRuleMatchCriteria.
        An array of service list names to be evaluated against the traffic protocol and protocol-specific parameters.


        :param service: The service of this SecurityRuleMatchCriteria.
        :type: list[str]
        """
        self._service = service

    @property
    def url(self):
        """
        Gets the url of this SecurityRuleMatchCriteria.
        An array of URL pattern list names to be evaluated against the HTTP(S) request target.


        :return: The url of this SecurityRuleMatchCriteria.
        :rtype: list[str]
        """
        return self._url

    @url.setter
    def url(self, url):
        """
        Sets the url of this SecurityRuleMatchCriteria.
        An array of URL pattern list names to be evaluated against the HTTP(S) request target.


        :param url: The url of this SecurityRuleMatchCriteria.
        :type: list[str]
        """
        self._url = url

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
