# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20160918


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class CreatePrivateEndpointDetails(object):
    """
    Details to create a private endpoint
    """

    def __init__(self, **kwargs):
        """
        Initializes a new CreatePrivateEndpointDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param name:
            The value to assign to the name property of this CreatePrivateEndpointDetails.
        :type name: str

        :param compartment_id:
            The value to assign to the compartment_id property of this CreatePrivateEndpointDetails.
        :type compartment_id: str

        :param subnet_id:
            The value to assign to the subnet_id property of this CreatePrivateEndpointDetails.
        :type subnet_id: str

        :param prefix:
            The value to assign to the prefix property of this CreatePrivateEndpointDetails.
        :type prefix: str

        :param additional_prefixes:
            The value to assign to the additional_prefixes property of this CreatePrivateEndpointDetails.
        :type additional_prefixes: list[str]

        :param private_endpoint_ip:
            The value to assign to the private_endpoint_ip property of this CreatePrivateEndpointDetails.
        :type private_endpoint_ip: str

        :param nsg_ids:
            The value to assign to the nsg_ids property of this CreatePrivateEndpointDetails.
        :type nsg_ids: list[str]

        :param access_targets:
            The value to assign to the access_targets property of this CreatePrivateEndpointDetails.
        :type access_targets: list[oci.object_storage.models.AccessTargetDetails]

        :param freeform_tags:
            The value to assign to the freeform_tags property of this CreatePrivateEndpointDetails.
        :type freeform_tags: dict(str, str)

        :param defined_tags:
            The value to assign to the defined_tags property of this CreatePrivateEndpointDetails.
        :type defined_tags: dict(str, dict(str, object))

        """
        self.swagger_types = {
            'name': 'str',
            'compartment_id': 'str',
            'subnet_id': 'str',
            'prefix': 'str',
            'additional_prefixes': 'list[str]',
            'private_endpoint_ip': 'str',
            'nsg_ids': 'list[str]',
            'access_targets': 'list[AccessTargetDetails]',
            'freeform_tags': 'dict(str, str)',
            'defined_tags': 'dict(str, dict(str, object))'
        }
        self.attribute_map = {
            'name': 'name',
            'compartment_id': 'compartmentId',
            'subnet_id': 'subnetId',
            'prefix': 'prefix',
            'additional_prefixes': 'additionalPrefixes',
            'private_endpoint_ip': 'privateEndpointIp',
            'nsg_ids': 'nsgIds',
            'access_targets': 'accessTargets',
            'freeform_tags': 'freeformTags',
            'defined_tags': 'definedTags'
        }
        self._name = None
        self._compartment_id = None
        self._subnet_id = None
        self._prefix = None
        self._additional_prefixes = None
        self._private_endpoint_ip = None
        self._nsg_ids = None
        self._access_targets = None
        self._freeform_tags = None
        self._defined_tags = None

    @property
    def name(self):
        """
        **[Required]** Gets the name of this CreatePrivateEndpointDetails.
        This name associated with the endpoint. Valid characters are uppercase or lowercase letters, numbers, hyphens,
         underscores, and periods.
        Example: my-new-private-endpoint1


        :return: The name of this CreatePrivateEndpointDetails.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this CreatePrivateEndpointDetails.
        This name associated with the endpoint. Valid characters are uppercase or lowercase letters, numbers, hyphens,
         underscores, and periods.
        Example: my-new-private-endpoint1


        :param name: The name of this CreatePrivateEndpointDetails.
        :type: str
        """
        self._name = name

    @property
    def compartment_id(self):
        """
        **[Required]** Gets the compartment_id of this CreatePrivateEndpointDetails.
        The ID of the compartment in which to create the Private Endpoint.


        :return: The compartment_id of this CreatePrivateEndpointDetails.
        :rtype: str
        """
        return self._compartment_id

    @compartment_id.setter
    def compartment_id(self, compartment_id):
        """
        Sets the compartment_id of this CreatePrivateEndpointDetails.
        The ID of the compartment in which to create the Private Endpoint.


        :param compartment_id: The compartment_id of this CreatePrivateEndpointDetails.
        :type: str
        """
        self._compartment_id = compartment_id

    @property
    def subnet_id(self):
        """
        **[Required]** Gets the subnet_id of this CreatePrivateEndpointDetails.
        The OCID of the customer's subnet where the private endpoint VNIC will reside.


        :return: The subnet_id of this CreatePrivateEndpointDetails.
        :rtype: str
        """
        return self._subnet_id

    @subnet_id.setter
    def subnet_id(self, subnet_id):
        """
        Sets the subnet_id of this CreatePrivateEndpointDetails.
        The OCID of the customer's subnet where the private endpoint VNIC will reside.


        :param subnet_id: The subnet_id of this CreatePrivateEndpointDetails.
        :type: str
        """
        self._subnet_id = subnet_id

    @property
    def prefix(self):
        """
        **[Required]** Gets the prefix of this CreatePrivateEndpointDetails.
        A prefix to use for the private endpoint. The customer VCN's DNS records are
        updated with this prefix. The prefix input from the customer will be the first sub-domain in the endpointFqdn.
        Example: If the prefix chosen is \"abc\", then the endpointFqdn will be 'abc.private.objectstorage.<region>.oraclecloud.com'


        :return: The prefix of this CreatePrivateEndpointDetails.
        :rtype: str
        """
        return self._prefix

    @prefix.setter
    def prefix(self, prefix):
        """
        Sets the prefix of this CreatePrivateEndpointDetails.
        A prefix to use for the private endpoint. The customer VCN's DNS records are
        updated with this prefix. The prefix input from the customer will be the first sub-domain in the endpointFqdn.
        Example: If the prefix chosen is \"abc\", then the endpointFqdn will be 'abc.private.objectstorage.<region>.oraclecloud.com'


        :param prefix: The prefix of this CreatePrivateEndpointDetails.
        :type: str
        """
        self._prefix = prefix

    @property
    def additional_prefixes(self):
        """
        Gets the additional_prefixes of this CreatePrivateEndpointDetails.
        A list of additional prefix that you can provide along with any other prefix. These resulting endpointFqdn's are added to the
        customer VCN's DNS record.


        :return: The additional_prefixes of this CreatePrivateEndpointDetails.
        :rtype: list[str]
        """
        return self._additional_prefixes

    @additional_prefixes.setter
    def additional_prefixes(self, additional_prefixes):
        """
        Sets the additional_prefixes of this CreatePrivateEndpointDetails.
        A list of additional prefix that you can provide along with any other prefix. These resulting endpointFqdn's are added to the
        customer VCN's DNS record.


        :param additional_prefixes: The additional_prefixes of this CreatePrivateEndpointDetails.
        :type: list[str]
        """
        self._additional_prefixes = additional_prefixes

    @property
    def private_endpoint_ip(self):
        """
        Gets the private_endpoint_ip of this CreatePrivateEndpointDetails.
        The private IP address to assign to this private endpoint. If you provide a value,
        it must be an available IP address in the customer's subnet. If it's not available, an error
        is returned.

        If you do not provide a value, an available IP address in the subnet is automatically chosen.


        :return: The private_endpoint_ip of this CreatePrivateEndpointDetails.
        :rtype: str
        """
        return self._private_endpoint_ip

    @private_endpoint_ip.setter
    def private_endpoint_ip(self, private_endpoint_ip):
        """
        Sets the private_endpoint_ip of this CreatePrivateEndpointDetails.
        The private IP address to assign to this private endpoint. If you provide a value,
        it must be an available IP address in the customer's subnet. If it's not available, an error
        is returned.

        If you do not provide a value, an available IP address in the subnet is automatically chosen.


        :param private_endpoint_ip: The private_endpoint_ip of this CreatePrivateEndpointDetails.
        :type: str
        """
        self._private_endpoint_ip = private_endpoint_ip

    @property
    def nsg_ids(self):
        """
        Gets the nsg_ids of this CreatePrivateEndpointDetails.
        A list of the OCIDs of the network security groups (NSGs) to add the private endpoint's VNIC to.
        For more information about NSGs, see
        :class:`NetworkSecurityGroup`.


        :return: The nsg_ids of this CreatePrivateEndpointDetails.
        :rtype: list[str]
        """
        return self._nsg_ids

    @nsg_ids.setter
    def nsg_ids(self, nsg_ids):
        """
        Sets the nsg_ids of this CreatePrivateEndpointDetails.
        A list of the OCIDs of the network security groups (NSGs) to add the private endpoint's VNIC to.
        For more information about NSGs, see
        :class:`NetworkSecurityGroup`.


        :param nsg_ids: The nsg_ids of this CreatePrivateEndpointDetails.
        :type: list[str]
        """
        self._nsg_ids = nsg_ids

    @property
    def access_targets(self):
        """
        **[Required]** Gets the access_targets of this CreatePrivateEndpointDetails.
        A list of targets that can be accessed by the private endpoint.


        :return: The access_targets of this CreatePrivateEndpointDetails.
        :rtype: list[oci.object_storage.models.AccessTargetDetails]
        """
        return self._access_targets

    @access_targets.setter
    def access_targets(self, access_targets):
        """
        Sets the access_targets of this CreatePrivateEndpointDetails.
        A list of targets that can be accessed by the private endpoint.


        :param access_targets: The access_targets of this CreatePrivateEndpointDetails.
        :type: list[oci.object_storage.models.AccessTargetDetails]
        """
        self._access_targets = access_targets

    @property
    def freeform_tags(self):
        """
        Gets the freeform_tags of this CreatePrivateEndpointDetails.
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace.
        For more information, see `Resource Tags`__.
        Example: `{\"Department\": \"Finance\"}`

        __ https://docs.cloud.oracle.com/Content/General/Concepts/resourcetags.htm


        :return: The freeform_tags of this CreatePrivateEndpointDetails.
        :rtype: dict(str, str)
        """
        return self._freeform_tags

    @freeform_tags.setter
    def freeform_tags(self, freeform_tags):
        """
        Sets the freeform_tags of this CreatePrivateEndpointDetails.
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace.
        For more information, see `Resource Tags`__.
        Example: `{\"Department\": \"Finance\"}`

        __ https://docs.cloud.oracle.com/Content/General/Concepts/resourcetags.htm


        :param freeform_tags: The freeform_tags of this CreatePrivateEndpointDetails.
        :type: dict(str, str)
        """
        self._freeform_tags = freeform_tags

    @property
    def defined_tags(self):
        """
        Gets the defined_tags of this CreatePrivateEndpointDetails.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        For more information, see `Resource Tags`__.
        Example: `{\"Operations\": {\"CostCenter\": \"42\"}}`

        __ https://docs.cloud.oracle.com/Content/General/Concepts/resourcetags.htm


        :return: The defined_tags of this CreatePrivateEndpointDetails.
        :rtype: dict(str, dict(str, object))
        """
        return self._defined_tags

    @defined_tags.setter
    def defined_tags(self, defined_tags):
        """
        Sets the defined_tags of this CreatePrivateEndpointDetails.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        For more information, see `Resource Tags`__.
        Example: `{\"Operations\": {\"CostCenter\": \"42\"}}`

        __ https://docs.cloud.oracle.com/Content/General/Concepts/resourcetags.htm


        :param defined_tags: The defined_tags of this CreatePrivateEndpointDetails.
        :type: dict(str, dict(str, object))
        """
        self._defined_tags = defined_tags

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
