# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20190506


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class EntityAction(object):
    """
    Action of an entity
    """

    def __init__(self, **kwargs):
        """
        Initializes a new EntityAction object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param name:
            The value to assign to the name property of this EntityAction.
        :type name: str

        :param crud_type:
            The value to assign to the crud_type property of this EntityAction.
        :type crud_type: str

        :param natural_language_mapping:
            The value to assign to the natural_language_mapping property of this EntityAction.
        :type natural_language_mapping: oci.oda.models.EntityActionNaturalLanguageMapping

        :param arguments:
            The value to assign to the arguments property of this EntityAction.
        :type arguments: list[oci.oda.models.EntityActionArgument]

        """
        self.swagger_types = {
            'name': 'str',
            'crud_type': 'str',
            'natural_language_mapping': 'EntityActionNaturalLanguageMapping',
            'arguments': 'list[EntityActionArgument]'
        }
        self.attribute_map = {
            'name': 'name',
            'crud_type': 'crudType',
            'natural_language_mapping': 'naturalLanguageMapping',
            'arguments': 'arguments'
        }
        self._name = None
        self._crud_type = None
        self._natural_language_mapping = None
        self._arguments = None

    @property
    def name(self):
        """
        **[Required]** Gets the name of this EntityAction.
        Name of an entity action


        :return: The name of this EntityAction.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this EntityAction.
        Name of an entity action


        :param name: The name of this EntityAction.
        :type: str
        """
        self._name = name

    @property
    def crud_type(self):
        """
        Gets the crud_type of this EntityAction.
        Type of CRUD operation for entity action


        :return: The crud_type of this EntityAction.
        :rtype: str
        """
        return self._crud_type

    @crud_type.setter
    def crud_type(self, crud_type):
        """
        Sets the crud_type of this EntityAction.
        Type of CRUD operation for entity action


        :param crud_type: The crud_type of this EntityAction.
        :type: str
        """
        self._crud_type = crud_type

    @property
    def natural_language_mapping(self):
        """
        Gets the natural_language_mapping of this EntityAction.

        :return: The natural_language_mapping of this EntityAction.
        :rtype: oci.oda.models.EntityActionNaturalLanguageMapping
        """
        return self._natural_language_mapping

    @natural_language_mapping.setter
    def natural_language_mapping(self, natural_language_mapping):
        """
        Sets the natural_language_mapping of this EntityAction.

        :param natural_language_mapping: The natural_language_mapping of this EntityAction.
        :type: oci.oda.models.EntityActionNaturalLanguageMapping
        """
        self._natural_language_mapping = natural_language_mapping

    @property
    def arguments(self):
        """
        **[Required]** Gets the arguments of this EntityAction.
        List of entity action arguments


        :return: The arguments of this EntityAction.
        :rtype: list[oci.oda.models.EntityActionArgument]
        """
        return self._arguments

    @arguments.setter
    def arguments(self, arguments):
        """
        Sets the arguments of this EntityAction.
        List of entity action arguments


        :param arguments: The arguments of this EntityAction.
        :type: list[oci.oda.models.EntityActionArgument]
        """
        self._arguments = arguments

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
