# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20180828


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class CreateOpensearchClusterPipelineDetails(object):
    """
    The configuration details for a new OpenSearch cluster pipeline.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new CreateOpensearchClusterPipelineDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param display_name:
            The value to assign to the display_name property of this CreateOpensearchClusterPipelineDetails.
        :type display_name: str

        :param ocpu_count:
            The value to assign to the ocpu_count property of this CreateOpensearchClusterPipelineDetails.
        :type ocpu_count: int

        :param memory_gb:
            The value to assign to the memory_gb property of this CreateOpensearchClusterPipelineDetails.
        :type memory_gb: int

        :param node_count:
            The value to assign to the node_count property of this CreateOpensearchClusterPipelineDetails.
        :type node_count: int

        :param node_shape:
            The value to assign to the node_shape property of this CreateOpensearchClusterPipelineDetails.
        :type node_shape: str

        :param pipeline_configuration_body:
            The value to assign to the pipeline_configuration_body property of this CreateOpensearchClusterPipelineDetails.
        :type pipeline_configuration_body: str

        :param data_prepper_configuration_body:
            The value to assign to the data_prepper_configuration_body property of this CreateOpensearchClusterPipelineDetails.
        :type data_prepper_configuration_body: str

        :param compartment_id:
            The value to assign to the compartment_id property of this CreateOpensearchClusterPipelineDetails.
        :type compartment_id: str

        :param vcn_id:
            The value to assign to the vcn_id property of this CreateOpensearchClusterPipelineDetails.
        :type vcn_id: str

        :param subnet_id:
            The value to assign to the subnet_id property of this CreateOpensearchClusterPipelineDetails.
        :type subnet_id: str

        :param vcn_compartment_id:
            The value to assign to the vcn_compartment_id property of this CreateOpensearchClusterPipelineDetails.
        :type vcn_compartment_id: str

        :param subnet_compartment_id:
            The value to assign to the subnet_compartment_id property of this CreateOpensearchClusterPipelineDetails.
        :type subnet_compartment_id: str

        :param nsg_id:
            The value to assign to the nsg_id property of this CreateOpensearchClusterPipelineDetails.
        :type nsg_id: str

        :param reverse_connection_endpoints:
            The value to assign to the reverse_connection_endpoints property of this CreateOpensearchClusterPipelineDetails.
        :type reverse_connection_endpoints: list[oci.opensearch.models.OpensearchPipelineReverseConnectionEndpoint]

        :param freeform_tags:
            The value to assign to the freeform_tags property of this CreateOpensearchClusterPipelineDetails.
        :type freeform_tags: dict(str, str)

        :param defined_tags:
            The value to assign to the defined_tags property of this CreateOpensearchClusterPipelineDetails.
        :type defined_tags: dict(str, dict(str, object))

        """
        self.swagger_types = {
            'display_name': 'str',
            'ocpu_count': 'int',
            'memory_gb': 'int',
            'node_count': 'int',
            'node_shape': 'str',
            'pipeline_configuration_body': 'str',
            'data_prepper_configuration_body': 'str',
            'compartment_id': 'str',
            'vcn_id': 'str',
            'subnet_id': 'str',
            'vcn_compartment_id': 'str',
            'subnet_compartment_id': 'str',
            'nsg_id': 'str',
            'reverse_connection_endpoints': 'list[OpensearchPipelineReverseConnectionEndpoint]',
            'freeform_tags': 'dict(str, str)',
            'defined_tags': 'dict(str, dict(str, object))'
        }
        self.attribute_map = {
            'display_name': 'displayName',
            'ocpu_count': 'ocpuCount',
            'memory_gb': 'memoryGB',
            'node_count': 'nodeCount',
            'node_shape': 'nodeShape',
            'pipeline_configuration_body': 'pipelineConfigurationBody',
            'data_prepper_configuration_body': 'dataPrepperConfigurationBody',
            'compartment_id': 'compartmentId',
            'vcn_id': 'vcnId',
            'subnet_id': 'subnetId',
            'vcn_compartment_id': 'vcnCompartmentId',
            'subnet_compartment_id': 'subnetCompartmentId',
            'nsg_id': 'nsgId',
            'reverse_connection_endpoints': 'reverseConnectionEndpoints',
            'freeform_tags': 'freeformTags',
            'defined_tags': 'definedTags'
        }
        self._display_name = None
        self._ocpu_count = None
        self._memory_gb = None
        self._node_count = None
        self._node_shape = None
        self._pipeline_configuration_body = None
        self._data_prepper_configuration_body = None
        self._compartment_id = None
        self._vcn_id = None
        self._subnet_id = None
        self._vcn_compartment_id = None
        self._subnet_compartment_id = None
        self._nsg_id = None
        self._reverse_connection_endpoints = None
        self._freeform_tags = None
        self._defined_tags = None

    @property
    def display_name(self):
        """
        **[Required]** Gets the display_name of this CreateOpensearchClusterPipelineDetails.
        The name of the cluster pipeline. Avoid entering confidential information.


        :return: The display_name of this CreateOpensearchClusterPipelineDetails.
        :rtype: str
        """
        return self._display_name

    @display_name.setter
    def display_name(self, display_name):
        """
        Sets the display_name of this CreateOpensearchClusterPipelineDetails.
        The name of the cluster pipeline. Avoid entering confidential information.


        :param display_name: The display_name of this CreateOpensearchClusterPipelineDetails.
        :type: str
        """
        self._display_name = display_name

    @property
    def ocpu_count(self):
        """
        **[Required]** Gets the ocpu_count of this CreateOpensearchClusterPipelineDetails.
        The number of OCPUs configured for each pipeline node.


        :return: The ocpu_count of this CreateOpensearchClusterPipelineDetails.
        :rtype: int
        """
        return self._ocpu_count

    @ocpu_count.setter
    def ocpu_count(self, ocpu_count):
        """
        Sets the ocpu_count of this CreateOpensearchClusterPipelineDetails.
        The number of OCPUs configured for each pipeline node.


        :param ocpu_count: The ocpu_count of this CreateOpensearchClusterPipelineDetails.
        :type: int
        """
        self._ocpu_count = ocpu_count

    @property
    def memory_gb(self):
        """
        **[Required]** Gets the memory_gb of this CreateOpensearchClusterPipelineDetails.
        The amount of memory in GB, for each pipeline node.


        :return: The memory_gb of this CreateOpensearchClusterPipelineDetails.
        :rtype: int
        """
        return self._memory_gb

    @memory_gb.setter
    def memory_gb(self, memory_gb):
        """
        Sets the memory_gb of this CreateOpensearchClusterPipelineDetails.
        The amount of memory in GB, for each pipeline node.


        :param memory_gb: The memory_gb of this CreateOpensearchClusterPipelineDetails.
        :type: int
        """
        self._memory_gb = memory_gb

    @property
    def node_count(self):
        """
        **[Required]** Gets the node_count of this CreateOpensearchClusterPipelineDetails.
        The number of nodes configured for the pipeline.


        :return: The node_count of this CreateOpensearchClusterPipelineDetails.
        :rtype: int
        """
        return self._node_count

    @node_count.setter
    def node_count(self, node_count):
        """
        Sets the node_count of this CreateOpensearchClusterPipelineDetails.
        The number of nodes configured for the pipeline.


        :param node_count: The node_count of this CreateOpensearchClusterPipelineDetails.
        :type: int
        """
        self._node_count = node_count

    @property
    def node_shape(self):
        """
        Gets the node_shape of this CreateOpensearchClusterPipelineDetails.
        The pipeline node shape.


        :return: The node_shape of this CreateOpensearchClusterPipelineDetails.
        :rtype: str
        """
        return self._node_shape

    @node_shape.setter
    def node_shape(self, node_shape):
        """
        Sets the node_shape of this CreateOpensearchClusterPipelineDetails.
        The pipeline node shape.


        :param node_shape: The node_shape of this CreateOpensearchClusterPipelineDetails.
        :type: str
        """
        self._node_shape = node_shape

    @property
    def pipeline_configuration_body(self):
        """
        **[Required]** Gets the pipeline_configuration_body of this CreateOpensearchClusterPipelineDetails.
        The pipeline configuration in YAML format. The command accepts the pipeline configuration as a string or within a .yaml file. If you provide the configuration as a string, each new line must be escaped with \\.


        :return: The pipeline_configuration_body of this CreateOpensearchClusterPipelineDetails.
        :rtype: str
        """
        return self._pipeline_configuration_body

    @pipeline_configuration_body.setter
    def pipeline_configuration_body(self, pipeline_configuration_body):
        """
        Sets the pipeline_configuration_body of this CreateOpensearchClusterPipelineDetails.
        The pipeline configuration in YAML format. The command accepts the pipeline configuration as a string or within a .yaml file. If you provide the configuration as a string, each new line must be escaped with \\.


        :param pipeline_configuration_body: The pipeline_configuration_body of this CreateOpensearchClusterPipelineDetails.
        :type: str
        """
        self._pipeline_configuration_body = pipeline_configuration_body

    @property
    def data_prepper_configuration_body(self):
        """
        **[Required]** Gets the data_prepper_configuration_body of this CreateOpensearchClusterPipelineDetails.
        The data prepper config in YAML format. The command accepts the data prepper config as a string or within a .yaml file. If you provide the configuration as a string, each new line must be escaped with \\.


        :return: The data_prepper_configuration_body of this CreateOpensearchClusterPipelineDetails.
        :rtype: str
        """
        return self._data_prepper_configuration_body

    @data_prepper_configuration_body.setter
    def data_prepper_configuration_body(self, data_prepper_configuration_body):
        """
        Sets the data_prepper_configuration_body of this CreateOpensearchClusterPipelineDetails.
        The data prepper config in YAML format. The command accepts the data prepper config as a string or within a .yaml file. If you provide the configuration as a string, each new line must be escaped with \\.


        :param data_prepper_configuration_body: The data_prepper_configuration_body of this CreateOpensearchClusterPipelineDetails.
        :type: str
        """
        self._data_prepper_configuration_body = data_prepper_configuration_body

    @property
    def compartment_id(self):
        """
        **[Required]** Gets the compartment_id of this CreateOpensearchClusterPipelineDetails.
        The OCID of the compartment to create the pipeline in.


        :return: The compartment_id of this CreateOpensearchClusterPipelineDetails.
        :rtype: str
        """
        return self._compartment_id

    @compartment_id.setter
    def compartment_id(self, compartment_id):
        """
        Sets the compartment_id of this CreateOpensearchClusterPipelineDetails.
        The OCID of the compartment to create the pipeline in.


        :param compartment_id: The compartment_id of this CreateOpensearchClusterPipelineDetails.
        :type: str
        """
        self._compartment_id = compartment_id

    @property
    def vcn_id(self):
        """
        Gets the vcn_id of this CreateOpensearchClusterPipelineDetails.
        The OCID of the pipeline's VCN.


        :return: The vcn_id of this CreateOpensearchClusterPipelineDetails.
        :rtype: str
        """
        return self._vcn_id

    @vcn_id.setter
    def vcn_id(self, vcn_id):
        """
        Sets the vcn_id of this CreateOpensearchClusterPipelineDetails.
        The OCID of the pipeline's VCN.


        :param vcn_id: The vcn_id of this CreateOpensearchClusterPipelineDetails.
        :type: str
        """
        self._vcn_id = vcn_id

    @property
    def subnet_id(self):
        """
        Gets the subnet_id of this CreateOpensearchClusterPipelineDetails.
        The OCID of the pipeline's subnet.


        :return: The subnet_id of this CreateOpensearchClusterPipelineDetails.
        :rtype: str
        """
        return self._subnet_id

    @subnet_id.setter
    def subnet_id(self, subnet_id):
        """
        Sets the subnet_id of this CreateOpensearchClusterPipelineDetails.
        The OCID of the pipeline's subnet.


        :param subnet_id: The subnet_id of this CreateOpensearchClusterPipelineDetails.
        :type: str
        """
        self._subnet_id = subnet_id

    @property
    def vcn_compartment_id(self):
        """
        Gets the vcn_compartment_id of this CreateOpensearchClusterPipelineDetails.
        The OCID for the compartment where the pipeline's VCN is located.


        :return: The vcn_compartment_id of this CreateOpensearchClusterPipelineDetails.
        :rtype: str
        """
        return self._vcn_compartment_id

    @vcn_compartment_id.setter
    def vcn_compartment_id(self, vcn_compartment_id):
        """
        Sets the vcn_compartment_id of this CreateOpensearchClusterPipelineDetails.
        The OCID for the compartment where the pipeline's VCN is located.


        :param vcn_compartment_id: The vcn_compartment_id of this CreateOpensearchClusterPipelineDetails.
        :type: str
        """
        self._vcn_compartment_id = vcn_compartment_id

    @property
    def subnet_compartment_id(self):
        """
        Gets the subnet_compartment_id of this CreateOpensearchClusterPipelineDetails.
        The OCID for the compartment where the pipeline's subnet is located.


        :return: The subnet_compartment_id of this CreateOpensearchClusterPipelineDetails.
        :rtype: str
        """
        return self._subnet_compartment_id

    @subnet_compartment_id.setter
    def subnet_compartment_id(self, subnet_compartment_id):
        """
        Sets the subnet_compartment_id of this CreateOpensearchClusterPipelineDetails.
        The OCID for the compartment where the pipeline's subnet is located.


        :param subnet_compartment_id: The subnet_compartment_id of this CreateOpensearchClusterPipelineDetails.
        :type: str
        """
        self._subnet_compartment_id = subnet_compartment_id

    @property
    def nsg_id(self):
        """
        Gets the nsg_id of this CreateOpensearchClusterPipelineDetails.
        The OCID of the NSG where the pipeline private endpoint vnic will be attached.


        :return: The nsg_id of this CreateOpensearchClusterPipelineDetails.
        :rtype: str
        """
        return self._nsg_id

    @nsg_id.setter
    def nsg_id(self, nsg_id):
        """
        Sets the nsg_id of this CreateOpensearchClusterPipelineDetails.
        The OCID of the NSG where the pipeline private endpoint vnic will be attached.


        :param nsg_id: The nsg_id of this CreateOpensearchClusterPipelineDetails.
        :type: str
        """
        self._nsg_id = nsg_id

    @property
    def reverse_connection_endpoints(self):
        """
        Gets the reverse_connection_endpoints of this CreateOpensearchClusterPipelineDetails.
        The customer IP and the corresponding fully qualified domain name that the pipeline will connect to.


        :return: The reverse_connection_endpoints of this CreateOpensearchClusterPipelineDetails.
        :rtype: list[oci.opensearch.models.OpensearchPipelineReverseConnectionEndpoint]
        """
        return self._reverse_connection_endpoints

    @reverse_connection_endpoints.setter
    def reverse_connection_endpoints(self, reverse_connection_endpoints):
        """
        Sets the reverse_connection_endpoints of this CreateOpensearchClusterPipelineDetails.
        The customer IP and the corresponding fully qualified domain name that the pipeline will connect to.


        :param reverse_connection_endpoints: The reverse_connection_endpoints of this CreateOpensearchClusterPipelineDetails.
        :type: list[oci.opensearch.models.OpensearchPipelineReverseConnectionEndpoint]
        """
        self._reverse_connection_endpoints = reverse_connection_endpoints

    @property
    def freeform_tags(self):
        """
        Gets the freeform_tags of this CreateOpensearchClusterPipelineDetails.
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only.
        Example: `{\"bar-key\": \"value\"}`


        :return: The freeform_tags of this CreateOpensearchClusterPipelineDetails.
        :rtype: dict(str, str)
        """
        return self._freeform_tags

    @freeform_tags.setter
    def freeform_tags(self, freeform_tags):
        """
        Sets the freeform_tags of this CreateOpensearchClusterPipelineDetails.
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only.
        Example: `{\"bar-key\": \"value\"}`


        :param freeform_tags: The freeform_tags of this CreateOpensearchClusterPipelineDetails.
        :type: dict(str, str)
        """
        self._freeform_tags = freeform_tags

    @property
    def defined_tags(self):
        """
        Gets the defined_tags of this CreateOpensearchClusterPipelineDetails.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        Example: `{\"foo-namespace\": {\"bar-key\": \"value\"}}`


        :return: The defined_tags of this CreateOpensearchClusterPipelineDetails.
        :rtype: dict(str, dict(str, object))
        """
        return self._defined_tags

    @defined_tags.setter
    def defined_tags(self, defined_tags):
        """
        Sets the defined_tags of this CreateOpensearchClusterPipelineDetails.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        Example: `{\"foo-namespace\": {\"bar-key\": \"value\"}}`


        :param defined_tags: The defined_tags of this CreateOpensearchClusterPipelineDetails.
        :type: dict(str, dict(str, object))
        """
        self._defined_tags = defined_tags

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
