# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20180828


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class LoadBalancerConfig(object):
    """
    This config is used to choose the load balancer service and bandwidth for OpenSearch and OpenDashboard load balancers.
    """

    #: A constant which can be used with the load_balancer_service_type property of a LoadBalancerConfig.
    #: This constant has a value of "LOAD_BALANCER"
    LOAD_BALANCER_SERVICE_TYPE_LOAD_BALANCER = "LOAD_BALANCER"

    #: A constant which can be used with the load_balancer_service_type property of a LoadBalancerConfig.
    #: This constant has a value of "NETWORK_LOAD_BALANCER"
    LOAD_BALANCER_SERVICE_TYPE_NETWORK_LOAD_BALANCER = "NETWORK_LOAD_BALANCER"

    def __init__(self, **kwargs):
        """
        Initializes a new LoadBalancerConfig object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param load_balancer_service_type:
            The value to assign to the load_balancer_service_type property of this LoadBalancerConfig.
            Allowed values for this property are: "LOAD_BALANCER", "NETWORK_LOAD_BALANCER", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type load_balancer_service_type: str

        :param load_balancer_min_bandwidth_in_mbps:
            The value to assign to the load_balancer_min_bandwidth_in_mbps property of this LoadBalancerConfig.
        :type load_balancer_min_bandwidth_in_mbps: int

        :param load_balancer_max_bandwidth_in_mbps:
            The value to assign to the load_balancer_max_bandwidth_in_mbps property of this LoadBalancerConfig.
        :type load_balancer_max_bandwidth_in_mbps: int

        """
        self.swagger_types = {
            'load_balancer_service_type': 'str',
            'load_balancer_min_bandwidth_in_mbps': 'int',
            'load_balancer_max_bandwidth_in_mbps': 'int'
        }
        self.attribute_map = {
            'load_balancer_service_type': 'loadBalancerServiceType',
            'load_balancer_min_bandwidth_in_mbps': 'loadBalancerMinBandwidthInMbps',
            'load_balancer_max_bandwidth_in_mbps': 'loadBalancerMaxBandwidthInMbps'
        }
        self._load_balancer_service_type = None
        self._load_balancer_min_bandwidth_in_mbps = None
        self._load_balancer_max_bandwidth_in_mbps = None

    @property
    def load_balancer_service_type(self):
        """
        **[Required]** Gets the load_balancer_service_type of this LoadBalancerConfig.
        Load balancer service for OpenSearch and OpenDashboard load balancer. Default value is LOAD_BALANCER.

        Allowed values for this property are: "LOAD_BALANCER", "NETWORK_LOAD_BALANCER", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The load_balancer_service_type of this LoadBalancerConfig.
        :rtype: str
        """
        return self._load_balancer_service_type

    @load_balancer_service_type.setter
    def load_balancer_service_type(self, load_balancer_service_type):
        """
        Sets the load_balancer_service_type of this LoadBalancerConfig.
        Load balancer service for OpenSearch and OpenDashboard load balancer. Default value is LOAD_BALANCER.


        :param load_balancer_service_type: The load_balancer_service_type of this LoadBalancerConfig.
        :type: str
        """
        allowed_values = ["LOAD_BALANCER", "NETWORK_LOAD_BALANCER"]
        if not value_allowed_none_or_none_sentinel(load_balancer_service_type, allowed_values):
            load_balancer_service_type = 'UNKNOWN_ENUM_VALUE'
        self._load_balancer_service_type = load_balancer_service_type

    @property
    def load_balancer_min_bandwidth_in_mbps(self):
        """
        Gets the load_balancer_min_bandwidth_in_mbps of this LoadBalancerConfig.
        Minimum bandwidth (Mbps) of OpenSearch load balancer. Not applicable for network load balancer service.


        :return: The load_balancer_min_bandwidth_in_mbps of this LoadBalancerConfig.
        :rtype: int
        """
        return self._load_balancer_min_bandwidth_in_mbps

    @load_balancer_min_bandwidth_in_mbps.setter
    def load_balancer_min_bandwidth_in_mbps(self, load_balancer_min_bandwidth_in_mbps):
        """
        Sets the load_balancer_min_bandwidth_in_mbps of this LoadBalancerConfig.
        Minimum bandwidth (Mbps) of OpenSearch load balancer. Not applicable for network load balancer service.


        :param load_balancer_min_bandwidth_in_mbps: The load_balancer_min_bandwidth_in_mbps of this LoadBalancerConfig.
        :type: int
        """
        self._load_balancer_min_bandwidth_in_mbps = load_balancer_min_bandwidth_in_mbps

    @property
    def load_balancer_max_bandwidth_in_mbps(self):
        """
        Gets the load_balancer_max_bandwidth_in_mbps of this LoadBalancerConfig.
        Maximum bandwidth (Mbps) of OpenSearch load balancer. Not applicable for network load balancer service.


        :return: The load_balancer_max_bandwidth_in_mbps of this LoadBalancerConfig.
        :rtype: int
        """
        return self._load_balancer_max_bandwidth_in_mbps

    @load_balancer_max_bandwidth_in_mbps.setter
    def load_balancer_max_bandwidth_in_mbps(self, load_balancer_max_bandwidth_in_mbps):
        """
        Sets the load_balancer_max_bandwidth_in_mbps of this LoadBalancerConfig.
        Maximum bandwidth (Mbps) of OpenSearch load balancer. Not applicable for network load balancer service.


        :param load_balancer_max_bandwidth_in_mbps: The load_balancer_max_bandwidth_in_mbps of this LoadBalancerConfig.
        :type: int
        """
        self._load_balancer_max_bandwidth_in_mbps = load_balancer_max_bandwidth_in_mbps

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
