# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20180828


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class OpensearchPipelineReverseConnectionEndpoint(object):
    """
    The customer IP and the corresponding fully qualified domain name that the pipeline will connect to.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new OpensearchPipelineReverseConnectionEndpoint object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param customer_fqdn:
            The value to assign to the customer_fqdn property of this OpensearchPipelineReverseConnectionEndpoint.
        :type customer_fqdn: str

        :param customer_ip:
            The value to assign to the customer_ip property of this OpensearchPipelineReverseConnectionEndpoint.
        :type customer_ip: str

        """
        self.swagger_types = {
            'customer_fqdn': 'str',
            'customer_ip': 'str'
        }
        self.attribute_map = {
            'customer_fqdn': 'customerFqdn',
            'customer_ip': 'customerIp'
        }
        self._customer_fqdn = None
        self._customer_ip = None

    @property
    def customer_fqdn(self):
        """
        **[Required]** Gets the customer_fqdn of this OpensearchPipelineReverseConnectionEndpoint.
        The fully qualified domain name of the customerIp in the customer VCN


        :return: The customer_fqdn of this OpensearchPipelineReverseConnectionEndpoint.
        :rtype: str
        """
        return self._customer_fqdn

    @customer_fqdn.setter
    def customer_fqdn(self, customer_fqdn):
        """
        Sets the customer_fqdn of this OpensearchPipelineReverseConnectionEndpoint.
        The fully qualified domain name of the customerIp in the customer VCN


        :param customer_fqdn: The customer_fqdn of this OpensearchPipelineReverseConnectionEndpoint.
        :type: str
        """
        self._customer_fqdn = customer_fqdn

    @property
    def customer_ip(self):
        """
        **[Required]** Gets the customer_ip of this OpensearchPipelineReverseConnectionEndpoint.
        The IPv4 address in the customer VCN


        :return: The customer_ip of this OpensearchPipelineReverseConnectionEndpoint.
        :rtype: str
        """
        return self._customer_ip

    @customer_ip.setter
    def customer_ip(self, customer_ip):
        """
        Sets the customer_ip of this OpensearchPipelineReverseConnectionEndpoint.
        The IPv4 address in the customer VCN


        :param customer_ip: The customer_ip of this OpensearchPipelineReverseConnectionEndpoint.
        :type: str
        """
        self._customer_ip = customer_ip

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
