# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20220901


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class SysadminEventData(object):
    """
    Data related to the sysadmin event.
    """

    #: A constant which can be used with the resolution_status property of a SysadminEventData.
    #: This constant has a value of "SUCCEEDED"
    RESOLUTION_STATUS_SUCCEEDED = "SUCCEEDED"

    #: A constant which can be used with the resolution_status property of a SysadminEventData.
    #: This constant has a value of "FAILED"
    RESOLUTION_STATUS_FAILED = "FAILED"

    def __init__(self, **kwargs):
        """
        Initializes a new SysadminEventData object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param error_cause:
            The value to assign to the error_cause property of this SysadminEventData.
        :type error_cause: str

        :param error_log:
            The value to assign to the error_log property of this SysadminEventData.
        :type error_log: str

        :param attempted_resolutions:
            The value to assign to the attempted_resolutions property of this SysadminEventData.
        :type attempted_resolutions: list[str]

        :param resolution_status:
            The value to assign to the resolution_status property of this SysadminEventData.
            Allowed values for this property are: "SUCCEEDED", "FAILED", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type resolution_status: str

        :param resolution_log:
            The value to assign to the resolution_log property of this SysadminEventData.
        :type resolution_log: str

        :param additional_details:
            The value to assign to the additional_details property of this SysadminEventData.
        :type additional_details: oci.os_management_hub.models.WorkRequestEventDataAdditionalDetails

        """
        self.swagger_types = {
            'error_cause': 'str',
            'error_log': 'str',
            'attempted_resolutions': 'list[str]',
            'resolution_status': 'str',
            'resolution_log': 'str',
            'additional_details': 'WorkRequestEventDataAdditionalDetails'
        }
        self.attribute_map = {
            'error_cause': 'errorCause',
            'error_log': 'errorLog',
            'attempted_resolutions': 'attemptedResolutions',
            'resolution_status': 'resolutionStatus',
            'resolution_log': 'resolutionLog',
            'additional_details': 'additionalDetails'
        }
        self._error_cause = None
        self._error_log = None
        self._attempted_resolutions = None
        self._resolution_status = None
        self._resolution_log = None
        self._additional_details = None

    @property
    def error_cause(self):
        """
        **[Required]** Gets the error_cause of this SysadminEventData.
        The commands executed by the agent that caused the error.


        :return: The error_cause of this SysadminEventData.
        :rtype: str
        """
        return self._error_cause

    @error_cause.setter
    def error_cause(self, error_cause):
        """
        Sets the error_cause of this SysadminEventData.
        The commands executed by the agent that caused the error.


        :param error_cause: The error_cause of this SysadminEventData.
        :type: str
        """
        self._error_cause = error_cause

    @property
    def error_log(self):
        """
        **[Required]** Gets the error_log of this SysadminEventData.
        The output log of the error.


        :return: The error_log of this SysadminEventData.
        :rtype: str
        """
        return self._error_log

    @error_log.setter
    def error_log(self, error_log):
        """
        Sets the error_log of this SysadminEventData.
        The output log of the error.


        :param error_log: The error_log of this SysadminEventData.
        :type: str
        """
        self._error_log = error_log

    @property
    def attempted_resolutions(self):
        """
        **[Required]** Gets the attempted_resolutions of this SysadminEventData.
        The actions used to attempt fixing the error.


        :return: The attempted_resolutions of this SysadminEventData.
        :rtype: list[str]
        """
        return self._attempted_resolutions

    @attempted_resolutions.setter
    def attempted_resolutions(self, attempted_resolutions):
        """
        Sets the attempted_resolutions of this SysadminEventData.
        The actions used to attempt fixing the error.


        :param attempted_resolutions: The attempted_resolutions of this SysadminEventData.
        :type: list[str]
        """
        self._attempted_resolutions = attempted_resolutions

    @property
    def resolution_status(self):
        """
        **[Required]** Gets the resolution_status of this SysadminEventData.
        Indicates if the event succeeded.

        Allowed values for this property are: "SUCCEEDED", "FAILED", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The resolution_status of this SysadminEventData.
        :rtype: str
        """
        return self._resolution_status

    @resolution_status.setter
    def resolution_status(self, resolution_status):
        """
        Sets the resolution_status of this SysadminEventData.
        Indicates if the event succeeded.


        :param resolution_status: The resolution_status of this SysadminEventData.
        :type: str
        """
        allowed_values = ["SUCCEEDED", "FAILED"]
        if not value_allowed_none_or_none_sentinel(resolution_status, allowed_values):
            resolution_status = 'UNKNOWN_ENUM_VALUE'
        self._resolution_status = resolution_status

    @property
    def resolution_log(self):
        """
        **[Required]** Gets the resolution_log of this SysadminEventData.
        The log output after the resolutions.


        :return: The resolution_log of this SysadminEventData.
        :rtype: str
        """
        return self._resolution_log

    @resolution_log.setter
    def resolution_log(self, resolution_log):
        """
        Sets the resolution_log of this SysadminEventData.
        The log output after the resolutions.


        :param resolution_log: The resolution_log of this SysadminEventData.
        :type: str
        """
        self._resolution_log = resolution_log

    @property
    def additional_details(self):
        """
        Gets the additional_details of this SysadminEventData.

        :return: The additional_details of this SysadminEventData.
        :rtype: oci.os_management_hub.models.WorkRequestEventDataAdditionalDetails
        """
        return self._additional_details

    @additional_details.setter
    def additional_details(self, additional_details):
        """
        Sets the additional_details of this SysadminEventData.

        :param additional_details: The additional_details of this SysadminEventData.
        :type: oci.os_management_hub.models.WorkRequestEventDataAdditionalDetails
        """
        self._additional_details = additional_details

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
