# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20220901

from .update_software_source_details import UpdateSoftwareSourceDetails
from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class UpdateCustomSoftwareSourceDetails(UpdateSoftwareSourceDetails):
    """
    Provides the information used to update a custom software source.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new UpdateCustomSoftwareSourceDetails object with values from keyword arguments. The default value of the :py:attr:`~oci.os_management_hub.models.UpdateCustomSoftwareSourceDetails.software_source_type` attribute
        of this class is ``CUSTOM`` and it should not be changed.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param compartment_id:
            The value to assign to the compartment_id property of this UpdateCustomSoftwareSourceDetails.
        :type compartment_id: str

        :param display_name:
            The value to assign to the display_name property of this UpdateCustomSoftwareSourceDetails.
        :type display_name: str

        :param description:
            The value to assign to the description property of this UpdateCustomSoftwareSourceDetails.
        :type description: str

        :param software_source_type:
            The value to assign to the software_source_type property of this UpdateCustomSoftwareSourceDetails.
            Allowed values for this property are: "VENDOR", "CUSTOM", "VERSIONED", "PRIVATE", "THIRD_PARTY"
        :type software_source_type: str

        :param freeform_tags:
            The value to assign to the freeform_tags property of this UpdateCustomSoftwareSourceDetails.
        :type freeform_tags: dict(str, str)

        :param defined_tags:
            The value to assign to the defined_tags property of this UpdateCustomSoftwareSourceDetails.
        :type defined_tags: dict(str, dict(str, object))

        :param vendor_software_sources:
            The value to assign to the vendor_software_sources property of this UpdateCustomSoftwareSourceDetails.
        :type vendor_software_sources: list[oci.os_management_hub.models.Id]

        :param custom_software_source_filter:
            The value to assign to the custom_software_source_filter property of this UpdateCustomSoftwareSourceDetails.
        :type custom_software_source_filter: oci.os_management_hub.models.CustomSoftwareSourceFilter

        :param is_automatically_updated:
            The value to assign to the is_automatically_updated property of this UpdateCustomSoftwareSourceDetails.
        :type is_automatically_updated: bool

        :param is_auto_resolve_dependencies:
            The value to assign to the is_auto_resolve_dependencies property of this UpdateCustomSoftwareSourceDetails.
        :type is_auto_resolve_dependencies: bool

        :param is_latest_content_only:
            The value to assign to the is_latest_content_only property of this UpdateCustomSoftwareSourceDetails.
        :type is_latest_content_only: bool

        """
        self.swagger_types = {
            'compartment_id': 'str',
            'display_name': 'str',
            'description': 'str',
            'software_source_type': 'str',
            'freeform_tags': 'dict(str, str)',
            'defined_tags': 'dict(str, dict(str, object))',
            'vendor_software_sources': 'list[Id]',
            'custom_software_source_filter': 'CustomSoftwareSourceFilter',
            'is_automatically_updated': 'bool',
            'is_auto_resolve_dependencies': 'bool',
            'is_latest_content_only': 'bool'
        }
        self.attribute_map = {
            'compartment_id': 'compartmentId',
            'display_name': 'displayName',
            'description': 'description',
            'software_source_type': 'softwareSourceType',
            'freeform_tags': 'freeformTags',
            'defined_tags': 'definedTags',
            'vendor_software_sources': 'vendorSoftwareSources',
            'custom_software_source_filter': 'customSoftwareSourceFilter',
            'is_automatically_updated': 'isAutomaticallyUpdated',
            'is_auto_resolve_dependencies': 'isAutoResolveDependencies',
            'is_latest_content_only': 'isLatestContentOnly'
        }
        self._compartment_id = None
        self._display_name = None
        self._description = None
        self._software_source_type = None
        self._freeform_tags = None
        self._defined_tags = None
        self._vendor_software_sources = None
        self._custom_software_source_filter = None
        self._is_automatically_updated = None
        self._is_auto_resolve_dependencies = None
        self._is_latest_content_only = None
        self._software_source_type = 'CUSTOM'

    @property
    def vendor_software_sources(self):
        """
        Gets the vendor_software_sources of this UpdateCustomSoftwareSourceDetails.
        List of vendor software sources that are used for the basis of the custom software source.


        :return: The vendor_software_sources of this UpdateCustomSoftwareSourceDetails.
        :rtype: list[oci.os_management_hub.models.Id]
        """
        return self._vendor_software_sources

    @vendor_software_sources.setter
    def vendor_software_sources(self, vendor_software_sources):
        """
        Sets the vendor_software_sources of this UpdateCustomSoftwareSourceDetails.
        List of vendor software sources that are used for the basis of the custom software source.


        :param vendor_software_sources: The vendor_software_sources of this UpdateCustomSoftwareSourceDetails.
        :type: list[oci.os_management_hub.models.Id]
        """
        self._vendor_software_sources = vendor_software_sources

    @property
    def custom_software_source_filter(self):
        """
        Gets the custom_software_source_filter of this UpdateCustomSoftwareSourceDetails.

        :return: The custom_software_source_filter of this UpdateCustomSoftwareSourceDetails.
        :rtype: oci.os_management_hub.models.CustomSoftwareSourceFilter
        """
        return self._custom_software_source_filter

    @custom_software_source_filter.setter
    def custom_software_source_filter(self, custom_software_source_filter):
        """
        Sets the custom_software_source_filter of this UpdateCustomSoftwareSourceDetails.

        :param custom_software_source_filter: The custom_software_source_filter of this UpdateCustomSoftwareSourceDetails.
        :type: oci.os_management_hub.models.CustomSoftwareSourceFilter
        """
        self._custom_software_source_filter = custom_software_source_filter

    @property
    def is_automatically_updated(self):
        """
        Gets the is_automatically_updated of this UpdateCustomSoftwareSourceDetails.
        Indicates whether the service should automatically update the custom software source to use the latest package versions available. The service reviews packages levels once a day.


        :return: The is_automatically_updated of this UpdateCustomSoftwareSourceDetails.
        :rtype: bool
        """
        return self._is_automatically_updated

    @is_automatically_updated.setter
    def is_automatically_updated(self, is_automatically_updated):
        """
        Sets the is_automatically_updated of this UpdateCustomSoftwareSourceDetails.
        Indicates whether the service should automatically update the custom software source to use the latest package versions available. The service reviews packages levels once a day.


        :param is_automatically_updated: The is_automatically_updated of this UpdateCustomSoftwareSourceDetails.
        :type: bool
        """
        self._is_automatically_updated = is_automatically_updated

    @property
    def is_auto_resolve_dependencies(self):
        """
        Gets the is_auto_resolve_dependencies of this UpdateCustomSoftwareSourceDetails.
        Indicates whether the service should automatically resolve package dependencies when including specific packages in the software source.


        :return: The is_auto_resolve_dependencies of this UpdateCustomSoftwareSourceDetails.
        :rtype: bool
        """
        return self._is_auto_resolve_dependencies

    @is_auto_resolve_dependencies.setter
    def is_auto_resolve_dependencies(self, is_auto_resolve_dependencies):
        """
        Sets the is_auto_resolve_dependencies of this UpdateCustomSoftwareSourceDetails.
        Indicates whether the service should automatically resolve package dependencies when including specific packages in the software source.


        :param is_auto_resolve_dependencies: The is_auto_resolve_dependencies of this UpdateCustomSoftwareSourceDetails.
        :type: bool
        """
        self._is_auto_resolve_dependencies = is_auto_resolve_dependencies

    @property
    def is_latest_content_only(self):
        """
        Gets the is_latest_content_only of this UpdateCustomSoftwareSourceDetails.
        Indicates whether the software source will include only the latest versions of content from vendor software sources, while accounting for other constraints set in the custom or versioned custom software source (such as a package list or filters).
        * For a module filter that does not specify a stream, this will include all available streams, and within each stream only the latest version of packages.
        * For a module filter that does specify a stream, this will include only the latest version of packages for the specified stream.
        * For a package filter that does not specify a version, this will include only the latest available version of the package.
        * For a package filter that does specify a version, this will include only the specified version of the package (the isLatestContentOnly attribute is ignored).
        * For a package list, this will include only the specified version of packages and modules in the list (the isLatestContentOnly attribute is ignored).


        :return: The is_latest_content_only of this UpdateCustomSoftwareSourceDetails.
        :rtype: bool
        """
        return self._is_latest_content_only

    @is_latest_content_only.setter
    def is_latest_content_only(self, is_latest_content_only):
        """
        Sets the is_latest_content_only of this UpdateCustomSoftwareSourceDetails.
        Indicates whether the software source will include only the latest versions of content from vendor software sources, while accounting for other constraints set in the custom or versioned custom software source (such as a package list or filters).
        * For a module filter that does not specify a stream, this will include all available streams, and within each stream only the latest version of packages.
        * For a module filter that does specify a stream, this will include only the latest version of packages for the specified stream.
        * For a package filter that does not specify a version, this will include only the latest available version of the package.
        * For a package filter that does specify a version, this will include only the specified version of the package (the isLatestContentOnly attribute is ignored).
        * For a package list, this will include only the specified version of packages and modules in the list (the isLatestContentOnly attribute is ignored).


        :param is_latest_content_only: The is_latest_content_only of this UpdateCustomSoftwareSourceDetails.
        :type: bool
        """
        self._is_latest_content_only = is_latest_content_only

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
