# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20191001


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class AddressRule(object):
    """
    Addres rule information
    """

    def __init__(self, **kwargs):
        """
        Initializes a new AddressRule object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param country_code:
            The value to assign to the country_code property of this AddressRule.
        :type country_code: str

        :param address:
            The value to assign to the address property of this AddressRule.
        :type address: oci.osp_gateway.models.AddressTypeRule

        :param contact:
            The value to assign to the contact property of this AddressRule.
        :type contact: oci.osp_gateway.models.ContactTypeRule

        :param tax:
            The value to assign to the tax property of this AddressRule.
        :type tax: oci.osp_gateway.models.TaxTypeRule

        """
        self.swagger_types = {
            'country_code': 'str',
            'address': 'AddressTypeRule',
            'contact': 'ContactTypeRule',
            'tax': 'TaxTypeRule'
        }
        self.attribute_map = {
            'country_code': 'countryCode',
            'address': 'address',
            'contact': 'contact',
            'tax': 'tax'
        }
        self._country_code = None
        self._address = None
        self._contact = None
        self._tax = None

    @property
    def country_code(self):
        """
        **[Required]** Gets the country_code of this AddressRule.
        Country code for the address rule in ISO-3166-1 2-letter format


        :return: The country_code of this AddressRule.
        :rtype: str
        """
        return self._country_code

    @country_code.setter
    def country_code(self, country_code):
        """
        Sets the country_code of this AddressRule.
        Country code for the address rule in ISO-3166-1 2-letter format


        :param country_code: The country_code of this AddressRule.
        :type: str
        """
        self._country_code = country_code

    @property
    def address(self):
        """
        **[Required]** Gets the address of this AddressRule.

        :return: The address of this AddressRule.
        :rtype: oci.osp_gateway.models.AddressTypeRule
        """
        return self._address

    @address.setter
    def address(self, address):
        """
        Sets the address of this AddressRule.

        :param address: The address of this AddressRule.
        :type: oci.osp_gateway.models.AddressTypeRule
        """
        self._address = address

    @property
    def contact(self):
        """
        Gets the contact of this AddressRule.

        :return: The contact of this AddressRule.
        :rtype: oci.osp_gateway.models.ContactTypeRule
        """
        return self._contact

    @contact.setter
    def contact(self, contact):
        """
        Sets the contact of this AddressRule.

        :param contact: The contact of this AddressRule.
        :type: oci.osp_gateway.models.ContactTypeRule
        """
        self._contact = contact

    @property
    def tax(self):
        """
        Gets the tax of this AddressRule.

        :return: The tax of this AddressRule.
        :rtype: oci.osp_gateway.models.TaxTypeRule
        """
        return self._tax

    @tax.setter
    def tax(self, tax):
        """
        Sets the tax of this AddressRule.

        :param tax: The tax of this AddressRule.
        :type: oci.osp_gateway.models.TaxTypeRule
        """
        self._tax = tax

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
