# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20220915


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class UpdateNetworkDetails(object):
    """
    Network details for the database system.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new UpdateNetworkDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param nsg_ids:
            The value to assign to the nsg_ids property of this UpdateNetworkDetails.
        :type nsg_ids: list[str]

        :param is_reader_endpoint_enabled:
            The value to assign to the is_reader_endpoint_enabled property of this UpdateNetworkDetails.
        :type is_reader_endpoint_enabled: bool

        """
        self.swagger_types = {
            'nsg_ids': 'list[str]',
            'is_reader_endpoint_enabled': 'bool'
        }
        self.attribute_map = {
            'nsg_ids': 'nsgIds',
            'is_reader_endpoint_enabled': 'isReaderEndpointEnabled'
        }
        self._nsg_ids = None
        self._is_reader_endpoint_enabled = None

    @property
    def nsg_ids(self):
        """
        Gets the nsg_ids of this UpdateNetworkDetails.
        List of Network Security Group `OCIDs`__ associated with the database system.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :return: The nsg_ids of this UpdateNetworkDetails.
        :rtype: list[str]
        """
        return self._nsg_ids

    @nsg_ids.setter
    def nsg_ids(self, nsg_ids):
        """
        Sets the nsg_ids of this UpdateNetworkDetails.
        List of Network Security Group `OCIDs`__ associated with the database system.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :param nsg_ids: The nsg_ids of this UpdateNetworkDetails.
        :type: list[str]
        """
        self._nsg_ids = nsg_ids

    @property
    def is_reader_endpoint_enabled(self):
        """
        Gets the is_reader_endpoint_enabled of this UpdateNetworkDetails.
        Specifies if the reader endpoint is enabled on the dbSystem.


        :return: The is_reader_endpoint_enabled of this UpdateNetworkDetails.
        :rtype: bool
        """
        return self._is_reader_endpoint_enabled

    @is_reader_endpoint_enabled.setter
    def is_reader_endpoint_enabled(self, is_reader_endpoint_enabled):
        """
        Sets the is_reader_endpoint_enabled of this UpdateNetworkDetails.
        Specifies if the reader endpoint is enabled on the dbSystem.


        :param is_reader_endpoint_enabled: The is_reader_endpoint_enabled of this UpdateNetworkDetails.
        :type: bool
        """
        self._is_reader_endpoint_enabled = is_reader_endpoint_enabled

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
