# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20240430


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class Parameter(object):
    """
    This is a generic input parameter to use when acting on the resource.
    """

    #: A constant which can be used with the parameter_type property of a Parameter.
    #: This constant has a value of "HEADER"
    PARAMETER_TYPE_HEADER = "HEADER"

    #: A constant which can be used with the parameter_type property of a Parameter.
    #: This constant has a value of "BODY"
    PARAMETER_TYPE_BODY = "BODY"

    #: A constant which can be used with the parameter_type property of a Parameter.
    #: This constant has a value of "PATH"
    PARAMETER_TYPE_PATH = "PATH"

    #: A constant which can be used with the parameter_type property of a Parameter.
    #: This constant has a value of "QUERY"
    PARAMETER_TYPE_QUERY = "QUERY"

    def __init__(self, **kwargs):
        """
        Initializes a new Parameter object with values from keyword arguments. This class has the following subclasses and if you are using this class as input
        to a service operations then you should favor using a subclass over the base class:

        * :class:`~oci.resource_scheduler.models.QueryParameter`
        * :class:`~oci.resource_scheduler.models.HeaderParameter`
        * :class:`~oci.resource_scheduler.models.BodyParameter`
        * :class:`~oci.resource_scheduler.models.PathParameter`

        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param parameter_type:
            The value to assign to the parameter_type property of this Parameter.
            Allowed values for this property are: "HEADER", "BODY", "PATH", "QUERY", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type parameter_type: str

        """
        self.swagger_types = {
            'parameter_type': 'str'
        }
        self.attribute_map = {
            'parameter_type': 'parameterType'
        }
        self._parameter_type = None

    @staticmethod
    def get_subtype(object_dictionary):
        """
        Given the hash representation of a subtype of this class,
        use the info in the hash to return the class of the subtype.
        """
        type = object_dictionary['parameterType']

        if type == 'QUERY':
            return 'QueryParameter'

        if type == 'HEADER':
            return 'HeaderParameter'

        if type == 'BODY':
            return 'BodyParameter'

        if type == 'PATH':
            return 'PathParameter'
        else:
            return 'Parameter'

    @property
    def parameter_type(self):
        """
        **[Required]** Gets the parameter_type of this Parameter.
        This is the parameter type on which the input parameter is defined

        Allowed values for this property are: "HEADER", "BODY", "PATH", "QUERY", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The parameter_type of this Parameter.
        :rtype: str
        """
        return self._parameter_type

    @parameter_type.setter
    def parameter_type(self, parameter_type):
        """
        Sets the parameter_type of this Parameter.
        This is the parameter type on which the input parameter is defined


        :param parameter_type: The parameter_type of this Parameter.
        :type: str
        """
        allowed_values = ["HEADER", "BODY", "PATH", "QUERY"]
        if not value_allowed_none_or_none_sentinel(parameter_type, allowed_values):
            parameter_type = 'UNKNOWN_ENUM_VALUE'
        self._parameter_type = parameter_type

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
