# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20240815


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class CreateSecurityAttributeDetails(object):
    """
    Details of the security attribute to be created for a specific security attribute namespace.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new CreateSecurityAttributeDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param name:
            The value to assign to the name property of this CreateSecurityAttributeDetails.
        :type name: str

        :param description:
            The value to assign to the description property of this CreateSecurityAttributeDetails.
        :type description: str

        :param validator:
            The value to assign to the validator property of this CreateSecurityAttributeDetails.
        :type validator: oci.security_attribute.models.BaseSecurityAttributeValidator

        """
        self.swagger_types = {
            'name': 'str',
            'description': 'str',
            'validator': 'BaseSecurityAttributeValidator'
        }
        self.attribute_map = {
            'name': 'name',
            'description': 'description',
            'validator': 'validator'
        }
        self._name = None
        self._description = None
        self._validator = None

    @property
    def name(self):
        """
        **[Required]** Gets the name of this CreateSecurityAttributeDetails.
        The name you assign to the security attribute during creation. This is the security attribute key.
        The name must be unique within the namespace and cannot be changed.


        :return: The name of this CreateSecurityAttributeDetails.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this CreateSecurityAttributeDetails.
        The name you assign to the security attribute during creation. This is the security attribute key.
        The name must be unique within the namespace and cannot be changed.


        :param name: The name of this CreateSecurityAttributeDetails.
        :type: str
        """
        self._name = name

    @property
    def description(self):
        """
        **[Required]** Gets the description of this CreateSecurityAttributeDetails.
        The description you assign to the security attribute during creation.


        :return: The description of this CreateSecurityAttributeDetails.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """
        Sets the description of this CreateSecurityAttributeDetails.
        The description you assign to the security attribute during creation.


        :param description: The description of this CreateSecurityAttributeDetails.
        :type: str
        """
        self._description = description

    @property
    def validator(self):
        """
        Gets the validator of this CreateSecurityAttributeDetails.

        :return: The validator of this CreateSecurityAttributeDetails.
        :rtype: oci.security_attribute.models.BaseSecurityAttributeValidator
        """
        return self._validator

    @validator.setter
    def validator(self, validator):
        """
        Sets the validator of this CreateSecurityAttributeDetails.

        :param validator: The validator of this CreateSecurityAttributeDetails.
        :type: oci.security_attribute.models.BaseSecurityAttributeValidator
        """
        self._validator = validator

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
