# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20210330


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class CreateBaselineableMetricDetails(object):
    """
    Summary for the baseline-able metric
    """

    def __init__(self, **kwargs):
        """
        Initializes a new CreateBaselineableMetricDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param compartment_id:
            The value to assign to the compartment_id property of this CreateBaselineableMetricDetails.
        :type compartment_id: str

        :param name:
            The value to assign to the name property of this CreateBaselineableMetricDetails.
        :type name: str

        :param column:
            The value to assign to the column property of this CreateBaselineableMetricDetails.
        :type column: str

        :param namespace:
            The value to assign to the namespace property of this CreateBaselineableMetricDetails.
        :type namespace: str

        :param resource_group:
            The value to assign to the resource_group property of this CreateBaselineableMetricDetails.
        :type resource_group: str

        :param resource_type:
            The value to assign to the resource_type property of this CreateBaselineableMetricDetails.
        :type resource_type: str

        """
        self.swagger_types = {
            'compartment_id': 'str',
            'name': 'str',
            'column': 'str',
            'namespace': 'str',
            'resource_group': 'str',
            'resource_type': 'str'
        }
        self.attribute_map = {
            'compartment_id': 'compartmentId',
            'name': 'name',
            'column': 'column',
            'namespace': 'namespace',
            'resource_group': 'resourceGroup',
            'resource_type': 'resourceType'
        }
        self._compartment_id = None
        self._name = None
        self._column = None
        self._namespace = None
        self._resource_group = None
        self._resource_type = None

    @property
    def compartment_id(self):
        """
        **[Required]** Gets the compartment_id of this CreateBaselineableMetricDetails.
        OCID of the compartment


        :return: The compartment_id of this CreateBaselineableMetricDetails.
        :rtype: str
        """
        return self._compartment_id

    @compartment_id.setter
    def compartment_id(self, compartment_id):
        """
        Sets the compartment_id of this CreateBaselineableMetricDetails.
        OCID of the compartment


        :param compartment_id: The compartment_id of this CreateBaselineableMetricDetails.
        :type: str
        """
        self._compartment_id = compartment_id

    @property
    def name(self):
        """
        Gets the name of this CreateBaselineableMetricDetails.
        name of the metric


        :return: The name of this CreateBaselineableMetricDetails.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this CreateBaselineableMetricDetails.
        name of the metric


        :param name: The name of this CreateBaselineableMetricDetails.
        :type: str
        """
        self._name = name

    @property
    def column(self):
        """
        **[Required]** Gets the column of this CreateBaselineableMetricDetails.
        metric column name


        :return: The column of this CreateBaselineableMetricDetails.
        :rtype: str
        """
        return self._column

    @column.setter
    def column(self, column):
        """
        Sets the column of this CreateBaselineableMetricDetails.
        metric column name


        :param column: The column of this CreateBaselineableMetricDetails.
        :type: str
        """
        self._column = column

    @property
    def namespace(self):
        """
        **[Required]** Gets the namespace of this CreateBaselineableMetricDetails.
        namespace of the metric


        :return: The namespace of this CreateBaselineableMetricDetails.
        :rtype: str
        """
        return self._namespace

    @namespace.setter
    def namespace(self, namespace):
        """
        Sets the namespace of this CreateBaselineableMetricDetails.
        namespace of the metric


        :param namespace: The namespace of this CreateBaselineableMetricDetails.
        :type: str
        """
        self._namespace = namespace

    @property
    def resource_group(self):
        """
        Gets the resource_group of this CreateBaselineableMetricDetails.
        Resource group of the metric


        :return: The resource_group of this CreateBaselineableMetricDetails.
        :rtype: str
        """
        return self._resource_group

    @resource_group.setter
    def resource_group(self, resource_group):
        """
        Sets the resource_group of this CreateBaselineableMetricDetails.
        Resource group of the metric


        :param resource_group: The resource_group of this CreateBaselineableMetricDetails.
        :type: str
        """
        self._resource_group = resource_group

    @property
    def resource_type(self):
        """
        Gets the resource_type of this CreateBaselineableMetricDetails.
        Resource type of the metric


        :return: The resource_type of this CreateBaselineableMetricDetails.
        :rtype: str
        """
        return self._resource_type

    @resource_type.setter
    def resource_type(self, resource_type):
        """
        Sets the resource_type of this CreateBaselineableMetricDetails.
        Resource type of the metric


        :param resource_type: The resource_type of this CreateBaselineableMetricDetails.
        :type: str
        """
        self._resource_type = resource_type

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
