# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20210330


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class CreateMetricExtensionDetails(object):
    """
    The information about new metric extension resource. The combination of metric extension name and resource type should be unique in a compartment.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new CreateMetricExtensionDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param name:
            The value to assign to the name property of this CreateMetricExtensionDetails.
        :type name: str

        :param display_name:
            The value to assign to the display_name property of this CreateMetricExtensionDetails.
        :type display_name: str

        :param resource_type:
            The value to assign to the resource_type property of this CreateMetricExtensionDetails.
        :type resource_type: str

        :param compartment_id:
            The value to assign to the compartment_id property of this CreateMetricExtensionDetails.
        :type compartment_id: str

        :param description:
            The value to assign to the description property of this CreateMetricExtensionDetails.
        :type description: str

        :param collection_recurrences:
            The value to assign to the collection_recurrences property of this CreateMetricExtensionDetails.
        :type collection_recurrences: str

        :param metric_list:
            The value to assign to the metric_list property of this CreateMetricExtensionDetails.
        :type metric_list: list[oci.stack_monitoring.models.Metric]

        :param query_properties:
            The value to assign to the query_properties property of this CreateMetricExtensionDetails.
        :type query_properties: oci.stack_monitoring.models.MetricExtensionQueryProperties

        """
        self.swagger_types = {
            'name': 'str',
            'display_name': 'str',
            'resource_type': 'str',
            'compartment_id': 'str',
            'description': 'str',
            'collection_recurrences': 'str',
            'metric_list': 'list[Metric]',
            'query_properties': 'MetricExtensionQueryProperties'
        }
        self.attribute_map = {
            'name': 'name',
            'display_name': 'displayName',
            'resource_type': 'resourceType',
            'compartment_id': 'compartmentId',
            'description': 'description',
            'collection_recurrences': 'collectionRecurrences',
            'metric_list': 'metricList',
            'query_properties': 'queryProperties'
        }
        self._name = None
        self._display_name = None
        self._resource_type = None
        self._compartment_id = None
        self._description = None
        self._collection_recurrences = None
        self._metric_list = None
        self._query_properties = None

    @property
    def name(self):
        """
        **[Required]** Gets the name of this CreateMetricExtensionDetails.
        Metric Extension Resource name.


        :return: The name of this CreateMetricExtensionDetails.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this CreateMetricExtensionDetails.
        Metric Extension Resource name.


        :param name: The name of this CreateMetricExtensionDetails.
        :type: str
        """
        self._name = name

    @property
    def display_name(self):
        """
        **[Required]** Gets the display_name of this CreateMetricExtensionDetails.
        Metric Extension display name.


        :return: The display_name of this CreateMetricExtensionDetails.
        :rtype: str
        """
        return self._display_name

    @display_name.setter
    def display_name(self, display_name):
        """
        Sets the display_name of this CreateMetricExtensionDetails.
        Metric Extension display name.


        :param display_name: The display_name of this CreateMetricExtensionDetails.
        :type: str
        """
        self._display_name = display_name

    @property
    def resource_type(self):
        """
        **[Required]** Gets the resource_type of this CreateMetricExtensionDetails.
        Resource type to which Metric Extension applies


        :return: The resource_type of this CreateMetricExtensionDetails.
        :rtype: str
        """
        return self._resource_type

    @resource_type.setter
    def resource_type(self, resource_type):
        """
        Sets the resource_type of this CreateMetricExtensionDetails.
        Resource type to which Metric Extension applies


        :param resource_type: The resource_type of this CreateMetricExtensionDetails.
        :type: str
        """
        self._resource_type = resource_type

    @property
    def compartment_id(self):
        """
        **[Required]** Gets the compartment_id of this CreateMetricExtensionDetails.
        Compartment Identifier `OCID`__

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :return: The compartment_id of this CreateMetricExtensionDetails.
        :rtype: str
        """
        return self._compartment_id

    @compartment_id.setter
    def compartment_id(self, compartment_id):
        """
        Sets the compartment_id of this CreateMetricExtensionDetails.
        Compartment Identifier `OCID`__

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :param compartment_id: The compartment_id of this CreateMetricExtensionDetails.
        :type: str
        """
        self._compartment_id = compartment_id

    @property
    def description(self):
        """
        Gets the description of this CreateMetricExtensionDetails.
        Description of the metric extension.


        :return: The description of this CreateMetricExtensionDetails.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """
        Sets the description of this CreateMetricExtensionDetails.
        Description of the metric extension.


        :param description: The description of this CreateMetricExtensionDetails.
        :type: str
        """
        self._description = description

    @property
    def collection_recurrences(self):
        """
        **[Required]** Gets the collection_recurrences of this CreateMetricExtensionDetails.
        Schedule of metric extension should use RFC 5545 format i.e. recur-rule-part = \"FREQ\";INTERVAL where FREQ rule part identifies the type of recurrence rule. Valid values are \"MINUTELY\",\"HOURLY\",\"DAILY\" to specify repeating events based on an interval of a minute, an hour and a day or more. Example- FREQ=DAILY;INTERVAL=1


        :return: The collection_recurrences of this CreateMetricExtensionDetails.
        :rtype: str
        """
        return self._collection_recurrences

    @collection_recurrences.setter
    def collection_recurrences(self, collection_recurrences):
        """
        Sets the collection_recurrences of this CreateMetricExtensionDetails.
        Schedule of metric extension should use RFC 5545 format i.e. recur-rule-part = \"FREQ\";INTERVAL where FREQ rule part identifies the type of recurrence rule. Valid values are \"MINUTELY\",\"HOURLY\",\"DAILY\" to specify repeating events based on an interval of a minute, an hour and a day or more. Example- FREQ=DAILY;INTERVAL=1


        :param collection_recurrences: The collection_recurrences of this CreateMetricExtensionDetails.
        :type: str
        """
        self._collection_recurrences = collection_recurrences

    @property
    def metric_list(self):
        """
        **[Required]** Gets the metric_list of this CreateMetricExtensionDetails.
        List of metrics which are part of this metric extension


        :return: The metric_list of this CreateMetricExtensionDetails.
        :rtype: list[oci.stack_monitoring.models.Metric]
        """
        return self._metric_list

    @metric_list.setter
    def metric_list(self, metric_list):
        """
        Sets the metric_list of this CreateMetricExtensionDetails.
        List of metrics which are part of this metric extension


        :param metric_list: The metric_list of this CreateMetricExtensionDetails.
        :type: list[oci.stack_monitoring.models.Metric]
        """
        self._metric_list = metric_list

    @property
    def query_properties(self):
        """
        **[Required]** Gets the query_properties of this CreateMetricExtensionDetails.

        :return: The query_properties of this CreateMetricExtensionDetails.
        :rtype: oci.stack_monitoring.models.MetricExtensionQueryProperties
        """
        return self._query_properties

    @query_properties.setter
    def query_properties(self, query_properties):
        """
        Sets the query_properties of this CreateMetricExtensionDetails.

        :param query_properties: The query_properties of this CreateMetricExtensionDetails.
        :type: oci.stack_monitoring.models.MetricExtensionQueryProperties
        """
        self._query_properties = query_properties

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
