# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20160918

from .endpoint import Endpoint
from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class PrivateServiceAccessEndpoint(Endpoint):
    """
    Defines the details required for an PRIVATE_SERVICE_ACCESS type `Endpoint`.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new PrivateServiceAccessEndpoint object with values from keyword arguments. The default value of the :py:attr:`~oci.vn_monitoring.models.PrivateServiceAccessEndpoint.type` attribute
        of this class is ``PRIVATE_SERVICE_ACCESS`` and it should not be changed.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param type:
            The value to assign to the type property of this PrivateServiceAccessEndpoint.
            Allowed values for this property are: "IP_ADDRESS", "SUBNET", "COMPUTE_INSTANCE", "VNIC", "LOAD_BALANCER", "LOAD_BALANCER_LISTENER", "NETWORK_LOAD_BALANCER", "NETWORK_LOAD_BALANCER_LISTENER", "VLAN", "ON_PREM", "PRIVATE_SERVICE_ACCESS"
        :type type: str

        :param psa_id:
            The value to assign to the psa_id property of this PrivateServiceAccessEndpoint.
        :type psa_id: str

        """
        self.swagger_types = {
            'type': 'str',
            'psa_id': 'str'
        }
        self.attribute_map = {
            'type': 'type',
            'psa_id': 'psaId'
        }
        self._type = None
        self._psa_id = None
        self._type = 'PRIVATE_SERVICE_ACCESS'

    @property
    def psa_id(self):
        """
        **[Required]** Gets the psa_id of this PrivateServiceAccessEndpoint.
        The `OCID`__ of the PSA.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :return: The psa_id of this PrivateServiceAccessEndpoint.
        :rtype: str
        """
        return self._psa_id

    @psa_id.setter
    def psa_id(self, psa_id):
        """
        Sets the psa_id of this PrivateServiceAccessEndpoint.
        The `OCID`__ of the PSA.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :param psa_id: The psa_id of this PrivateServiceAccessEndpoint.
        :type: str
        """
        self._psa_id = psa_id

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
