# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20160918


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class UpdateFlexTunnelDetails(object):
    """
    These details can be included in a request to update a flex tunnel.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new UpdateFlexTunnelDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param display_name:
            The value to assign to the display_name property of this UpdateFlexTunnelDetails.
        :type display_name: str

        :param flex_tunnel_configuration:
            The value to assign to the flex_tunnel_configuration property of this UpdateFlexTunnelDetails.
        :type flex_tunnel_configuration: oci.vn_monitoring.models.UpdateFlexTunnelConfigurationDetails

        :param freeform_tags:
            The value to assign to the freeform_tags property of this UpdateFlexTunnelDetails.
        :type freeform_tags: dict(str, str)

        :param defined_tags:
            The value to assign to the defined_tags property of this UpdateFlexTunnelDetails.
        :type defined_tags: dict(str, dict(str, object))

        """
        self.swagger_types = {
            'display_name': 'str',
            'flex_tunnel_configuration': 'UpdateFlexTunnelConfigurationDetails',
            'freeform_tags': 'dict(str, str)',
            'defined_tags': 'dict(str, dict(str, object))'
        }
        self.attribute_map = {
            'display_name': 'displayName',
            'flex_tunnel_configuration': 'flexTunnelConfiguration',
            'freeform_tags': 'freeformTags',
            'defined_tags': 'definedTags'
        }
        self._display_name = None
        self._flex_tunnel_configuration = None
        self._freeform_tags = None
        self._defined_tags = None

    @property
    def display_name(self):
        """
        Gets the display_name of this UpdateFlexTunnelDetails.
        A user-friendly name. Does not have to be unique, and it's changeable.
        Avoid entering confidential information.


        :return: The display_name of this UpdateFlexTunnelDetails.
        :rtype: str
        """
        return self._display_name

    @display_name.setter
    def display_name(self, display_name):
        """
        Sets the display_name of this UpdateFlexTunnelDetails.
        A user-friendly name. Does not have to be unique, and it's changeable.
        Avoid entering confidential information.


        :param display_name: The display_name of this UpdateFlexTunnelDetails.
        :type: str
        """
        self._display_name = display_name

    @property
    def flex_tunnel_configuration(self):
        """
        Gets the flex_tunnel_configuration of this UpdateFlexTunnelDetails.

        :return: The flex_tunnel_configuration of this UpdateFlexTunnelDetails.
        :rtype: oci.vn_monitoring.models.UpdateFlexTunnelConfigurationDetails
        """
        return self._flex_tunnel_configuration

    @flex_tunnel_configuration.setter
    def flex_tunnel_configuration(self, flex_tunnel_configuration):
        """
        Sets the flex_tunnel_configuration of this UpdateFlexTunnelDetails.

        :param flex_tunnel_configuration: The flex_tunnel_configuration of this UpdateFlexTunnelDetails.
        :type: oci.vn_monitoring.models.UpdateFlexTunnelConfigurationDetails
        """
        self._flex_tunnel_configuration = flex_tunnel_configuration

    @property
    def freeform_tags(self):
        """
        Gets the freeform_tags of this UpdateFlexTunnelDetails.
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only.
        Example: `{\"bar-key\": \"value\"}`


        :return: The freeform_tags of this UpdateFlexTunnelDetails.
        :rtype: dict(str, str)
        """
        return self._freeform_tags

    @freeform_tags.setter
    def freeform_tags(self, freeform_tags):
        """
        Sets the freeform_tags of this UpdateFlexTunnelDetails.
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only.
        Example: `{\"bar-key\": \"value\"}`


        :param freeform_tags: The freeform_tags of this UpdateFlexTunnelDetails.
        :type: dict(str, str)
        """
        self._freeform_tags = freeform_tags

    @property
    def defined_tags(self):
        """
        Gets the defined_tags of this UpdateFlexTunnelDetails.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        Example: `{\"foo-namespace\": {\"bar-key\": \"value\"}}`


        :return: The defined_tags of this UpdateFlexTunnelDetails.
        :rtype: dict(str, dict(str, object))
        """
        return self._defined_tags

    @defined_tags.setter
    def defined_tags(self, defined_tags):
        """
        Sets the defined_tags of this UpdateFlexTunnelDetails.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        Example: `{\"foo-namespace\": {\"bar-key\": \"value\"}}`


        :param defined_tags: The defined_tags of this UpdateFlexTunnelDetails.
        :type: dict(str, dict(str, object))
        """
        self._defined_tags = defined_tags

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
