# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20220421


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class RelatedVulnerabilityReference(object):
    """
    A related vulnerability reference is an object with vulnerabilityId and source to identify a related vulnerability.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new RelatedVulnerabilityReference object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param id:
            The value to assign to the id property of this RelatedVulnerabilityReference.
        :type id: str

        :param source:
            The value to assign to the source property of this RelatedVulnerabilityReference.
        :type source: str

        """
        self.swagger_types = {
            'id': 'str',
            'source': 'str'
        }
        self.attribute_map = {
            'id': 'id',
            'source': 'source'
        }
        self._id = None
        self._source = None

    @property
    def id(self):
        """
        **[Required]** Gets the id of this RelatedVulnerabilityReference.
        Unique vulnerability identifier for a source, e.g., CVE-1999-0067.


        :return: The id of this RelatedVulnerabilityReference.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this RelatedVulnerabilityReference.
        Unique vulnerability identifier for a source, e.g., CVE-1999-0067.


        :param id: The id of this RelatedVulnerabilityReference.
        :type: str
        """
        self._id = id

    @property
    def source(self):
        """
        **[Required]** Gets the source of this RelatedVulnerabilityReference.
        Source that publishes the vulnerability.


        :return: The source of this RelatedVulnerabilityReference.
        :rtype: str
        """
        return self._source

    @source.setter
    def source(self, source):
        """
        Sets the source of this RelatedVulnerabilityReference.
        Source that publishes the vulnerability.


        :param source: The source of this RelatedVulnerabilityReference.
        :type: str
        """
        self._source = source

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
