# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20220125


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class VideoMetadata(object):
    """
    Video information.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new VideoMetadata object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param frame_count:
            The value to assign to the frame_count property of this VideoMetadata.
        :type frame_count: int

        :param frame_rate:
            The value to assign to the frame_rate property of this VideoMetadata.
        :type frame_rate: float

        :param frame_width:
            The value to assign to the frame_width property of this VideoMetadata.
        :type frame_width: int

        :param frame_height:
            The value to assign to the frame_height property of this VideoMetadata.
        :type frame_height: int

        """
        self.swagger_types = {
            'frame_count': 'int',
            'frame_rate': 'float',
            'frame_width': 'int',
            'frame_height': 'int'
        }
        self.attribute_map = {
            'frame_count': 'frameCount',
            'frame_rate': 'frameRate',
            'frame_width': 'frameWidth',
            'frame_height': 'frameHeight'
        }
        self._frame_count = None
        self._frame_rate = None
        self._frame_width = None
        self._frame_height = None

    @property
    def frame_count(self):
        """
        **[Required]** Gets the frame_count of this VideoMetadata.
        Total number of frames.


        :return: The frame_count of this VideoMetadata.
        :rtype: int
        """
        return self._frame_count

    @frame_count.setter
    def frame_count(self, frame_count):
        """
        Sets the frame_count of this VideoMetadata.
        Total number of frames.


        :param frame_count: The frame_count of this VideoMetadata.
        :type: int
        """
        self._frame_count = frame_count

    @property
    def frame_rate(self):
        """
        **[Required]** Gets the frame_rate of this VideoMetadata.
        Video framerate.


        :return: The frame_rate of this VideoMetadata.
        :rtype: float
        """
        return self._frame_rate

    @frame_rate.setter
    def frame_rate(self, frame_rate):
        """
        Sets the frame_rate of this VideoMetadata.
        Video framerate.


        :param frame_rate: The frame_rate of this VideoMetadata.
        :type: float
        """
        self._frame_rate = frame_rate

    @property
    def frame_width(self):
        """
        **[Required]** Gets the frame_width of this VideoMetadata.
        Width of each frame.


        :return: The frame_width of this VideoMetadata.
        :rtype: int
        """
        return self._frame_width

    @frame_width.setter
    def frame_width(self, frame_width):
        """
        Sets the frame_width of this VideoMetadata.
        Width of each frame.


        :param frame_width: The frame_width of this VideoMetadata.
        :type: int
        """
        self._frame_width = frame_width

    @property
    def frame_height(self):
        """
        **[Required]** Gets the frame_height of this VideoMetadata.
        Height of each frame.


        :return: The frame_height of this VideoMetadata.
        :rtype: int
        """
        return self._frame_height

    @frame_height.setter
    def frame_height(self, frame_height):
        """
        Sets the frame_height of this VideoMetadata.
        Height of each frame.


        :param frame_height: The frame_height of this VideoMetadata.
        :type: int
        """
        self._frame_height = frame_height

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
