# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20220125

from .video_feature import VideoFeature
from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class VideoTextDetectionFeature(VideoFeature):
    """
    Video text detection feature
    """

    def __init__(self, **kwargs):
        """
        Initializes a new VideoTextDetectionFeature object with values from keyword arguments. The default value of the :py:attr:`~oci.ai_vision.models.VideoTextDetectionFeature.feature_type` attribute
        of this class is ``TEXT_DETECTION`` and it should not be changed.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param feature_type:
            The value to assign to the feature_type property of this VideoTextDetectionFeature.
            Allowed values for this property are: "LABEL_DETECTION", "OBJECT_DETECTION", "TEXT_DETECTION", "FACE_DETECTION", "OBJECT_TRACKING"
        :type feature_type: str

        :param min_confidence:
            The value to assign to the min_confidence property of this VideoTextDetectionFeature.
        :type min_confidence: float

        """
        self.swagger_types = {
            'feature_type': 'str',
            'min_confidence': 'float'
        }
        self.attribute_map = {
            'feature_type': 'featureType',
            'min_confidence': 'minConfidence'
        }
        self._feature_type = None
        self._min_confidence = None
        self._feature_type = 'TEXT_DETECTION'

    @property
    def min_confidence(self):
        """
        Gets the min_confidence of this VideoTextDetectionFeature.
        The minimum confidence score, between 0 and 1,
        when the value is set, results with lower confidence will not be returned.


        :return: The min_confidence of this VideoTextDetectionFeature.
        :rtype: float
        """
        return self._min_confidence

    @min_confidence.setter
    def min_confidence(self, min_confidence):
        """
        Sets the min_confidence of this VideoTextDetectionFeature.
        The minimum confidence score, between 0 and 1,
        when the value is set, results with lower confidence will not be returned.


        :param min_confidence: The min_confidence of this VideoTextDetectionFeature.
        :type: float
        """
        self._min_confidence = min_confidence

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
