# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20210201


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class MatchAgentsWithAttributeKey(object):
    """
    The object representing the agent matching attribute keys.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new MatchAgentsWithAttributeKey object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param agent_attribute_keys:
            The value to assign to the agent_attribute_keys property of this MatchAgentsWithAttributeKey.
        :type agent_attribute_keys: list[str]

        """
        self.swagger_types = {
            'agent_attribute_keys': 'list[str]'
        }
        self.attribute_map = {
            'agent_attribute_keys': 'agentAttributeKeys'
        }
        self._agent_attribute_keys = None

    @property
    def agent_attribute_keys(self):
        """
        **[Required]** Gets the agent_attribute_keys of this MatchAgentsWithAttributeKey.
        The list of agent matching attribute keys to be updated.


        :return: The agent_attribute_keys of this MatchAgentsWithAttributeKey.
        :rtype: list[str]
        """
        return self._agent_attribute_keys

    @agent_attribute_keys.setter
    def agent_attribute_keys(self, agent_attribute_keys):
        """
        Sets the agent_attribute_keys of this MatchAgentsWithAttributeKey.
        The list of agent matching attribute keys to be updated.


        :param agent_attribute_keys: The agent_attribute_keys of this MatchAgentsWithAttributeKey.
        :type: list[str]
        """
        self._agent_attribute_keys = agent_attribute_keys

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
