# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20251031


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class BatchJob(object):
    """
    A batch job represents the execution unit that is invoked on a batch's pools of compute resources.
    A job is composed of one or more tasks, which are the executable commands.

    To use any of the API operations, you must be authorized in an IAM policy. If you're not authorized, talk to
    an administrator. If you're an administrator who needs to write policies to give users access, see
    `Getting Started with Policies`__.

    __ https://docs.cloud.oracle.com/iaas/Content/Identity/policiesgs/get-started-with-policies.htm
    """

    #: A constant which can be used with the lifecycle_state property of a BatchJob.
    #: This constant has a value of "ACCEPTED"
    LIFECYCLE_STATE_ACCEPTED = "ACCEPTED"

    #: A constant which can be used with the lifecycle_state property of a BatchJob.
    #: This constant has a value of "WAITING"
    LIFECYCLE_STATE_WAITING = "WAITING"

    #: A constant which can be used with the lifecycle_state property of a BatchJob.
    #: This constant has a value of "IN_PROGRESS"
    LIFECYCLE_STATE_IN_PROGRESS = "IN_PROGRESS"

    #: A constant which can be used with the lifecycle_state property of a BatchJob.
    #: This constant has a value of "SUCCEEDED"
    LIFECYCLE_STATE_SUCCEEDED = "SUCCEEDED"

    #: A constant which can be used with the lifecycle_state property of a BatchJob.
    #: This constant has a value of "NEEDS_ATTENTION"
    LIFECYCLE_STATE_NEEDS_ATTENTION = "NEEDS_ATTENTION"

    #: A constant which can be used with the lifecycle_state property of a BatchJob.
    #: This constant has a value of "FAILED"
    LIFECYCLE_STATE_FAILED = "FAILED"

    #: A constant which can be used with the lifecycle_state property of a BatchJob.
    #: This constant has a value of "CANCELING"
    LIFECYCLE_STATE_CANCELING = "CANCELING"

    #: A constant which can be used with the lifecycle_state property of a BatchJob.
    #: This constant has a value of "CANCELED"
    LIFECYCLE_STATE_CANCELED = "CANCELED"

    def __init__(self, **kwargs):
        """
        Initializes a new BatchJob object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param id:
            The value to assign to the id property of this BatchJob.
        :type id: str

        :param compartment_id:
            The value to assign to the compartment_id property of this BatchJob.
        :type compartment_id: str

        :param batch_job_pool_id:
            The value to assign to the batch_job_pool_id property of this BatchJob.
        :type batch_job_pool_id: str

        :param batch_context_id:
            The value to assign to the batch_context_id property of this BatchJob.
        :type batch_context_id: str

        :param display_name:
            The value to assign to the display_name property of this BatchJob.
        :type display_name: str

        :param description:
            The value to assign to the description property of this BatchJob.
        :type description: str

        :param priority:
            The value to assign to the priority property of this BatchJob.
        :type priority: int

        :param progress_percentage:
            The value to assign to the progress_percentage property of this BatchJob.
        :type progress_percentage: int

        :param progress_details:
            The value to assign to the progress_details property of this BatchJob.
        :type progress_details: str

        :param environment_variables:
            The value to assign to the environment_variables property of this BatchJob.
        :type environment_variables: list[oci.batch.models.EnvironmentVariable]

        :param time_created:
            The value to assign to the time_created property of this BatchJob.
        :type time_created: datetime

        :param time_updated:
            The value to assign to the time_updated property of this BatchJob.
        :type time_updated: datetime

        :param lifecycle_state:
            The value to assign to the lifecycle_state property of this BatchJob.
            Allowed values for this property are: "ACCEPTED", "WAITING", "IN_PROGRESS", "SUCCEEDED", "NEEDS_ATTENTION", "FAILED", "CANCELING", "CANCELED", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type lifecycle_state: str

        :param lifecycle_details:
            The value to assign to the lifecycle_details property of this BatchJob.
        :type lifecycle_details: str

        :param freeform_tags:
            The value to assign to the freeform_tags property of this BatchJob.
        :type freeform_tags: dict(str, str)

        :param defined_tags:
            The value to assign to the defined_tags property of this BatchJob.
        :type defined_tags: dict(str, dict(str, object))

        :param system_tags:
            The value to assign to the system_tags property of this BatchJob.
        :type system_tags: dict(str, dict(str, object))

        """
        self.swagger_types = {
            'id': 'str',
            'compartment_id': 'str',
            'batch_job_pool_id': 'str',
            'batch_context_id': 'str',
            'display_name': 'str',
            'description': 'str',
            'priority': 'int',
            'progress_percentage': 'int',
            'progress_details': 'str',
            'environment_variables': 'list[EnvironmentVariable]',
            'time_created': 'datetime',
            'time_updated': 'datetime',
            'lifecycle_state': 'str',
            'lifecycle_details': 'str',
            'freeform_tags': 'dict(str, str)',
            'defined_tags': 'dict(str, dict(str, object))',
            'system_tags': 'dict(str, dict(str, object))'
        }
        self.attribute_map = {
            'id': 'id',
            'compartment_id': 'compartmentId',
            'batch_job_pool_id': 'batchJobPoolId',
            'batch_context_id': 'batchContextId',
            'display_name': 'displayName',
            'description': 'description',
            'priority': 'priority',
            'progress_percentage': 'progressPercentage',
            'progress_details': 'progressDetails',
            'environment_variables': 'environmentVariables',
            'time_created': 'timeCreated',
            'time_updated': 'timeUpdated',
            'lifecycle_state': 'lifecycleState',
            'lifecycle_details': 'lifecycleDetails',
            'freeform_tags': 'freeformTags',
            'defined_tags': 'definedTags',
            'system_tags': 'systemTags'
        }
        self._id = None
        self._compartment_id = None
        self._batch_job_pool_id = None
        self._batch_context_id = None
        self._display_name = None
        self._description = None
        self._priority = None
        self._progress_percentage = None
        self._progress_details = None
        self._environment_variables = None
        self._time_created = None
        self._time_updated = None
        self._lifecycle_state = None
        self._lifecycle_details = None
        self._freeform_tags = None
        self._defined_tags = None
        self._system_tags = None

    @property
    def id(self):
        """
        **[Required]** Gets the id of this BatchJob.
        The `OCID`__ of the batch job.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :return: The id of this BatchJob.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this BatchJob.
        The `OCID`__ of the batch job.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :param id: The id of this BatchJob.
        :type: str
        """
        self._id = id

    @property
    def compartment_id(self):
        """
        **[Required]** Gets the compartment_id of this BatchJob.
        The `OCID`__ of the compartment.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :return: The compartment_id of this BatchJob.
        :rtype: str
        """
        return self._compartment_id

    @compartment_id.setter
    def compartment_id(self, compartment_id):
        """
        Sets the compartment_id of this BatchJob.
        The `OCID`__ of the compartment.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :param compartment_id: The compartment_id of this BatchJob.
        :type: str
        """
        self._compartment_id = compartment_id

    @property
    def batch_job_pool_id(self):
        """
        **[Required]** Gets the batch_job_pool_id of this BatchJob.
        The `OCID`__ of the parent batch job pool.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :return: The batch_job_pool_id of this BatchJob.
        :rtype: str
        """
        return self._batch_job_pool_id

    @batch_job_pool_id.setter
    def batch_job_pool_id(self, batch_job_pool_id):
        """
        Sets the batch_job_pool_id of this BatchJob.
        The `OCID`__ of the parent batch job pool.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :param batch_job_pool_id: The batch_job_pool_id of this BatchJob.
        :type: str
        """
        self._batch_job_pool_id = batch_job_pool_id

    @property
    def batch_context_id(self):
        """
        **[Required]** Gets the batch_context_id of this BatchJob.
        The `OCID`__ of the parent batch context of the parent job pool.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :return: The batch_context_id of this BatchJob.
        :rtype: str
        """
        return self._batch_context_id

    @batch_context_id.setter
    def batch_context_id(self, batch_context_id):
        """
        Sets the batch_context_id of this BatchJob.
        The `OCID`__ of the parent batch context of the parent job pool.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :param batch_context_id: The batch_context_id of this BatchJob.
        :type: str
        """
        self._batch_context_id = batch_context_id

    @property
    def display_name(self):
        """
        **[Required]** Gets the display_name of this BatchJob.
        A user-friendly name. Does not have to be unique, and it's changeable.


        :return: The display_name of this BatchJob.
        :rtype: str
        """
        return self._display_name

    @display_name.setter
    def display_name(self, display_name):
        """
        Sets the display_name of this BatchJob.
        A user-friendly name. Does not have to be unique, and it's changeable.


        :param display_name: The display_name of this BatchJob.
        :type: str
        """
        self._display_name = display_name

    @property
    def description(self):
        """
        Gets the description of this BatchJob.
        An optional description that provides additional context next to the displayName.


        :return: The description of this BatchJob.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """
        Sets the description of this BatchJob.
        An optional description that provides additional context next to the displayName.


        :param description: The description of this BatchJob.
        :type: str
        """
        self._description = description

    @property
    def priority(self):
        """
        Gets the priority of this BatchJob.
        A value calculated by the system based on the priority tags.


        :return: The priority of this BatchJob.
        :rtype: int
        """
        return self._priority

    @priority.setter
    def priority(self, priority):
        """
        Sets the priority of this BatchJob.
        A value calculated by the system based on the priority tags.


        :param priority: The priority of this BatchJob.
        :type: int
        """
        self._priority = priority

    @property
    def progress_percentage(self):
        """
        Gets the progress_percentage of this BatchJob.
        A percentage value (0..100) of the job completion.


        :return: The progress_percentage of this BatchJob.
        :rtype: int
        """
        return self._progress_percentage

    @progress_percentage.setter
    def progress_percentage(self, progress_percentage):
        """
        Sets the progress_percentage of this BatchJob.
        A percentage value (0..100) of the job completion.


        :param progress_percentage: The progress_percentage of this BatchJob.
        :type: int
        """
        self._progress_percentage = progress_percentage

    @property
    def progress_details(self):
        """
        Gets the progress_details of this BatchJob.
        A more detailed textual representation of the job completion.


        :return: The progress_details of this BatchJob.
        :rtype: str
        """
        return self._progress_details

    @progress_details.setter
    def progress_details(self, progress_details):
        """
        Sets the progress_details of this BatchJob.
        A more detailed textual representation of the job completion.


        :param progress_details: The progress_details of this BatchJob.
        :type: str
        """
        self._progress_details = progress_details

    @property
    def environment_variables(self):
        """
        Gets the environment_variables of this BatchJob.
        An environment variables to use for the job's tasks (can be overridden by task's environment variables).


        :return: The environment_variables of this BatchJob.
        :rtype: list[oci.batch.models.EnvironmentVariable]
        """
        return self._environment_variables

    @environment_variables.setter
    def environment_variables(self, environment_variables):
        """
        Sets the environment_variables of this BatchJob.
        An environment variables to use for the job's tasks (can be overridden by task's environment variables).


        :param environment_variables: The environment_variables of this BatchJob.
        :type: list[oci.batch.models.EnvironmentVariable]
        """
        self._environment_variables = environment_variables

    @property
    def time_created(self):
        """
        **[Required]** Gets the time_created of this BatchJob.
        The date and time the batch job was created, in the format defined by `RFC 3339`__.

        Example: `2016-08-25T21:10:29.600Z`

        __ https://tools.ietf.org/html/rfc3339


        :return: The time_created of this BatchJob.
        :rtype: datetime
        """
        return self._time_created

    @time_created.setter
    def time_created(self, time_created):
        """
        Sets the time_created of this BatchJob.
        The date and time the batch job was created, in the format defined by `RFC 3339`__.

        Example: `2016-08-25T21:10:29.600Z`

        __ https://tools.ietf.org/html/rfc3339


        :param time_created: The time_created of this BatchJob.
        :type: datetime
        """
        self._time_created = time_created

    @property
    def time_updated(self):
        """
        Gets the time_updated of this BatchJob.
        The date and time the batch job was updated, in the format defined by `RFC 3339`__.

        Example: `2016-08-25T21:10:29.600Z`

        __ https://tools.ietf.org/html/rfc3339


        :return: The time_updated of this BatchJob.
        :rtype: datetime
        """
        return self._time_updated

    @time_updated.setter
    def time_updated(self, time_updated):
        """
        Sets the time_updated of this BatchJob.
        The date and time the batch job was updated, in the format defined by `RFC 3339`__.

        Example: `2016-08-25T21:10:29.600Z`

        __ https://tools.ietf.org/html/rfc3339


        :param time_updated: The time_updated of this BatchJob.
        :type: datetime
        """
        self._time_updated = time_updated

    @property
    def lifecycle_state(self):
        """
        **[Required]** Gets the lifecycle_state of this BatchJob.
        The current state of the batch job.

        Allowed values for this property are: "ACCEPTED", "WAITING", "IN_PROGRESS", "SUCCEEDED", "NEEDS_ATTENTION", "FAILED", "CANCELING", "CANCELED", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The lifecycle_state of this BatchJob.
        :rtype: str
        """
        return self._lifecycle_state

    @lifecycle_state.setter
    def lifecycle_state(self, lifecycle_state):
        """
        Sets the lifecycle_state of this BatchJob.
        The current state of the batch job.


        :param lifecycle_state: The lifecycle_state of this BatchJob.
        :type: str
        """
        allowed_values = ["ACCEPTED", "WAITING", "IN_PROGRESS", "SUCCEEDED", "NEEDS_ATTENTION", "FAILED", "CANCELING", "CANCELED"]
        if not value_allowed_none_or_none_sentinel(lifecycle_state, allowed_values):
            lifecycle_state = 'UNKNOWN_ENUM_VALUE'
        self._lifecycle_state = lifecycle_state

    @property
    def lifecycle_details(self):
        """
        Gets the lifecycle_details of this BatchJob.
        A message that describes the current state of the batch job in more detail. For example,
        can be used to provide actionable information for a resource in the Failed state.


        :return: The lifecycle_details of this BatchJob.
        :rtype: str
        """
        return self._lifecycle_details

    @lifecycle_details.setter
    def lifecycle_details(self, lifecycle_details):
        """
        Sets the lifecycle_details of this BatchJob.
        A message that describes the current state of the batch job in more detail. For example,
        can be used to provide actionable information for a resource in the Failed state.


        :param lifecycle_details: The lifecycle_details of this BatchJob.
        :type: str
        """
        self._lifecycle_details = lifecycle_details

    @property
    def freeform_tags(self):
        """
        **[Required]** Gets the freeform_tags of this BatchJob.
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace.
        For more information, see `Resource Tags`__.

        Example: `{\"Department\": \"Finance\"}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :return: The freeform_tags of this BatchJob.
        :rtype: dict(str, str)
        """
        return self._freeform_tags

    @freeform_tags.setter
    def freeform_tags(self, freeform_tags):
        """
        Sets the freeform_tags of this BatchJob.
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace.
        For more information, see `Resource Tags`__.

        Example: `{\"Department\": \"Finance\"}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :param freeform_tags: The freeform_tags of this BatchJob.
        :type: dict(str, str)
        """
        self._freeform_tags = freeform_tags

    @property
    def defined_tags(self):
        """
        **[Required]** Gets the defined_tags of this BatchJob.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        For more information, see `Resource Tags`__.

        Example: `{\"Operations\": {\"CostCenter\": \"42\"}}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :return: The defined_tags of this BatchJob.
        :rtype: dict(str, dict(str, object))
        """
        return self._defined_tags

    @defined_tags.setter
    def defined_tags(self, defined_tags):
        """
        Sets the defined_tags of this BatchJob.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        For more information, see `Resource Tags`__.

        Example: `{\"Operations\": {\"CostCenter\": \"42\"}}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :param defined_tags: The defined_tags of this BatchJob.
        :type: dict(str, dict(str, object))
        """
        self._defined_tags = defined_tags

    @property
    def system_tags(self):
        """
        **[Required]** Gets the system_tags of this BatchJob.
        System tags for this resource. Each key is predefined and scoped to a namespace.

        Example: `{\"orcl-cloud\": {\"free-tier-retained\": \"true\"}}`


        :return: The system_tags of this BatchJob.
        :rtype: dict(str, dict(str, object))
        """
        return self._system_tags

    @system_tags.setter
    def system_tags(self, system_tags):
        """
        Sets the system_tags of this BatchJob.
        System tags for this resource. Each key is predefined and scoped to a namespace.

        Example: `{\"orcl-cloud\": {\"free-tier-retained\": \"true\"}}`


        :param system_tags: The system_tags of this BatchJob.
        :type: dict(str, dict(str, object))
        """
        self._system_tags = system_tags

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
