# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20190531


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class IdentityConfiguration(object):
    """
    Details about the identity configuration
    """

    #: A constant which can be used with the lifecycle_state property of a IdentityConfiguration.
    #: This constant has a value of "ACTIVE"
    LIFECYCLE_STATE_ACTIVE = "ACTIVE"

    #: A constant which can be used with the lifecycle_state property of a IdentityConfiguration.
    #: This constant has a value of "DELETED"
    LIFECYCLE_STATE_DELETED = "DELETED"

    def __init__(self, **kwargs):
        """
        Initializes a new IdentityConfiguration object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param id:
            The value to assign to the id property of this IdentityConfiguration.
        :type id: str

        :param display_name:
            The value to assign to the display_name property of this IdentityConfiguration.
        :type display_name: str

        :param identity_domain_id:
            The value to assign to the identity_domain_id property of this IdentityConfiguration.
        :type identity_domain_id: str

        :param confidential_application_id:
            The value to assign to the confidential_application_id property of this IdentityConfiguration.
        :type confidential_application_id: str

        :param lifecycle_state:
            The value to assign to the lifecycle_state property of this IdentityConfiguration.
            Allowed values for this property are: "ACTIVE", "DELETED", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type lifecycle_state: str

        :param time_created:
            The value to assign to the time_created property of this IdentityConfiguration.
        :type time_created: datetime

        :param time_updated:
            The value to assign to the time_updated property of this IdentityConfiguration.
        :type time_updated: datetime

        :param iam_user_sync_configuration:
            The value to assign to the iam_user_sync_configuration property of this IdentityConfiguration.
        :type iam_user_sync_configuration: oci.bds.models.IamUserSyncConfiguration

        :param upst_configuration:
            The value to assign to the upst_configuration property of this IdentityConfiguration.
        :type upst_configuration: oci.bds.models.UpstConfiguration

        """
        self.swagger_types = {
            'id': 'str',
            'display_name': 'str',
            'identity_domain_id': 'str',
            'confidential_application_id': 'str',
            'lifecycle_state': 'str',
            'time_created': 'datetime',
            'time_updated': 'datetime',
            'iam_user_sync_configuration': 'IamUserSyncConfiguration',
            'upst_configuration': 'UpstConfiguration'
        }
        self.attribute_map = {
            'id': 'id',
            'display_name': 'displayName',
            'identity_domain_id': 'identityDomainId',
            'confidential_application_id': 'confidentialApplicationId',
            'lifecycle_state': 'lifecycleState',
            'time_created': 'timeCreated',
            'time_updated': 'timeUpdated',
            'iam_user_sync_configuration': 'iamUserSyncConfiguration',
            'upst_configuration': 'upstConfiguration'
        }
        self._id = None
        self._display_name = None
        self._identity_domain_id = None
        self._confidential_application_id = None
        self._lifecycle_state = None
        self._time_created = None
        self._time_updated = None
        self._iam_user_sync_configuration = None
        self._upst_configuration = None

    @property
    def id(self):
        """
        **[Required]** Gets the id of this IdentityConfiguration.
        The id of the UPST config


        :return: The id of this IdentityConfiguration.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this IdentityConfiguration.
        The id of the UPST config


        :param id: The id of this IdentityConfiguration.
        :type: str
        """
        self._id = id

    @property
    def display_name(self):
        """
        **[Required]** Gets the display_name of this IdentityConfiguration.
        the display name of the identity configuration


        :return: The display_name of this IdentityConfiguration.
        :rtype: str
        """
        return self._display_name

    @display_name.setter
    def display_name(self, display_name):
        """
        Sets the display_name of this IdentityConfiguration.
        the display name of the identity configuration


        :param display_name: The display_name of this IdentityConfiguration.
        :type: str
        """
        self._display_name = display_name

    @property
    def identity_domain_id(self):
        """
        **[Required]** Gets the identity_domain_id of this IdentityConfiguration.
        Identity domain to use for identity config


        :return: The identity_domain_id of this IdentityConfiguration.
        :rtype: str
        """
        return self._identity_domain_id

    @identity_domain_id.setter
    def identity_domain_id(self, identity_domain_id):
        """
        Sets the identity_domain_id of this IdentityConfiguration.
        Identity domain to use for identity config


        :param identity_domain_id: The identity_domain_id of this IdentityConfiguration.
        :type: str
        """
        self._identity_domain_id = identity_domain_id

    @property
    def confidential_application_id(self):
        """
        **[Required]** Gets the confidential_application_id of this IdentityConfiguration.
        identity domain confidential application ID for the identity config


        :return: The confidential_application_id of this IdentityConfiguration.
        :rtype: str
        """
        return self._confidential_application_id

    @confidential_application_id.setter
    def confidential_application_id(self, confidential_application_id):
        """
        Sets the confidential_application_id of this IdentityConfiguration.
        identity domain confidential application ID for the identity config


        :param confidential_application_id: The confidential_application_id of this IdentityConfiguration.
        :type: str
        """
        self._confidential_application_id = confidential_application_id

    @property
    def lifecycle_state(self):
        """
        **[Required]** Gets the lifecycle_state of this IdentityConfiguration.
        Lifecycle state of the identity configuration

        Allowed values for this property are: "ACTIVE", "DELETED", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The lifecycle_state of this IdentityConfiguration.
        :rtype: str
        """
        return self._lifecycle_state

    @lifecycle_state.setter
    def lifecycle_state(self, lifecycle_state):
        """
        Sets the lifecycle_state of this IdentityConfiguration.
        Lifecycle state of the identity configuration


        :param lifecycle_state: The lifecycle_state of this IdentityConfiguration.
        :type: str
        """
        allowed_values = ["ACTIVE", "DELETED"]
        if not value_allowed_none_or_none_sentinel(lifecycle_state, allowed_values):
            lifecycle_state = 'UNKNOWN_ENUM_VALUE'
        self._lifecycle_state = lifecycle_state

    @property
    def time_created(self):
        """
        **[Required]** Gets the time_created of this IdentityConfiguration.
        Time when this identity configuration was created, shown as an RFC 3339 formatted datetime string.


        :return: The time_created of this IdentityConfiguration.
        :rtype: datetime
        """
        return self._time_created

    @time_created.setter
    def time_created(self, time_created):
        """
        Sets the time_created of this IdentityConfiguration.
        Time when this identity configuration was created, shown as an RFC 3339 formatted datetime string.


        :param time_created: The time_created of this IdentityConfiguration.
        :type: datetime
        """
        self._time_created = time_created

    @property
    def time_updated(self):
        """
        **[Required]** Gets the time_updated of this IdentityConfiguration.
        Time when this identity configuration config was updated, shown as an RFC 3339 formatted datetime string.


        :return: The time_updated of this IdentityConfiguration.
        :rtype: datetime
        """
        return self._time_updated

    @time_updated.setter
    def time_updated(self, time_updated):
        """
        Sets the time_updated of this IdentityConfiguration.
        Time when this identity configuration config was updated, shown as an RFC 3339 formatted datetime string.


        :param time_updated: The time_updated of this IdentityConfiguration.
        :type: datetime
        """
        self._time_updated = time_updated

    @property
    def iam_user_sync_configuration(self):
        """
        Gets the iam_user_sync_configuration of this IdentityConfiguration.

        :return: The iam_user_sync_configuration of this IdentityConfiguration.
        :rtype: oci.bds.models.IamUserSyncConfiguration
        """
        return self._iam_user_sync_configuration

    @iam_user_sync_configuration.setter
    def iam_user_sync_configuration(self, iam_user_sync_configuration):
        """
        Sets the iam_user_sync_configuration of this IdentityConfiguration.

        :param iam_user_sync_configuration: The iam_user_sync_configuration of this IdentityConfiguration.
        :type: oci.bds.models.IamUserSyncConfiguration
        """
        self._iam_user_sync_configuration = iam_user_sync_configuration

    @property
    def upst_configuration(self):
        """
        Gets the upst_configuration of this IdentityConfiguration.

        :return: The upst_configuration of this IdentityConfiguration.
        :rtype: oci.bds.models.UpstConfiguration
        """
        return self._upst_configuration

    @upst_configuration.setter
    def upst_configuration(self, upst_configuration):
        """
        Sets the upst_configuration of this IdentityConfiguration.

        :param upst_configuration: The upst_configuration of this IdentityConfiguration.
        :type: oci.bds.models.UpstConfiguration
        """
        self._upst_configuration = upst_configuration

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
