# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20190531


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class ReplaceNodeDetails(object):
    """
    The information about the node to be replaced.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new ReplaceNodeDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param node_host_name:
            The value to assign to the node_host_name property of this ReplaceNodeDetails.
        :type node_host_name: str

        :param node_backup_id:
            The value to assign to the node_backup_id property of this ReplaceNodeDetails.
        :type node_backup_id: str

        :param cluster_admin_password:
            The value to assign to the cluster_admin_password property of this ReplaceNodeDetails.
        :type cluster_admin_password: str

        :param shape:
            The value to assign to the shape property of this ReplaceNodeDetails.
        :type shape: str

        """
        self.swagger_types = {
            'node_host_name': 'str',
            'node_backup_id': 'str',
            'cluster_admin_password': 'str',
            'shape': 'str'
        }
        self.attribute_map = {
            'node_host_name': 'nodeHostName',
            'node_backup_id': 'nodeBackupId',
            'cluster_admin_password': 'clusterAdminPassword',
            'shape': 'shape'
        }
        self._node_host_name = None
        self._node_backup_id = None
        self._cluster_admin_password = None
        self._shape = None

    @property
    def node_host_name(self):
        """
        **[Required]** Gets the node_host_name of this ReplaceNodeDetails.
        Host name of the node to replace. MASTER, UTILITY and EDGE node are only supported types


        :return: The node_host_name of this ReplaceNodeDetails.
        :rtype: str
        """
        return self._node_host_name

    @node_host_name.setter
    def node_host_name(self, node_host_name):
        """
        Sets the node_host_name of this ReplaceNodeDetails.
        Host name of the node to replace. MASTER, UTILITY and EDGE node are only supported types


        :param node_host_name: The node_host_name of this ReplaceNodeDetails.
        :type: str
        """
        self._node_host_name = node_host_name

    @property
    def node_backup_id(self):
        """
        **[Required]** Gets the node_backup_id of this ReplaceNodeDetails.
        The id of the nodeBackup to use for replacing the node.


        :return: The node_backup_id of this ReplaceNodeDetails.
        :rtype: str
        """
        return self._node_backup_id

    @node_backup_id.setter
    def node_backup_id(self, node_backup_id):
        """
        Sets the node_backup_id of this ReplaceNodeDetails.
        The id of the nodeBackup to use for replacing the node.


        :param node_backup_id: The node_backup_id of this ReplaceNodeDetails.
        :type: str
        """
        self._node_backup_id = node_backup_id

    @property
    def cluster_admin_password(self):
        """
        **[Required]** Gets the cluster_admin_password of this ReplaceNodeDetails.
        Base-64 encoded password for the cluster admin user.


        :return: The cluster_admin_password of this ReplaceNodeDetails.
        :rtype: str
        """
        return self._cluster_admin_password

    @cluster_admin_password.setter
    def cluster_admin_password(self, cluster_admin_password):
        """
        Sets the cluster_admin_password of this ReplaceNodeDetails.
        Base-64 encoded password for the cluster admin user.


        :param cluster_admin_password: The cluster_admin_password of this ReplaceNodeDetails.
        :type: str
        """
        self._cluster_admin_password = cluster_admin_password

    @property
    def shape(self):
        """
        Gets the shape of this ReplaceNodeDetails.
        Shape of the new vm when replacing the node. If not provided, BDS will attempt to replace the node with the shape of current node.


        :return: The shape of this ReplaceNodeDetails.
        :rtype: str
        """
        return self._shape

    @shape.setter
    def shape(self, shape):
        """
        Sets the shape of this ReplaceNodeDetails.
        Shape of the new vm when replacing the node. If not provided, BDS will attempt to replace the node with the shape of current node.


        :param shape: The shape of this ReplaceNodeDetails.
        :type: str
        """
        self._shape = shape

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
