# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20190111


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class CostAlertSubscriptionSummary(object):
    """
    A CostAlertSubscription.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new CostAlertSubscriptionSummary object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param id:
            The value to assign to the id property of this CostAlertSubscriptionSummary.
        :type id: str

        :param compartment_id:
            The value to assign to the compartment_id property of this CostAlertSubscriptionSummary.
        :type compartment_id: str

        :param name:
            The value to assign to the name property of this CostAlertSubscriptionSummary.
        :type name: str

        :param channel_types:
            The value to assign to the channel_types property of this CostAlertSubscriptionSummary.
        :type channel_types: str

        :param time_created:
            The value to assign to the time_created property of this CostAlertSubscriptionSummary.
        :type time_created: datetime

        :param lifecycle_state:
            The value to assign to the lifecycle_state property of this CostAlertSubscriptionSummary.
        :type lifecycle_state: str

        :param defined_tags:
            The value to assign to the defined_tags property of this CostAlertSubscriptionSummary.
        :type defined_tags: dict(str, dict(str, object))

        :param freeform_tags:
            The value to assign to the freeform_tags property of this CostAlertSubscriptionSummary.
        :type freeform_tags: dict(str, str)

        :param system_tags:
            The value to assign to the system_tags property of this CostAlertSubscriptionSummary.
        :type system_tags: dict(str, dict(str, object))

        """
        self.swagger_types = {
            'id': 'str',
            'compartment_id': 'str',
            'name': 'str',
            'channel_types': 'str',
            'time_created': 'datetime',
            'lifecycle_state': 'str',
            'defined_tags': 'dict(str, dict(str, object))',
            'freeform_tags': 'dict(str, str)',
            'system_tags': 'dict(str, dict(str, object))'
        }
        self.attribute_map = {
            'id': 'id',
            'compartment_id': 'compartmentId',
            'name': 'name',
            'channel_types': 'channelTypes',
            'time_created': 'timeCreated',
            'lifecycle_state': 'lifecycleState',
            'defined_tags': 'definedTags',
            'freeform_tags': 'freeformTags',
            'system_tags': 'systemTags'
        }
        self._id = None
        self._compartment_id = None
        self._name = None
        self._channel_types = None
        self._time_created = None
        self._lifecycle_state = None
        self._defined_tags = None
        self._freeform_tags = None
        self._system_tags = None

    @property
    def id(self):
        """
        **[Required]** Gets the id of this CostAlertSubscriptionSummary.
        The OCID of the Cost Alert Subscription.


        :return: The id of this CostAlertSubscriptionSummary.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this CostAlertSubscriptionSummary.
        The OCID of the Cost Alert Subscription.


        :param id: The id of this CostAlertSubscriptionSummary.
        :type: str
        """
        self._id = id

    @property
    def compartment_id(self):
        """
        **[Required]** Gets the compartment_id of this CostAlertSubscriptionSummary.
        The OCID of the compartment which hold the cost alert subscription resource.


        :return: The compartment_id of this CostAlertSubscriptionSummary.
        :rtype: str
        """
        return self._compartment_id

    @compartment_id.setter
    def compartment_id(self, compartment_id):
        """
        Sets the compartment_id of this CostAlertSubscriptionSummary.
        The OCID of the compartment which hold the cost alert subscription resource.


        :param compartment_id: The compartment_id of this CostAlertSubscriptionSummary.
        :type: str
        """
        self._compartment_id = compartment_id

    @property
    def name(self):
        """
        **[Required]** Gets the name of this CostAlertSubscriptionSummary.
        The name of the cost alert subscription. Avoid entering confidential information.


        :return: The name of this CostAlertSubscriptionSummary.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this CostAlertSubscriptionSummary.
        The name of the cost alert subscription. Avoid entering confidential information.


        :param name: The name of this CostAlertSubscriptionSummary.
        :type: str
        """
        self._name = name

    @property
    def channel_types(self):
        """
        **[Required]** Gets the channel_types of this CostAlertSubscriptionSummary.
        The notification channels types string.


        :return: The channel_types of this CostAlertSubscriptionSummary.
        :rtype: str
        """
        return self._channel_types

    @channel_types.setter
    def channel_types(self, channel_types):
        """
        Sets the channel_types of this CostAlertSubscriptionSummary.
        The notification channels types string.


        :param channel_types: The channel_types of this CostAlertSubscriptionSummary.
        :type: str
        """
        self._channel_types = channel_types

    @property
    def time_created(self):
        """
        **[Required]** Gets the time_created of this CostAlertSubscriptionSummary.
        The time that the cost alert subscription was created.


        :return: The time_created of this CostAlertSubscriptionSummary.
        :rtype: datetime
        """
        return self._time_created

    @time_created.setter
    def time_created(self, time_created):
        """
        Sets the time_created of this CostAlertSubscriptionSummary.
        The time that the cost alert subscription was created.


        :param time_created: The time_created of this CostAlertSubscriptionSummary.
        :type: datetime
        """
        self._time_created = time_created

    @property
    def lifecycle_state(self):
        """
        **[Required]** Gets the lifecycle_state of this CostAlertSubscriptionSummary.
        The current state of the cost alert subscription.


        :return: The lifecycle_state of this CostAlertSubscriptionSummary.
        :rtype: str
        """
        return self._lifecycle_state

    @lifecycle_state.setter
    def lifecycle_state(self, lifecycle_state):
        """
        Sets the lifecycle_state of this CostAlertSubscriptionSummary.
        The current state of the cost alert subscription.


        :param lifecycle_state: The lifecycle_state of this CostAlertSubscriptionSummary.
        :type: str
        """
        self._lifecycle_state = lifecycle_state

    @property
    def defined_tags(self):
        """
        Gets the defined_tags of this CostAlertSubscriptionSummary.
        Defined tags for this resource. Each key is predefined and scoped to a
        namespace. For more information, see `Resource Tags`__.

        Example: `{\"Operations\": {\"CostCenter\": \"42\"}}`

        __ https://docs.cloud.oracle.com/Content/General/Concepts/resourcetags.htm


        :return: The defined_tags of this CostAlertSubscriptionSummary.
        :rtype: dict(str, dict(str, object))
        """
        return self._defined_tags

    @defined_tags.setter
    def defined_tags(self, defined_tags):
        """
        Sets the defined_tags of this CostAlertSubscriptionSummary.
        Defined tags for this resource. Each key is predefined and scoped to a
        namespace. For more information, see `Resource Tags`__.

        Example: `{\"Operations\": {\"CostCenter\": \"42\"}}`

        __ https://docs.cloud.oracle.com/Content/General/Concepts/resourcetags.htm


        :param defined_tags: The defined_tags of this CostAlertSubscriptionSummary.
        :type: dict(str, dict(str, object))
        """
        self._defined_tags = defined_tags

    @property
    def freeform_tags(self):
        """
        Gets the freeform_tags of this CostAlertSubscriptionSummary.
        Free-form tags for this resource. Each tag is a simple key-value pair with no
        predefined name, type, or namespace. For more information, see `Resource Tags`__.

        Example: `{\"Department\": \"Finance\"}`

        __ https://docs.cloud.oracle.com/Content/General/Concepts/resourcetags.htm


        :return: The freeform_tags of this CostAlertSubscriptionSummary.
        :rtype: dict(str, str)
        """
        return self._freeform_tags

    @freeform_tags.setter
    def freeform_tags(self, freeform_tags):
        """
        Sets the freeform_tags of this CostAlertSubscriptionSummary.
        Free-form tags for this resource. Each tag is a simple key-value pair with no
        predefined name, type, or namespace. For more information, see `Resource Tags`__.

        Example: `{\"Department\": \"Finance\"}`

        __ https://docs.cloud.oracle.com/Content/General/Concepts/resourcetags.htm


        :param freeform_tags: The freeform_tags of this CostAlertSubscriptionSummary.
        :type: dict(str, str)
        """
        self._freeform_tags = freeform_tags

    @property
    def system_tags(self):
        """
        Gets the system_tags of this CostAlertSubscriptionSummary.
        System tags for this resource. Each key is predefined and scoped to a namespace.
        For more information, see `Resource Tags`__.
        System tags can be viewed by users, but can only be created by the system.

        Example: `{\"orcl-cloud\": {\"free-tier-retained\": \"true\"}}`

        __ https://docs.cloud.oracle.com/Content/General/Concepts/resourcetags.htm


        :return: The system_tags of this CostAlertSubscriptionSummary.
        :rtype: dict(str, dict(str, object))
        """
        return self._system_tags

    @system_tags.setter
    def system_tags(self, system_tags):
        """
        Sets the system_tags of this CostAlertSubscriptionSummary.
        System tags for this resource. Each key is predefined and scoped to a namespace.
        For more information, see `Resource Tags`__.
        System tags can be viewed by users, but can only be created by the system.

        Example: `{\"orcl-cloud\": {\"free-tier-retained\": \"true\"}}`

        __ https://docs.cloud.oracle.com/Content/General/Concepts/resourcetags.htm


        :param system_tags: The system_tags of this CostAlertSubscriptionSummary.
        :type: dict(str, dict(str, object))
        """
        self._system_tags = system_tags

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
