# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20190111


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class RootCauseDetail(object):
    """
    The root cause details of the cost anomaly event.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new RootCauseDetail object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param value:
            The value to assign to the value property of this RootCauseDetail.
        :type value: object

        """
        self.swagger_types = {
            'value': 'object'
        }
        self.attribute_map = {
            'value': 'value'
        }
        self._value = None

    @property
    def value(self):
        """
        Gets the value of this RootCauseDetail.
        The json object representing the root cause details of the anomaly event.


        :return: The value of this RootCauseDetail.
        :rtype: object
        """
        return self._value

    @value.setter
    def value(self, value):
        """
        Sets the value of this RootCauseDetail.
        The json object representing the root cause details of the anomaly event.


        :param value: The value of this RootCauseDetail.
        :type: object
        """
        self._value = value

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
