# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20210224

from .certificate_authority_rule import CertificateAuthorityRule
from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class CertificateAuthorityIssuanceRule(CertificateAuthorityRule):
    """
    Issuance rules apply constraints to a certificate authority (CA) to enforce certain conditions regarding the resources it issues. For example, a path length constraint restricts how many subordinate CAs a CA can have. Or, a name constraint on certificate subject names specifies allowable namespaces for the hierarchical name forms in certificates that any CA in the certificate chain issues. You can't update the issuance rules configured for a CA after you create it.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new CertificateAuthorityIssuanceRule object with values from keyword arguments. The default value of the :py:attr:`~oci.certificates_management.models.CertificateAuthorityIssuanceRule.rule_type` attribute
        of this class is ``CERTIFICATE_AUTHORITY_ISSUANCE_RULE`` and it should not be changed.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param rule_type:
            The value to assign to the rule_type property of this CertificateAuthorityIssuanceRule.
            Allowed values for this property are: "CERTIFICATE_AUTHORITY_ISSUANCE_EXPIRY_RULE", "CERTIFICATE_AUTHORITY_ISSUANCE_RULE"
        :type rule_type: str

        :param path_length_constraint:
            The value to assign to the path_length_constraint property of this CertificateAuthorityIssuanceRule.
        :type path_length_constraint: int

        :param name_constraint:
            The value to assign to the name_constraint property of this CertificateAuthorityIssuanceRule.
        :type name_constraint: oci.certificates_management.models.NameConstraint

        """
        self.swagger_types = {
            'rule_type': 'str',
            'path_length_constraint': 'int',
            'name_constraint': 'NameConstraint'
        }
        self.attribute_map = {
            'rule_type': 'ruleType',
            'path_length_constraint': 'pathLengthConstraint',
            'name_constraint': 'nameConstraint'
        }
        self._rule_type = None
        self._path_length_constraint = None
        self._name_constraint = None
        self._rule_type = 'CERTIFICATE_AUTHORITY_ISSUANCE_RULE'

    @property
    def path_length_constraint(self):
        """
        Gets the path_length_constraint of this CertificateAuthorityIssuanceRule.
        The number of levels of descendants that this certificate authority (CA) can issue. When set to zero, the CA can issue only leaf certificates. There is no limit if the constraint isn't specified.


        :return: The path_length_constraint of this CertificateAuthorityIssuanceRule.
        :rtype: int
        """
        return self._path_length_constraint

    @path_length_constraint.setter
    def path_length_constraint(self, path_length_constraint):
        """
        Sets the path_length_constraint of this CertificateAuthorityIssuanceRule.
        The number of levels of descendants that this certificate authority (CA) can issue. When set to zero, the CA can issue only leaf certificates. There is no limit if the constraint isn't specified.


        :param path_length_constraint: The path_length_constraint of this CertificateAuthorityIssuanceRule.
        :type: int
        """
        self._path_length_constraint = path_length_constraint

    @property
    def name_constraint(self):
        """
        Gets the name_constraint of this CertificateAuthorityIssuanceRule.

        :return: The name_constraint of this CertificateAuthorityIssuanceRule.
        :rtype: oci.certificates_management.models.NameConstraint
        """
        return self._name_constraint

    @name_constraint.setter
    def name_constraint(self, name_constraint):
        """
        Sets the name_constraint of this CertificateAuthorityIssuanceRule.

        :param name_constraint: The name_constraint of this CertificateAuthorityIssuanceRule.
        :type: oci.certificates_management.models.NameConstraint
        """
        self._name_constraint = name_constraint

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
