# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20220509


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class AwsEc2AssetDetails(object):
    """
    AWS EC2 type of asset.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new AwsEc2AssetDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param compute:
            The value to assign to the compute property of this AwsEc2AssetDetails.
        :type compute: oci.cloud_bridge.models.ComputeProperties

        :param vm:
            The value to assign to the vm property of this AwsEc2AssetDetails.
        :type vm: oci.cloud_bridge.models.VmProperties

        :param aws_ec2:
            The value to assign to the aws_ec2 property of this AwsEc2AssetDetails.
        :type aws_ec2: oci.cloud_bridge.models.AwsEc2Properties

        :param aws_ec2_cost:
            The value to assign to the aws_ec2_cost property of this AwsEc2AssetDetails.
        :type aws_ec2_cost: oci.cloud_bridge.models.MonthlyCostSummary

        :param attached_ebs_volumes_cost:
            The value to assign to the attached_ebs_volumes_cost property of this AwsEc2AssetDetails.
        :type attached_ebs_volumes_cost: oci.cloud_bridge.models.MonthlyCostSummary

        """
        self.swagger_types = {
            'compute': 'ComputeProperties',
            'vm': 'VmProperties',
            'aws_ec2': 'AwsEc2Properties',
            'aws_ec2_cost': 'MonthlyCostSummary',
            'attached_ebs_volumes_cost': 'MonthlyCostSummary'
        }
        self.attribute_map = {
            'compute': 'compute',
            'vm': 'vm',
            'aws_ec2': 'awsEc2',
            'aws_ec2_cost': 'awsEc2Cost',
            'attached_ebs_volumes_cost': 'attachedEbsVolumesCost'
        }
        self._compute = None
        self._vm = None
        self._aws_ec2 = None
        self._aws_ec2_cost = None
        self._attached_ebs_volumes_cost = None

    @property
    def compute(self):
        """
        **[Required]** Gets the compute of this AwsEc2AssetDetails.

        :return: The compute of this AwsEc2AssetDetails.
        :rtype: oci.cloud_bridge.models.ComputeProperties
        """
        return self._compute

    @compute.setter
    def compute(self, compute):
        """
        Sets the compute of this AwsEc2AssetDetails.

        :param compute: The compute of this AwsEc2AssetDetails.
        :type: oci.cloud_bridge.models.ComputeProperties
        """
        self._compute = compute

    @property
    def vm(self):
        """
        **[Required]** Gets the vm of this AwsEc2AssetDetails.

        :return: The vm of this AwsEc2AssetDetails.
        :rtype: oci.cloud_bridge.models.VmProperties
        """
        return self._vm

    @vm.setter
    def vm(self, vm):
        """
        Sets the vm of this AwsEc2AssetDetails.

        :param vm: The vm of this AwsEc2AssetDetails.
        :type: oci.cloud_bridge.models.VmProperties
        """
        self._vm = vm

    @property
    def aws_ec2(self):
        """
        **[Required]** Gets the aws_ec2 of this AwsEc2AssetDetails.

        :return: The aws_ec2 of this AwsEc2AssetDetails.
        :rtype: oci.cloud_bridge.models.AwsEc2Properties
        """
        return self._aws_ec2

    @aws_ec2.setter
    def aws_ec2(self, aws_ec2):
        """
        Sets the aws_ec2 of this AwsEc2AssetDetails.

        :param aws_ec2: The aws_ec2 of this AwsEc2AssetDetails.
        :type: oci.cloud_bridge.models.AwsEc2Properties
        """
        self._aws_ec2 = aws_ec2

    @property
    def aws_ec2_cost(self):
        """
        Gets the aws_ec2_cost of this AwsEc2AssetDetails.

        :return: The aws_ec2_cost of this AwsEc2AssetDetails.
        :rtype: oci.cloud_bridge.models.MonthlyCostSummary
        """
        return self._aws_ec2_cost

    @aws_ec2_cost.setter
    def aws_ec2_cost(self, aws_ec2_cost):
        """
        Sets the aws_ec2_cost of this AwsEc2AssetDetails.

        :param aws_ec2_cost: The aws_ec2_cost of this AwsEc2AssetDetails.
        :type: oci.cloud_bridge.models.MonthlyCostSummary
        """
        self._aws_ec2_cost = aws_ec2_cost

    @property
    def attached_ebs_volumes_cost(self):
        """
        Gets the attached_ebs_volumes_cost of this AwsEc2AssetDetails.

        :return: The attached_ebs_volumes_cost of this AwsEc2AssetDetails.
        :rtype: oci.cloud_bridge.models.MonthlyCostSummary
        """
        return self._attached_ebs_volumes_cost

    @attached_ebs_volumes_cost.setter
    def attached_ebs_volumes_cost(self, attached_ebs_volumes_cost):
        """
        Sets the attached_ebs_volumes_cost of this AwsEc2AssetDetails.

        :param attached_ebs_volumes_cost: The attached_ebs_volumes_cost of this AwsEc2AssetDetails.
        :type: oci.cloud_bridge.models.MonthlyCostSummary
        """
        self._attached_ebs_volumes_cost = attached_ebs_volumes_cost

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
