# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20220509


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class GroupIdentifier(object):
    """
    Describes a security group.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new GroupIdentifier object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param group_key:
            The value to assign to the group_key property of this GroupIdentifier.
        :type group_key: str

        :param group_name:
            The value to assign to the group_name property of this GroupIdentifier.
        :type group_name: str

        """
        self.swagger_types = {
            'group_key': 'str',
            'group_name': 'str'
        }
        self.attribute_map = {
            'group_key': 'groupKey',
            'group_name': 'groupName'
        }
        self._group_key = None
        self._group_name = None

    @property
    def group_key(self):
        """
        Gets the group_key of this GroupIdentifier.
        The ID of the security group.


        :return: The group_key of this GroupIdentifier.
        :rtype: str
        """
        return self._group_key

    @group_key.setter
    def group_key(self, group_key):
        """
        Sets the group_key of this GroupIdentifier.
        The ID of the security group.


        :param group_key: The group_key of this GroupIdentifier.
        :type: str
        """
        self._group_key = group_key

    @property
    def group_name(self):
        """
        Gets the group_name of this GroupIdentifier.
        The name of the security group.


        :return: The group_name of this GroupIdentifier.
        :rtype: str
        """
        return self._group_name

    @group_name.setter
    def group_name(self, group_name):
        """
        Sets the group_name of this GroupIdentifier.
        The name of the security group.


        :param group_name: The group_name of this GroupIdentifier.
        :type: str
        """
        self._group_name = group_name

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
