# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20160918


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class BulkDeleteIpv6sDetails(object):
    """
    Bulk Secondary IPv6 addresses deletion object.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new BulkDeleteIpv6sDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param vnic_id:
            The value to assign to the vnic_id property of this BulkDeleteIpv6sDetails.
        :type vnic_id: str

        :param subnet_id:
            The value to assign to the subnet_id property of this BulkDeleteIpv6sDetails.
        :type subnet_id: str

        :param bulk_delete_ipv6s_item:
            The value to assign to the bulk_delete_ipv6s_item property of this BulkDeleteIpv6sDetails.
        :type bulk_delete_ipv6s_item: list[oci.core.models.BulkDeleteIpv6sItem]

        """
        self.swagger_types = {
            'vnic_id': 'str',
            'subnet_id': 'str',
            'bulk_delete_ipv6s_item': 'list[BulkDeleteIpv6sItem]'
        }
        self.attribute_map = {
            'vnic_id': 'vnicId',
            'subnet_id': 'subnetId',
            'bulk_delete_ipv6s_item': 'bulkDeleteIpv6sItem'
        }
        self._vnic_id = None
        self._subnet_id = None
        self._bulk_delete_ipv6s_item = None

    @property
    def vnic_id(self):
        """
        Gets the vnic_id of this BulkDeleteIpv6sDetails.
        The `OCID`__ of the VNIC to assign the IPv6s to. The
        IPv6 will be in the VNIC's subnet.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :return: The vnic_id of this BulkDeleteIpv6sDetails.
        :rtype: str
        """
        return self._vnic_id

    @vnic_id.setter
    def vnic_id(self, vnic_id):
        """
        Sets the vnic_id of this BulkDeleteIpv6sDetails.
        The `OCID`__ of the VNIC to assign the IPv6s to. The
        IPv6 will be in the VNIC's subnet.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :param vnic_id: The vnic_id of this BulkDeleteIpv6sDetails.
        :type: str
        """
        self._vnic_id = vnic_id

    @property
    def subnet_id(self):
        """
        Gets the subnet_id of this BulkDeleteIpv6sDetails.
        The `OCID`__ of the subnet from which the IPv6s addresses are to be deleted.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :return: The subnet_id of this BulkDeleteIpv6sDetails.
        :rtype: str
        """
        return self._subnet_id

    @subnet_id.setter
    def subnet_id(self, subnet_id):
        """
        Sets the subnet_id of this BulkDeleteIpv6sDetails.
        The `OCID`__ of the subnet from which the IPv6s addresses are to be deleted.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :param subnet_id: The subnet_id of this BulkDeleteIpv6sDetails.
        :type: str
        """
        self._subnet_id = subnet_id

    @property
    def bulk_delete_ipv6s_item(self):
        """
        **[Required]** Gets the bulk_delete_ipv6s_item of this BulkDeleteIpv6sDetails.
        IPv6 addresses to deleted.


        :return: The bulk_delete_ipv6s_item of this BulkDeleteIpv6sDetails.
        :rtype: list[oci.core.models.BulkDeleteIpv6sItem]
        """
        return self._bulk_delete_ipv6s_item

    @bulk_delete_ipv6s_item.setter
    def bulk_delete_ipv6s_item(self, bulk_delete_ipv6s_item):
        """
        Sets the bulk_delete_ipv6s_item of this BulkDeleteIpv6sDetails.
        IPv6 addresses to deleted.


        :param bulk_delete_ipv6s_item: The bulk_delete_ipv6s_item of this BulkDeleteIpv6sDetails.
        :type: list[oci.core.models.BulkDeleteIpv6sItem]
        """
        self._bulk_delete_ipv6s_item = bulk_delete_ipv6s_item

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
