# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20160918


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class BulkUpdateIpv6sItem(object):
    """
    Secondary IPv6 object to update as part of bulk update.
    """

    #: A constant which can be used with the lifetime property of a BulkUpdateIpv6sItem.
    #: This constant has a value of "EPHEMERAL"
    LIFETIME_EPHEMERAL = "EPHEMERAL"

    #: A constant which can be used with the lifetime property of a BulkUpdateIpv6sItem.
    #: This constant has a value of "RESERVED"
    LIFETIME_RESERVED = "RESERVED"

    def __init__(self, **kwargs):
        """
        Initializes a new BulkUpdateIpv6sItem object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param defined_tags:
            The value to assign to the defined_tags property of this BulkUpdateIpv6sItem.
        :type defined_tags: dict(str, dict(str, object))

        :param display_name:
            The value to assign to the display_name property of this BulkUpdateIpv6sItem.
        :type display_name: str

        :param freeform_tags:
            The value to assign to the freeform_tags property of this BulkUpdateIpv6sItem.
        :type freeform_tags: dict(str, str)

        :param ipv6_id:
            The value to assign to the ipv6_id property of this BulkUpdateIpv6sItem.
        :type ipv6_id: str

        :param lifetime:
            The value to assign to the lifetime property of this BulkUpdateIpv6sItem.
            Allowed values for this property are: "EPHEMERAL", "RESERVED"
        :type lifetime: str

        :param route_table_id:
            The value to assign to the route_table_id property of this BulkUpdateIpv6sItem.
        :type route_table_id: str

        """
        self.swagger_types = {
            'defined_tags': 'dict(str, dict(str, object))',
            'display_name': 'str',
            'freeform_tags': 'dict(str, str)',
            'ipv6_id': 'str',
            'lifetime': 'str',
            'route_table_id': 'str'
        }
        self.attribute_map = {
            'defined_tags': 'definedTags',
            'display_name': 'displayName',
            'freeform_tags': 'freeformTags',
            'ipv6_id': 'ipv6Id',
            'lifetime': 'lifetime',
            'route_table_id': 'routeTableId'
        }
        self._defined_tags = None
        self._display_name = None
        self._freeform_tags = None
        self._ipv6_id = None
        self._lifetime = None
        self._route_table_id = None

    @property
    def defined_tags(self):
        """
        Gets the defined_tags of this BulkUpdateIpv6sItem.
        Defined tags for this resource. Each key is predefined and scoped to a
        namespace. For more information, see `Resource Tags`__.

        Example: `{\"Operations\": {\"CostCenter\": \"42\"}}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :return: The defined_tags of this BulkUpdateIpv6sItem.
        :rtype: dict(str, dict(str, object))
        """
        return self._defined_tags

    @defined_tags.setter
    def defined_tags(self, defined_tags):
        """
        Sets the defined_tags of this BulkUpdateIpv6sItem.
        Defined tags for this resource. Each key is predefined and scoped to a
        namespace. For more information, see `Resource Tags`__.

        Example: `{\"Operations\": {\"CostCenter\": \"42\"}}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :param defined_tags: The defined_tags of this BulkUpdateIpv6sItem.
        :type: dict(str, dict(str, object))
        """
        self._defined_tags = defined_tags

    @property
    def display_name(self):
        """
        Gets the display_name of this BulkUpdateIpv6sItem.
        A user-friendly name. Does not have to be unique, and it's changeable.
        Avoid entering confidential information.


        :return: The display_name of this BulkUpdateIpv6sItem.
        :rtype: str
        """
        return self._display_name

    @display_name.setter
    def display_name(self, display_name):
        """
        Sets the display_name of this BulkUpdateIpv6sItem.
        A user-friendly name. Does not have to be unique, and it's changeable.
        Avoid entering confidential information.


        :param display_name: The display_name of this BulkUpdateIpv6sItem.
        :type: str
        """
        self._display_name = display_name

    @property
    def freeform_tags(self):
        """
        Gets the freeform_tags of this BulkUpdateIpv6sItem.
        Free-form tags for this resource. Each tag is a simple key-value pair with no
        predefined name, type, or namespace. For more information, see `Resource Tags`__.

        Example: `{\"Department\": \"Finance\"}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :return: The freeform_tags of this BulkUpdateIpv6sItem.
        :rtype: dict(str, str)
        """
        return self._freeform_tags

    @freeform_tags.setter
    def freeform_tags(self, freeform_tags):
        """
        Sets the freeform_tags of this BulkUpdateIpv6sItem.
        Free-form tags for this resource. Each tag is a simple key-value pair with no
        predefined name, type, or namespace. For more information, see `Resource Tags`__.

        Example: `{\"Department\": \"Finance\"}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :param freeform_tags: The freeform_tags of this BulkUpdateIpv6sItem.
        :type: dict(str, str)
        """
        self._freeform_tags = freeform_tags

    @property
    def ipv6_id(self):
        """
        **[Required]** Gets the ipv6_id of this BulkUpdateIpv6sItem.
        The OCID of the IPv6.


        :return: The ipv6_id of this BulkUpdateIpv6sItem.
        :rtype: str
        """
        return self._ipv6_id

    @ipv6_id.setter
    def ipv6_id(self, ipv6_id):
        """
        Sets the ipv6_id of this BulkUpdateIpv6sItem.
        The OCID of the IPv6.


        :param ipv6_id: The ipv6_id of this BulkUpdateIpv6sItem.
        :type: str
        """
        self._ipv6_id = ipv6_id

    @property
    def lifetime(self):
        """
        Gets the lifetime of this BulkUpdateIpv6sItem.
        Lifetime of the IP address.
        There are two types of IPs:
         - Ephemeral
         - Reserved

        Allowed values for this property are: "EPHEMERAL", "RESERVED"


        :return: The lifetime of this BulkUpdateIpv6sItem.
        :rtype: str
        """
        return self._lifetime

    @lifetime.setter
    def lifetime(self, lifetime):
        """
        Sets the lifetime of this BulkUpdateIpv6sItem.
        Lifetime of the IP address.
        There are two types of IPs:
         - Ephemeral
         - Reserved


        :param lifetime: The lifetime of this BulkUpdateIpv6sItem.
        :type: str
        """
        allowed_values = ["EPHEMERAL", "RESERVED"]
        if not value_allowed_none_or_none_sentinel(lifetime, allowed_values):
            raise ValueError(
                f"Invalid value for `lifetime`, must be None or one of {allowed_values}"
            )
        self._lifetime = lifetime

    @property
    def route_table_id(self):
        """
        Gets the route_table_id of this BulkUpdateIpv6sItem.
        The `OCID`__ of the route table the IP address or VNIC will use. For more information, see
        `Per-resource Routing`__.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm
        __ https://docs.oracle.com/iaas/Content/Network/Tasks/managingroutetables.htm#Overview_of_Routing_for_Your_VCN__source_routing


        :return: The route_table_id of this BulkUpdateIpv6sItem.
        :rtype: str
        """
        return self._route_table_id

    @route_table_id.setter
    def route_table_id(self, route_table_id):
        """
        Sets the route_table_id of this BulkUpdateIpv6sItem.
        The `OCID`__ of the route table the IP address or VNIC will use. For more information, see
        `Per-resource Routing`__.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm
        __ https://docs.oracle.com/iaas/Content/Network/Tasks/managingroutetables.htm#Overview_of_Routing_for_Your_VCN__source_routing


        :param route_table_id: The route_table_id of this BulkUpdateIpv6sItem.
        :type: str
        """
        self._route_table_id = route_table_id

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
