# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20160918


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class BulkUpdatePrivateIpsDetails(object):
    """
    Bulk Secondary IPv4 addresses update object.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new BulkUpdatePrivateIpsDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param vnic_id:
            The value to assign to the vnic_id property of this BulkUpdatePrivateIpsDetails.
        :type vnic_id: str

        :param bulk_update_private_ip_item:
            The value to assign to the bulk_update_private_ip_item property of this BulkUpdatePrivateIpsDetails.
        :type bulk_update_private_ip_item: list[oci.core.models.BulkUpdatePrivateIpItem]

        """
        self.swagger_types = {
            'vnic_id': 'str',
            'bulk_update_private_ip_item': 'list[BulkUpdatePrivateIpItem]'
        }
        self.attribute_map = {
            'vnic_id': 'vnicId',
            'bulk_update_private_ip_item': 'bulkUpdatePrivateIpItem'
        }
        self._vnic_id = None
        self._bulk_update_private_ip_item = None

    @property
    def vnic_id(self):
        """
        Gets the vnic_id of this BulkUpdatePrivateIpsDetails.
        The `OCID`__ of the VNIC to reassign
        the private IPs to. The VNIC and private IPs must be in the same subnet.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :return: The vnic_id of this BulkUpdatePrivateIpsDetails.
        :rtype: str
        """
        return self._vnic_id

    @vnic_id.setter
    def vnic_id(self, vnic_id):
        """
        Sets the vnic_id of this BulkUpdatePrivateIpsDetails.
        The `OCID`__ of the VNIC to reassign
        the private IPs to. The VNIC and private IPs must be in the same subnet.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :param vnic_id: The vnic_id of this BulkUpdatePrivateIpsDetails.
        :type: str
        """
        self._vnic_id = vnic_id

    @property
    def bulk_update_private_ip_item(self):
        """
        **[Required]** Gets the bulk_update_private_ip_item of this BulkUpdatePrivateIpsDetails.
        Secondary IPv4 addresses to updated.


        :return: The bulk_update_private_ip_item of this BulkUpdatePrivateIpsDetails.
        :rtype: list[oci.core.models.BulkUpdatePrivateIpItem]
        """
        return self._bulk_update_private_ip_item

    @bulk_update_private_ip_item.setter
    def bulk_update_private_ip_item(self, bulk_update_private_ip_item):
        """
        Sets the bulk_update_private_ip_item of this BulkUpdatePrivateIpsDetails.
        Secondary IPv4 addresses to updated.


        :param bulk_update_private_ip_item: The bulk_update_private_ip_item of this BulkUpdatePrivateIpsDetails.
        :type: list[oci.core.models.BulkUpdatePrivateIpItem]
        """
        self._bulk_update_private_ip_item = bulk_update_private_ip_item

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
