# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20160918

from .launch_attach_volume_details import LaunchAttachVolumeDetails
from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class LaunchAttachIScsiVolumeDetails(LaunchAttachVolumeDetails):
    """
    Details specific to ISCSI type volume attachments.
    """

    #: A constant which can be used with the encryption_in_transit_type property of a LaunchAttachIScsiVolumeDetails.
    #: This constant has a value of "NONE"
    ENCRYPTION_IN_TRANSIT_TYPE_NONE = "NONE"

    #: A constant which can be used with the encryption_in_transit_type property of a LaunchAttachIScsiVolumeDetails.
    #: This constant has a value of "BM_ENCRYPTION_IN_TRANSIT"
    ENCRYPTION_IN_TRANSIT_TYPE_BM_ENCRYPTION_IN_TRANSIT = "BM_ENCRYPTION_IN_TRANSIT"

    def __init__(self, **kwargs):
        """
        Initializes a new LaunchAttachIScsiVolumeDetails object with values from keyword arguments. The default value of the :py:attr:`~oci.core.models.LaunchAttachIScsiVolumeDetails.type` attribute
        of this class is ``iscsi`` and it should not be changed.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param device:
            The value to assign to the device property of this LaunchAttachIScsiVolumeDetails.
        :type device: str

        :param display_name:
            The value to assign to the display_name property of this LaunchAttachIScsiVolumeDetails.
        :type display_name: str

        :param is_read_only:
            The value to assign to the is_read_only property of this LaunchAttachIScsiVolumeDetails.
        :type is_read_only: bool

        :param is_shareable:
            The value to assign to the is_shareable property of this LaunchAttachIScsiVolumeDetails.
        :type is_shareable: bool

        :param type:
            The value to assign to the type property of this LaunchAttachIScsiVolumeDetails.
        :type type: str

        :param volume_id:
            The value to assign to the volume_id property of this LaunchAttachIScsiVolumeDetails.
        :type volume_id: str

        :param launch_create_volume_details:
            The value to assign to the launch_create_volume_details property of this LaunchAttachIScsiVolumeDetails.
        :type launch_create_volume_details: oci.core.models.LaunchCreateVolumeDetails

        :param use_chap:
            The value to assign to the use_chap property of this LaunchAttachIScsiVolumeDetails.
        :type use_chap: bool

        :param encryption_in_transit_type:
            The value to assign to the encryption_in_transit_type property of this LaunchAttachIScsiVolumeDetails.
            Allowed values for this property are: "NONE", "BM_ENCRYPTION_IN_TRANSIT"
        :type encryption_in_transit_type: str

        :param is_agent_auto_iscsi_login_enabled:
            The value to assign to the is_agent_auto_iscsi_login_enabled property of this LaunchAttachIScsiVolumeDetails.
        :type is_agent_auto_iscsi_login_enabled: bool

        """
        self.swagger_types = {
            'device': 'str',
            'display_name': 'str',
            'is_read_only': 'bool',
            'is_shareable': 'bool',
            'type': 'str',
            'volume_id': 'str',
            'launch_create_volume_details': 'LaunchCreateVolumeDetails',
            'use_chap': 'bool',
            'encryption_in_transit_type': 'str',
            'is_agent_auto_iscsi_login_enabled': 'bool'
        }
        self.attribute_map = {
            'device': 'device',
            'display_name': 'displayName',
            'is_read_only': 'isReadOnly',
            'is_shareable': 'isShareable',
            'type': 'type',
            'volume_id': 'volumeId',
            'launch_create_volume_details': 'launchCreateVolumeDetails',
            'use_chap': 'useChap',
            'encryption_in_transit_type': 'encryptionInTransitType',
            'is_agent_auto_iscsi_login_enabled': 'isAgentAutoIscsiLoginEnabled'
        }
        self._device = None
        self._display_name = None
        self._is_read_only = None
        self._is_shareable = None
        self._type = None
        self._volume_id = None
        self._launch_create_volume_details = None
        self._use_chap = None
        self._encryption_in_transit_type = None
        self._is_agent_auto_iscsi_login_enabled = None
        self._type = 'iscsi'

    @property
    def use_chap(self):
        """
        Gets the use_chap of this LaunchAttachIScsiVolumeDetails.
        Whether to use CHAP authentication for the volume attachment. Defaults to false.


        :return: The use_chap of this LaunchAttachIScsiVolumeDetails.
        :rtype: bool
        """
        return self._use_chap

    @use_chap.setter
    def use_chap(self, use_chap):
        """
        Sets the use_chap of this LaunchAttachIScsiVolumeDetails.
        Whether to use CHAP authentication for the volume attachment. Defaults to false.


        :param use_chap: The use_chap of this LaunchAttachIScsiVolumeDetails.
        :type: bool
        """
        self._use_chap = use_chap

    @property
    def encryption_in_transit_type(self):
        """
        Gets the encryption_in_transit_type of this LaunchAttachIScsiVolumeDetails.
        Refer the top-level definition of encryptionInTransitType.
        The default value is NONE.

        Allowed values for this property are: "NONE", "BM_ENCRYPTION_IN_TRANSIT"


        :return: The encryption_in_transit_type of this LaunchAttachIScsiVolumeDetails.
        :rtype: str
        """
        return self._encryption_in_transit_type

    @encryption_in_transit_type.setter
    def encryption_in_transit_type(self, encryption_in_transit_type):
        """
        Sets the encryption_in_transit_type of this LaunchAttachIScsiVolumeDetails.
        Refer the top-level definition of encryptionInTransitType.
        The default value is NONE.


        :param encryption_in_transit_type: The encryption_in_transit_type of this LaunchAttachIScsiVolumeDetails.
        :type: str
        """
        allowed_values = ["NONE", "BM_ENCRYPTION_IN_TRANSIT"]
        if not value_allowed_none_or_none_sentinel(encryption_in_transit_type, allowed_values):
            raise ValueError(
                f"Invalid value for `encryption_in_transit_type`, must be None or one of {allowed_values}"
            )
        self._encryption_in_transit_type = encryption_in_transit_type

    @property
    def is_agent_auto_iscsi_login_enabled(self):
        """
        Gets the is_agent_auto_iscsi_login_enabled of this LaunchAttachIScsiVolumeDetails.
        Whether to enable Oracle Cloud Agent to perform the iSCSI login and logout commands after the volume attach or detach operations for non multipath-enabled iSCSI attachments.


        :return: The is_agent_auto_iscsi_login_enabled of this LaunchAttachIScsiVolumeDetails.
        :rtype: bool
        """
        return self._is_agent_auto_iscsi_login_enabled

    @is_agent_auto_iscsi_login_enabled.setter
    def is_agent_auto_iscsi_login_enabled(self, is_agent_auto_iscsi_login_enabled):
        """
        Sets the is_agent_auto_iscsi_login_enabled of this LaunchAttachIScsiVolumeDetails.
        Whether to enable Oracle Cloud Agent to perform the iSCSI login and logout commands after the volume attach or detach operations for non multipath-enabled iSCSI attachments.


        :param is_agent_auto_iscsi_login_enabled: The is_agent_auto_iscsi_login_enabled of this LaunchAttachIScsiVolumeDetails.
        :type: bool
        """
        self._is_agent_auto_iscsi_login_enabled = is_agent_auto_iscsi_login_enabled

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
