# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20190325


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class CreateCatalogPrivateEndpointDetails(object):
    """
    Information about the new private endpoint resource
    """

    def __init__(self, **kwargs):
        """
        Initializes a new CreateCatalogPrivateEndpointDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param dns_zones:
            The value to assign to the dns_zones property of this CreateCatalogPrivateEndpointDetails.
        :type dns_zones: list[str]

        :param subnet_id:
            The value to assign to the subnet_id property of this CreateCatalogPrivateEndpointDetails.
        :type subnet_id: str

        :param compartment_id:
            The value to assign to the compartment_id property of this CreateCatalogPrivateEndpointDetails.
        :type compartment_id: str

        :param freeform_tags:
            The value to assign to the freeform_tags property of this CreateCatalogPrivateEndpointDetails.
        :type freeform_tags: dict(str, str)

        :param defined_tags:
            The value to assign to the defined_tags property of this CreateCatalogPrivateEndpointDetails.
        :type defined_tags: dict(str, dict(str, object))

        :param display_name:
            The value to assign to the display_name property of this CreateCatalogPrivateEndpointDetails.
        :type display_name: str

        :param security_attributes:
            The value to assign to the security_attributes property of this CreateCatalogPrivateEndpointDetails.
        :type security_attributes: dict(str, dict(str, object))

        """
        self.swagger_types = {
            'dns_zones': 'list[str]',
            'subnet_id': 'str',
            'compartment_id': 'str',
            'freeform_tags': 'dict(str, str)',
            'defined_tags': 'dict(str, dict(str, object))',
            'display_name': 'str',
            'security_attributes': 'dict(str, dict(str, object))'
        }
        self.attribute_map = {
            'dns_zones': 'dnsZones',
            'subnet_id': 'subnetId',
            'compartment_id': 'compartmentId',
            'freeform_tags': 'freeformTags',
            'defined_tags': 'definedTags',
            'display_name': 'displayName',
            'security_attributes': 'securityAttributes'
        }
        self._dns_zones = None
        self._subnet_id = None
        self._compartment_id = None
        self._freeform_tags = None
        self._defined_tags = None
        self._display_name = None
        self._security_attributes = None

    @property
    def dns_zones(self):
        """
        **[Required]** Gets the dns_zones of this CreateCatalogPrivateEndpointDetails.
        List of DNS zones to be used by the data assets to be harvested.
        Example: custpvtsubnet.oraclevcn.com for data asset: db.custpvtsubnet.oraclevcn.com


        :return: The dns_zones of this CreateCatalogPrivateEndpointDetails.
        :rtype: list[str]
        """
        return self._dns_zones

    @dns_zones.setter
    def dns_zones(self, dns_zones):
        """
        Sets the dns_zones of this CreateCatalogPrivateEndpointDetails.
        List of DNS zones to be used by the data assets to be harvested.
        Example: custpvtsubnet.oraclevcn.com for data asset: db.custpvtsubnet.oraclevcn.com


        :param dns_zones: The dns_zones of this CreateCatalogPrivateEndpointDetails.
        :type: list[str]
        """
        self._dns_zones = dns_zones

    @property
    def subnet_id(self):
        """
        **[Required]** Gets the subnet_id of this CreateCatalogPrivateEndpointDetails.
        The OCID of subnet to which the reverse connection is to be created


        :return: The subnet_id of this CreateCatalogPrivateEndpointDetails.
        :rtype: str
        """
        return self._subnet_id

    @subnet_id.setter
    def subnet_id(self, subnet_id):
        """
        Sets the subnet_id of this CreateCatalogPrivateEndpointDetails.
        The OCID of subnet to which the reverse connection is to be created


        :param subnet_id: The subnet_id of this CreateCatalogPrivateEndpointDetails.
        :type: str
        """
        self._subnet_id = subnet_id

    @property
    def compartment_id(self):
        """
        **[Required]** Gets the compartment_id of this CreateCatalogPrivateEndpointDetails.
        Compartment identifier.


        :return: The compartment_id of this CreateCatalogPrivateEndpointDetails.
        :rtype: str
        """
        return self._compartment_id

    @compartment_id.setter
    def compartment_id(self, compartment_id):
        """
        Sets the compartment_id of this CreateCatalogPrivateEndpointDetails.
        Compartment identifier.


        :param compartment_id: The compartment_id of this CreateCatalogPrivateEndpointDetails.
        :type: str
        """
        self._compartment_id = compartment_id

    @property
    def freeform_tags(self):
        """
        Gets the freeform_tags of this CreateCatalogPrivateEndpointDetails.
        Simple key-value pair that is applied without any predefined name, type, or scope. Exists for cross-compatibility only.
        Example: `{\"bar-key\": \"value\"}`


        :return: The freeform_tags of this CreateCatalogPrivateEndpointDetails.
        :rtype: dict(str, str)
        """
        return self._freeform_tags

    @freeform_tags.setter
    def freeform_tags(self, freeform_tags):
        """
        Sets the freeform_tags of this CreateCatalogPrivateEndpointDetails.
        Simple key-value pair that is applied without any predefined name, type, or scope. Exists for cross-compatibility only.
        Example: `{\"bar-key\": \"value\"}`


        :param freeform_tags: The freeform_tags of this CreateCatalogPrivateEndpointDetails.
        :type: dict(str, str)
        """
        self._freeform_tags = freeform_tags

    @property
    def defined_tags(self):
        """
        Gets the defined_tags of this CreateCatalogPrivateEndpointDetails.
        Usage of predefined tag keys. These predefined keys are scoped to namespaces.
        Example: `{\"foo-namespace\": {\"bar-key\": \"value\"}}`


        :return: The defined_tags of this CreateCatalogPrivateEndpointDetails.
        :rtype: dict(str, dict(str, object))
        """
        return self._defined_tags

    @defined_tags.setter
    def defined_tags(self, defined_tags):
        """
        Sets the defined_tags of this CreateCatalogPrivateEndpointDetails.
        Usage of predefined tag keys. These predefined keys are scoped to namespaces.
        Example: `{\"foo-namespace\": {\"bar-key\": \"value\"}}`


        :param defined_tags: The defined_tags of this CreateCatalogPrivateEndpointDetails.
        :type: dict(str, dict(str, object))
        """
        self._defined_tags = defined_tags

    @property
    def display_name(self):
        """
        Gets the display_name of this CreateCatalogPrivateEndpointDetails.
        Display name of the private endpoint resource being created.


        :return: The display_name of this CreateCatalogPrivateEndpointDetails.
        :rtype: str
        """
        return self._display_name

    @display_name.setter
    def display_name(self, display_name):
        """
        Sets the display_name of this CreateCatalogPrivateEndpointDetails.
        Display name of the private endpoint resource being created.


        :param display_name: The display_name of this CreateCatalogPrivateEndpointDetails.
        :type: str
        """
        self._display_name = display_name

    @property
    def security_attributes(self):
        """
        Gets the security_attributes of this CreateCatalogPrivateEndpointDetails.
        Security attributes for this resource. Each key is predefined and scoped to a namespace.
        For more information, see `Resource Tags`__.

        Example: `{\"Oracle-ZPR\": {\"MaxEgressCount\": {\"value\": \"42\", \"mode\": \"enforce\"}}}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :return: The security_attributes of this CreateCatalogPrivateEndpointDetails.
        :rtype: dict(str, dict(str, object))
        """
        return self._security_attributes

    @security_attributes.setter
    def security_attributes(self, security_attributes):
        """
        Sets the security_attributes of this CreateCatalogPrivateEndpointDetails.
        Security attributes for this resource. Each key is predefined and scoped to a namespace.
        For more information, see `Resource Tags`__.

        Example: `{\"Oracle-ZPR\": {\"MaxEgressCount\": {\"value\": \"42\", \"mode\": \"enforce\"}}}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :param security_attributes: The security_attributes of this CreateCatalogPrivateEndpointDetails.
        :type: dict(str, dict(str, object))
        """
        self._security_attributes = security_attributes

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
