# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20181201

from .policy_condition import PolicyCondition
from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class AttributeSetCondition(PolicyCondition):
    """
    The audit policy provisioning conditions.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new AttributeSetCondition object with values from keyword arguments. The default value of the :py:attr:`~oci.data_safe.models.AttributeSetCondition.entity_type` attribute
        of this class is ``ATTRIBUTE_SET`` and it should not be changed.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param entity_selection:
            The value to assign to the entity_selection property of this AttributeSetCondition.
            Allowed values for this property are: "INCLUDE", "EXCLUDE"
        :type entity_selection: str

        :param entity_type:
            The value to assign to the entity_type property of this AttributeSetCondition.
            Allowed values for this property are: "USER", "ROLE", "ALL_USERS", "ATTRIBUTE_SET"
        :type entity_type: str

        :param operation_status:
            The value to assign to the operation_status property of this AttributeSetCondition.
            Allowed values for this property are: "SUCCESS", "FAILURE", "BOTH"
        :type operation_status: str

        :param attribute_set_id:
            The value to assign to the attribute_set_id property of this AttributeSetCondition.
        :type attribute_set_id: str

        """
        self.swagger_types = {
            'entity_selection': 'str',
            'entity_type': 'str',
            'operation_status': 'str',
            'attribute_set_id': 'str'
        }
        self.attribute_map = {
            'entity_selection': 'entitySelection',
            'entity_type': 'entityType',
            'operation_status': 'operationStatus',
            'attribute_set_id': 'attributeSetId'
        }
        self._entity_selection = None
        self._entity_type = None
        self._operation_status = None
        self._attribute_set_id = None
        self._entity_type = 'ATTRIBUTE_SET'

    @property
    def attribute_set_id(self):
        """
        **[Required]** Gets the attribute_set_id of this AttributeSetCondition.
        The OCID of the attribute set.


        :return: The attribute_set_id of this AttributeSetCondition.
        :rtype: str
        """
        return self._attribute_set_id

    @attribute_set_id.setter
    def attribute_set_id(self, attribute_set_id):
        """
        Sets the attribute_set_id of this AttributeSetCondition.
        The OCID of the attribute set.


        :param attribute_set_id: The attribute_set_id of this AttributeSetCondition.
        :type: str
        """
        self._attribute_set_id = attribute_set_id

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
