# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20181201


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class CreateTargetDatabaseGroupDetails(object):
    """
    The details used to create the target database group.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new CreateTargetDatabaseGroupDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param compartment_id:
            The value to assign to the compartment_id property of this CreateTargetDatabaseGroupDetails.
        :type compartment_id: str

        :param display_name:
            The value to assign to the display_name property of this CreateTargetDatabaseGroupDetails.
        :type display_name: str

        :param description:
            The value to assign to the description property of this CreateTargetDatabaseGroupDetails.
        :type description: str

        :param matching_criteria:
            The value to assign to the matching_criteria property of this CreateTargetDatabaseGroupDetails.
        :type matching_criteria: oci.data_safe.models.MatchingCriteria

        :param freeform_tags:
            The value to assign to the freeform_tags property of this CreateTargetDatabaseGroupDetails.
        :type freeform_tags: dict(str, str)

        :param defined_tags:
            The value to assign to the defined_tags property of this CreateTargetDatabaseGroupDetails.
        :type defined_tags: dict(str, dict(str, object))

        """
        self.swagger_types = {
            'compartment_id': 'str',
            'display_name': 'str',
            'description': 'str',
            'matching_criteria': 'MatchingCriteria',
            'freeform_tags': 'dict(str, str)',
            'defined_tags': 'dict(str, dict(str, object))'
        }
        self.attribute_map = {
            'compartment_id': 'compartmentId',
            'display_name': 'displayName',
            'description': 'description',
            'matching_criteria': 'matchingCriteria',
            'freeform_tags': 'freeformTags',
            'defined_tags': 'definedTags'
        }
        self._compartment_id = None
        self._display_name = None
        self._description = None
        self._matching_criteria = None
        self._freeform_tags = None
        self._defined_tags = None

    @property
    def compartment_id(self):
        """
        **[Required]** Gets the compartment_id of this CreateTargetDatabaseGroupDetails.
        The OCID of the compartment to create the target database group.


        :return: The compartment_id of this CreateTargetDatabaseGroupDetails.
        :rtype: str
        """
        return self._compartment_id

    @compartment_id.setter
    def compartment_id(self, compartment_id):
        """
        Sets the compartment_id of this CreateTargetDatabaseGroupDetails.
        The OCID of the compartment to create the target database group.


        :param compartment_id: The compartment_id of this CreateTargetDatabaseGroupDetails.
        :type: str
        """
        self._compartment_id = compartment_id

    @property
    def display_name(self):
        """
        **[Required]** Gets the display_name of this CreateTargetDatabaseGroupDetails.
        The name of the target database group.


        :return: The display_name of this CreateTargetDatabaseGroupDetails.
        :rtype: str
        """
        return self._display_name

    @display_name.setter
    def display_name(self, display_name):
        """
        Sets the display_name of this CreateTargetDatabaseGroupDetails.
        The name of the target database group.


        :param display_name: The display_name of this CreateTargetDatabaseGroupDetails.
        :type: str
        """
        self._display_name = display_name

    @property
    def description(self):
        """
        Gets the description of this CreateTargetDatabaseGroupDetails.
        Description of the target database group (optional).


        :return: The description of this CreateTargetDatabaseGroupDetails.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """
        Sets the description of this CreateTargetDatabaseGroupDetails.
        Description of the target database group (optional).


        :param description: The description of this CreateTargetDatabaseGroupDetails.
        :type: str
        """
        self._description = description

    @property
    def matching_criteria(self):
        """
        **[Required]** Gets the matching_criteria of this CreateTargetDatabaseGroupDetails.

        :return: The matching_criteria of this CreateTargetDatabaseGroupDetails.
        :rtype: oci.data_safe.models.MatchingCriteria
        """
        return self._matching_criteria

    @matching_criteria.setter
    def matching_criteria(self, matching_criteria):
        """
        Sets the matching_criteria of this CreateTargetDatabaseGroupDetails.

        :param matching_criteria: The matching_criteria of this CreateTargetDatabaseGroupDetails.
        :type: oci.data_safe.models.MatchingCriteria
        """
        self._matching_criteria = matching_criteria

    @property
    def freeform_tags(self):
        """
        Gets the freeform_tags of this CreateTargetDatabaseGroupDetails.
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see `Resource Tags`__

        Example: `{\"Department\": \"Finance\"}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :return: The freeform_tags of this CreateTargetDatabaseGroupDetails.
        :rtype: dict(str, str)
        """
        return self._freeform_tags

    @freeform_tags.setter
    def freeform_tags(self, freeform_tags):
        """
        Sets the freeform_tags of this CreateTargetDatabaseGroupDetails.
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see `Resource Tags`__

        Example: `{\"Department\": \"Finance\"}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :param freeform_tags: The freeform_tags of this CreateTargetDatabaseGroupDetails.
        :type: dict(str, str)
        """
        self._freeform_tags = freeform_tags

    @property
    def defined_tags(self):
        """
        Gets the defined_tags of this CreateTargetDatabaseGroupDetails.
        Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see `Resource Tags`__
        Example: `{\"Operations\": {\"CostCenter\": \"42\"}}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :return: The defined_tags of this CreateTargetDatabaseGroupDetails.
        :rtype: dict(str, dict(str, object))
        """
        return self._defined_tags

    @defined_tags.setter
    def defined_tags(self, defined_tags):
        """
        Sets the defined_tags of this CreateTargetDatabaseGroupDetails.
        Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see `Resource Tags`__
        Example: `{\"Operations\": {\"CostCenter\": \"42\"}}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :param defined_tags: The defined_tags of this CreateTargetDatabaseGroupDetails.
        :type: dict(str, dict(str, object))
        """
        self._defined_tags = defined_tags

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
