# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20181201


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class SecurityPolicyConfig(object):
    """
    The Data Safe resource represents the common configurations corresponding to the associated security policy.
    """

    #: A constant which can be used with the lifecycle_state property of a SecurityPolicyConfig.
    #: This constant has a value of "CREATING"
    LIFECYCLE_STATE_CREATING = "CREATING"

    #: A constant which can be used with the lifecycle_state property of a SecurityPolicyConfig.
    #: This constant has a value of "UPDATING"
    LIFECYCLE_STATE_UPDATING = "UPDATING"

    #: A constant which can be used with the lifecycle_state property of a SecurityPolicyConfig.
    #: This constant has a value of "ACTIVE"
    LIFECYCLE_STATE_ACTIVE = "ACTIVE"

    #: A constant which can be used with the lifecycle_state property of a SecurityPolicyConfig.
    #: This constant has a value of "FAILED"
    LIFECYCLE_STATE_FAILED = "FAILED"

    #: A constant which can be used with the lifecycle_state property of a SecurityPolicyConfig.
    #: This constant has a value of "NEEDS_ATTENTION"
    LIFECYCLE_STATE_NEEDS_ATTENTION = "NEEDS_ATTENTION"

    #: A constant which can be used with the lifecycle_state property of a SecurityPolicyConfig.
    #: This constant has a value of "DELETING"
    LIFECYCLE_STATE_DELETING = "DELETING"

    #: A constant which can be used with the lifecycle_state property of a SecurityPolicyConfig.
    #: This constant has a value of "DELETED"
    LIFECYCLE_STATE_DELETED = "DELETED"

    def __init__(self, **kwargs):
        """
        Initializes a new SecurityPolicyConfig object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param id:
            The value to assign to the id property of this SecurityPolicyConfig.
        :type id: str

        :param compartment_id:
            The value to assign to the compartment_id property of this SecurityPolicyConfig.
        :type compartment_id: str

        :param display_name:
            The value to assign to the display_name property of this SecurityPolicyConfig.
        :type display_name: str

        :param description:
            The value to assign to the description property of this SecurityPolicyConfig.
        :type description: str

        :param security_policy_id:
            The value to assign to the security_policy_id property of this SecurityPolicyConfig.
        :type security_policy_id: str

        :param time_created:
            The value to assign to the time_created property of this SecurityPolicyConfig.
        :type time_created: datetime

        :param time_updated:
            The value to assign to the time_updated property of this SecurityPolicyConfig.
        :type time_updated: datetime

        :param lifecycle_state:
            The value to assign to the lifecycle_state property of this SecurityPolicyConfig.
            Allowed values for this property are: "CREATING", "UPDATING", "ACTIVE", "FAILED", "NEEDS_ATTENTION", "DELETING", "DELETED", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type lifecycle_state: str

        :param lifecycle_details:
            The value to assign to the lifecycle_details property of this SecurityPolicyConfig.
        :type lifecycle_details: str

        :param firewall_config:
            The value to assign to the firewall_config property of this SecurityPolicyConfig.
        :type firewall_config: oci.data_safe.models.FirewallConfig

        :param unified_audit_policy_config:
            The value to assign to the unified_audit_policy_config property of this SecurityPolicyConfig.
        :type unified_audit_policy_config: oci.data_safe.models.UnifiedAuditPolicyConfig

        :param freeform_tags:
            The value to assign to the freeform_tags property of this SecurityPolicyConfig.
        :type freeform_tags: dict(str, str)

        :param defined_tags:
            The value to assign to the defined_tags property of this SecurityPolicyConfig.
        :type defined_tags: dict(str, dict(str, object))

        :param system_tags:
            The value to assign to the system_tags property of this SecurityPolicyConfig.
        :type system_tags: dict(str, dict(str, object))

        """
        self.swagger_types = {
            'id': 'str',
            'compartment_id': 'str',
            'display_name': 'str',
            'description': 'str',
            'security_policy_id': 'str',
            'time_created': 'datetime',
            'time_updated': 'datetime',
            'lifecycle_state': 'str',
            'lifecycle_details': 'str',
            'firewall_config': 'FirewallConfig',
            'unified_audit_policy_config': 'UnifiedAuditPolicyConfig',
            'freeform_tags': 'dict(str, str)',
            'defined_tags': 'dict(str, dict(str, object))',
            'system_tags': 'dict(str, dict(str, object))'
        }
        self.attribute_map = {
            'id': 'id',
            'compartment_id': 'compartmentId',
            'display_name': 'displayName',
            'description': 'description',
            'security_policy_id': 'securityPolicyId',
            'time_created': 'timeCreated',
            'time_updated': 'timeUpdated',
            'lifecycle_state': 'lifecycleState',
            'lifecycle_details': 'lifecycleDetails',
            'firewall_config': 'firewallConfig',
            'unified_audit_policy_config': 'unifiedAuditPolicyConfig',
            'freeform_tags': 'freeformTags',
            'defined_tags': 'definedTags',
            'system_tags': 'systemTags'
        }
        self._id = None
        self._compartment_id = None
        self._display_name = None
        self._description = None
        self._security_policy_id = None
        self._time_created = None
        self._time_updated = None
        self._lifecycle_state = None
        self._lifecycle_details = None
        self._firewall_config = None
        self._unified_audit_policy_config = None
        self._freeform_tags = None
        self._defined_tags = None
        self._system_tags = None

    @property
    def id(self):
        """
        **[Required]** Gets the id of this SecurityPolicyConfig.
        The OCID of the security policy configuration.


        :return: The id of this SecurityPolicyConfig.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this SecurityPolicyConfig.
        The OCID of the security policy configuration.


        :param id: The id of this SecurityPolicyConfig.
        :type: str
        """
        self._id = id

    @property
    def compartment_id(self):
        """
        **[Required]** Gets the compartment_id of this SecurityPolicyConfig.
        The OCID of the compartment containing the security policy configuration.


        :return: The compartment_id of this SecurityPolicyConfig.
        :rtype: str
        """
        return self._compartment_id

    @compartment_id.setter
    def compartment_id(self, compartment_id):
        """
        Sets the compartment_id of this SecurityPolicyConfig.
        The OCID of the compartment containing the security policy configuration.


        :param compartment_id: The compartment_id of this SecurityPolicyConfig.
        :type: str
        """
        self._compartment_id = compartment_id

    @property
    def display_name(self):
        """
        **[Required]** Gets the display_name of this SecurityPolicyConfig.
        The display name of the security policy configuration.


        :return: The display_name of this SecurityPolicyConfig.
        :rtype: str
        """
        return self._display_name

    @display_name.setter
    def display_name(self, display_name):
        """
        Sets the display_name of this SecurityPolicyConfig.
        The display name of the security policy configuration.


        :param display_name: The display_name of this SecurityPolicyConfig.
        :type: str
        """
        self._display_name = display_name

    @property
    def description(self):
        """
        Gets the description of this SecurityPolicyConfig.
        The description of the security policy configuration.


        :return: The description of this SecurityPolicyConfig.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """
        Sets the description of this SecurityPolicyConfig.
        The description of the security policy configuration.


        :param description: The description of this SecurityPolicyConfig.
        :type: str
        """
        self._description = description

    @property
    def security_policy_id(self):
        """
        **[Required]** Gets the security_policy_id of this SecurityPolicyConfig.
        The OCID of the security policy corresponding to the security policy configuration.


        :return: The security_policy_id of this SecurityPolicyConfig.
        :rtype: str
        """
        return self._security_policy_id

    @security_policy_id.setter
    def security_policy_id(self, security_policy_id):
        """
        Sets the security_policy_id of this SecurityPolicyConfig.
        The OCID of the security policy corresponding to the security policy configuration.


        :param security_policy_id: The security_policy_id of this SecurityPolicyConfig.
        :type: str
        """
        self._security_policy_id = security_policy_id

    @property
    def time_created(self):
        """
        **[Required]** Gets the time_created of this SecurityPolicyConfig.
        The time the security policy configuration was created, in the format defined by RFC3339.


        :return: The time_created of this SecurityPolicyConfig.
        :rtype: datetime
        """
        return self._time_created

    @time_created.setter
    def time_created(self, time_created):
        """
        Sets the time_created of this SecurityPolicyConfig.
        The time the security policy configuration was created, in the format defined by RFC3339.


        :param time_created: The time_created of this SecurityPolicyConfig.
        :type: datetime
        """
        self._time_created = time_created

    @property
    def time_updated(self):
        """
        Gets the time_updated of this SecurityPolicyConfig.
        The date and time the security policy configuration was last updated, in the format defined by RFC3339.


        :return: The time_updated of this SecurityPolicyConfig.
        :rtype: datetime
        """
        return self._time_updated

    @time_updated.setter
    def time_updated(self, time_updated):
        """
        Sets the time_updated of this SecurityPolicyConfig.
        The date and time the security policy configuration was last updated, in the format defined by RFC3339.


        :param time_updated: The time_updated of this SecurityPolicyConfig.
        :type: datetime
        """
        self._time_updated = time_updated

    @property
    def lifecycle_state(self):
        """
        **[Required]** Gets the lifecycle_state of this SecurityPolicyConfig.
        The current state of the security policy configuration.

        Allowed values for this property are: "CREATING", "UPDATING", "ACTIVE", "FAILED", "NEEDS_ATTENTION", "DELETING", "DELETED", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The lifecycle_state of this SecurityPolicyConfig.
        :rtype: str
        """
        return self._lifecycle_state

    @lifecycle_state.setter
    def lifecycle_state(self, lifecycle_state):
        """
        Sets the lifecycle_state of this SecurityPolicyConfig.
        The current state of the security policy configuration.


        :param lifecycle_state: The lifecycle_state of this SecurityPolicyConfig.
        :type: str
        """
        allowed_values = ["CREATING", "UPDATING", "ACTIVE", "FAILED", "NEEDS_ATTENTION", "DELETING", "DELETED"]
        if not value_allowed_none_or_none_sentinel(lifecycle_state, allowed_values):
            lifecycle_state = 'UNKNOWN_ENUM_VALUE'
        self._lifecycle_state = lifecycle_state

    @property
    def lifecycle_details(self):
        """
        Gets the lifecycle_details of this SecurityPolicyConfig.
        Details about the current state of the security policy configuration.


        :return: The lifecycle_details of this SecurityPolicyConfig.
        :rtype: str
        """
        return self._lifecycle_details

    @lifecycle_details.setter
    def lifecycle_details(self, lifecycle_details):
        """
        Sets the lifecycle_details of this SecurityPolicyConfig.
        Details about the current state of the security policy configuration.


        :param lifecycle_details: The lifecycle_details of this SecurityPolicyConfig.
        :type: str
        """
        self._lifecycle_details = lifecycle_details

    @property
    def firewall_config(self):
        """
        Gets the firewall_config of this SecurityPolicyConfig.

        :return: The firewall_config of this SecurityPolicyConfig.
        :rtype: oci.data_safe.models.FirewallConfig
        """
        return self._firewall_config

    @firewall_config.setter
    def firewall_config(self, firewall_config):
        """
        Sets the firewall_config of this SecurityPolicyConfig.

        :param firewall_config: The firewall_config of this SecurityPolicyConfig.
        :type: oci.data_safe.models.FirewallConfig
        """
        self._firewall_config = firewall_config

    @property
    def unified_audit_policy_config(self):
        """
        Gets the unified_audit_policy_config of this SecurityPolicyConfig.

        :return: The unified_audit_policy_config of this SecurityPolicyConfig.
        :rtype: oci.data_safe.models.UnifiedAuditPolicyConfig
        """
        return self._unified_audit_policy_config

    @unified_audit_policy_config.setter
    def unified_audit_policy_config(self, unified_audit_policy_config):
        """
        Sets the unified_audit_policy_config of this SecurityPolicyConfig.

        :param unified_audit_policy_config: The unified_audit_policy_config of this SecurityPolicyConfig.
        :type: oci.data_safe.models.UnifiedAuditPolicyConfig
        """
        self._unified_audit_policy_config = unified_audit_policy_config

    @property
    def freeform_tags(self):
        """
        Gets the freeform_tags of this SecurityPolicyConfig.
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see `Resource Tags`__

        Example: `{\"Department\": \"Finance\"}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :return: The freeform_tags of this SecurityPolicyConfig.
        :rtype: dict(str, str)
        """
        return self._freeform_tags

    @freeform_tags.setter
    def freeform_tags(self, freeform_tags):
        """
        Sets the freeform_tags of this SecurityPolicyConfig.
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see `Resource Tags`__

        Example: `{\"Department\": \"Finance\"}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :param freeform_tags: The freeform_tags of this SecurityPolicyConfig.
        :type: dict(str, str)
        """
        self._freeform_tags = freeform_tags

    @property
    def defined_tags(self):
        """
        Gets the defined_tags of this SecurityPolicyConfig.
        Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see `Resource Tags`__
        Example: `{\"Operations\": {\"CostCenter\": \"42\"}}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :return: The defined_tags of this SecurityPolicyConfig.
        :rtype: dict(str, dict(str, object))
        """
        return self._defined_tags

    @defined_tags.setter
    def defined_tags(self, defined_tags):
        """
        Sets the defined_tags of this SecurityPolicyConfig.
        Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see `Resource Tags`__
        Example: `{\"Operations\": {\"CostCenter\": \"42\"}}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :param defined_tags: The defined_tags of this SecurityPolicyConfig.
        :type: dict(str, dict(str, object))
        """
        self._defined_tags = defined_tags

    @property
    def system_tags(self):
        """
        Gets the system_tags of this SecurityPolicyConfig.
        System tags for this resource. Each key is predefined and scoped to a namespace. For more information, see Resource Tags.
        Example: `{\"orcl-cloud\": {\"free-tier-retained\": \"true\"}}`


        :return: The system_tags of this SecurityPolicyConfig.
        :rtype: dict(str, dict(str, object))
        """
        return self._system_tags

    @system_tags.setter
    def system_tags(self, system_tags):
        """
        Sets the system_tags of this SecurityPolicyConfig.
        System tags for this resource. Each key is predefined and scoped to a namespace. For more information, see Resource Tags.
        Example: `{\"orcl-cloud\": {\"free-tier-retained\": \"true\"}}`


        :param system_tags: The system_tags of this SecurityPolicyConfig.
        :type: dict(str, dict(str, object))
        """
        self._system_tags = system_tags

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
