# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20181201


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class TemplateAnalyticsSummary(object):
    """
    The summary of template analytics data.
    """

    #: A constant which can be used with the metric_name property of a TemplateAnalyticsSummary.
    #: This constant has a value of "TEMPLATE_STATS"
    METRIC_NAME_TEMPLATE_STATS = "TEMPLATE_STATS"

    def __init__(self, **kwargs):
        """
        Initializes a new TemplateAnalyticsSummary object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param metric_name:
            The value to assign to the metric_name property of this TemplateAnalyticsSummary.
            Allowed values for this property are: "TEMPLATE_STATS", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type metric_name: str

        :param dimensions:
            The value to assign to the dimensions property of this TemplateAnalyticsSummary.
        :type dimensions: oci.data_safe.models.TemplateAnalyticsDimensions

        :param count:
            The value to assign to the count property of this TemplateAnalyticsSummary.
        :type count: int

        """
        self.swagger_types = {
            'metric_name': 'str',
            'dimensions': 'TemplateAnalyticsDimensions',
            'count': 'int'
        }
        self.attribute_map = {
            'metric_name': 'metricName',
            'dimensions': 'dimensions',
            'count': 'count'
        }
        self._metric_name = None
        self._dimensions = None
        self._count = None

    @property
    def metric_name(self):
        """
        **[Required]** Gets the metric_name of this TemplateAnalyticsSummary.
        The name of the aggregation metric.

        Allowed values for this property are: "TEMPLATE_STATS", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The metric_name of this TemplateAnalyticsSummary.
        :rtype: str
        """
        return self._metric_name

    @metric_name.setter
    def metric_name(self, metric_name):
        """
        Sets the metric_name of this TemplateAnalyticsSummary.
        The name of the aggregation metric.


        :param metric_name: The metric_name of this TemplateAnalyticsSummary.
        :type: str
        """
        allowed_values = ["TEMPLATE_STATS"]
        if not value_allowed_none_or_none_sentinel(metric_name, allowed_values):
            metric_name = 'UNKNOWN_ENUM_VALUE'
        self._metric_name = metric_name

    @property
    def dimensions(self):
        """
        Gets the dimensions of this TemplateAnalyticsSummary.

        :return: The dimensions of this TemplateAnalyticsSummary.
        :rtype: oci.data_safe.models.TemplateAnalyticsDimensions
        """
        return self._dimensions

    @dimensions.setter
    def dimensions(self, dimensions):
        """
        Sets the dimensions of this TemplateAnalyticsSummary.

        :param dimensions: The dimensions of this TemplateAnalyticsSummary.
        :type: oci.data_safe.models.TemplateAnalyticsDimensions
        """
        self._dimensions = dimensions

    @property
    def count(self):
        """
        **[Required]** Gets the count of this TemplateAnalyticsSummary.
        The total count for the aggregation metric.


        :return: The count of this TemplateAnalyticsSummary.
        :rtype: int
        """
        return self._count

    @count.setter
    def count(self, count):
        """
        Sets the count of this TemplateAnalyticsSummary.
        The total count for the aggregation metric.


        :param count: The count of this TemplateAnalyticsSummary.
        :type: int
        """
        self._count = count

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
