# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20190101


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class JobEnvironmentConfigurationDetails(object):
    """
    Environment configuration to capture job runtime dependencies.
    """

    #: A constant which can be used with the job_environment_type property of a JobEnvironmentConfigurationDetails.
    #: This constant has a value of "OCIR_CONTAINER"
    JOB_ENVIRONMENT_TYPE_OCIR_CONTAINER = "OCIR_CONTAINER"

    def __init__(self, **kwargs):
        """
        Initializes a new JobEnvironmentConfigurationDetails object with values from keyword arguments. This class has the following subclasses and if you are using this class as input
        to a service operations then you should favor using a subclass over the base class:

        * :class:`~oci.data_science.models.OcirContainerJobEnvironmentConfigurationDetails`

        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param job_environment_type:
            The value to assign to the job_environment_type property of this JobEnvironmentConfigurationDetails.
            Allowed values for this property are: "OCIR_CONTAINER", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type job_environment_type: str

        """
        self.swagger_types = {
            'job_environment_type': 'str'
        }
        self.attribute_map = {
            'job_environment_type': 'jobEnvironmentType'
        }
        self._job_environment_type = None

    @staticmethod
    def get_subtype(object_dictionary):
        """
        Given the hash representation of a subtype of this class,
        use the info in the hash to return the class of the subtype.
        """
        type = object_dictionary['jobEnvironmentType']

        if type == 'OCIR_CONTAINER':
            return 'OcirContainerJobEnvironmentConfigurationDetails'
        else:
            return 'JobEnvironmentConfigurationDetails'

    @property
    def job_environment_type(self):
        """
        **[Required]** Gets the job_environment_type of this JobEnvironmentConfigurationDetails.
        The environment configuration type used for job runtime.

        Allowed values for this property are: "OCIR_CONTAINER", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The job_environment_type of this JobEnvironmentConfigurationDetails.
        :rtype: str
        """
        return self._job_environment_type

    @job_environment_type.setter
    def job_environment_type(self, job_environment_type):
        """
        Sets the job_environment_type of this JobEnvironmentConfigurationDetails.
        The environment configuration type used for job runtime.


        :param job_environment_type: The job_environment_type of this JobEnvironmentConfigurationDetails.
        :type: str
        """
        allowed_values = ["OCIR_CONTAINER"]
        if not value_allowed_none_or_none_sentinel(job_environment_type, allowed_values):
            job_environment_type = 'UNKNOWN_ENUM_VALUE'
        self._job_environment_type = job_environment_type

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
