# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20190101


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class JobNodeGroupConfigurationDetails(object):
    """
    Details of Job Node Group Configuration
    """

    def __init__(self, **kwargs):
        """
        Initializes a new JobNodeGroupConfigurationDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param name:
            The value to assign to the name property of this JobNodeGroupConfigurationDetails.
        :type name: str

        :param replicas:
            The value to assign to the replicas property of this JobNodeGroupConfigurationDetails.
        :type replicas: int

        :param minimum_success_replicas:
            The value to assign to the minimum_success_replicas property of this JobNodeGroupConfigurationDetails.
        :type minimum_success_replicas: int

        :param job_infrastructure_configuration_details:
            The value to assign to the job_infrastructure_configuration_details property of this JobNodeGroupConfigurationDetails.
        :type job_infrastructure_configuration_details: oci.data_science.models.JobInfrastructureConfigurationDetails

        :param job_configuration_details:
            The value to assign to the job_configuration_details property of this JobNodeGroupConfigurationDetails.
        :type job_configuration_details: oci.data_science.models.JobConfigurationDetails

        :param job_environment_configuration_details:
            The value to assign to the job_environment_configuration_details property of this JobNodeGroupConfigurationDetails.
        :type job_environment_configuration_details: oci.data_science.models.JobEnvironmentConfigurationDetails

        """
        self.swagger_types = {
            'name': 'str',
            'replicas': 'int',
            'minimum_success_replicas': 'int',
            'job_infrastructure_configuration_details': 'JobInfrastructureConfigurationDetails',
            'job_configuration_details': 'JobConfigurationDetails',
            'job_environment_configuration_details': 'JobEnvironmentConfigurationDetails'
        }
        self.attribute_map = {
            'name': 'name',
            'replicas': 'replicas',
            'minimum_success_replicas': 'minimumSuccessReplicas',
            'job_infrastructure_configuration_details': 'jobInfrastructureConfigurationDetails',
            'job_configuration_details': 'jobConfigurationDetails',
            'job_environment_configuration_details': 'jobEnvironmentConfigurationDetails'
        }
        self._name = None
        self._replicas = None
        self._minimum_success_replicas = None
        self._job_infrastructure_configuration_details = None
        self._job_configuration_details = None
        self._job_environment_configuration_details = None

    @property
    def name(self):
        """
        **[Required]** Gets the name of this JobNodeGroupConfigurationDetails.
        node group name.


        :return: The name of this JobNodeGroupConfigurationDetails.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this JobNodeGroupConfigurationDetails.
        node group name.


        :param name: The name of this JobNodeGroupConfigurationDetails.
        :type: str
        """
        self._name = name

    @property
    def replicas(self):
        """
        Gets the replicas of this JobNodeGroupConfigurationDetails.
        The number of nodes.


        :return: The replicas of this JobNodeGroupConfigurationDetails.
        :rtype: int
        """
        return self._replicas

    @replicas.setter
    def replicas(self, replicas):
        """
        Sets the replicas of this JobNodeGroupConfigurationDetails.
        The number of nodes.


        :param replicas: The replicas of this JobNodeGroupConfigurationDetails.
        :type: int
        """
        self._replicas = replicas

    @property
    def minimum_success_replicas(self):
        """
        Gets the minimum_success_replicas of this JobNodeGroupConfigurationDetails.
        The minimum threshold of successful replicas for node group to be successful. All replicas need to succeed if this is not specified.


        :return: The minimum_success_replicas of this JobNodeGroupConfigurationDetails.
        :rtype: int
        """
        return self._minimum_success_replicas

    @minimum_success_replicas.setter
    def minimum_success_replicas(self, minimum_success_replicas):
        """
        Sets the minimum_success_replicas of this JobNodeGroupConfigurationDetails.
        The minimum threshold of successful replicas for node group to be successful. All replicas need to succeed if this is not specified.


        :param minimum_success_replicas: The minimum_success_replicas of this JobNodeGroupConfigurationDetails.
        :type: int
        """
        self._minimum_success_replicas = minimum_success_replicas

    @property
    def job_infrastructure_configuration_details(self):
        """
        Gets the job_infrastructure_configuration_details of this JobNodeGroupConfigurationDetails.

        :return: The job_infrastructure_configuration_details of this JobNodeGroupConfigurationDetails.
        :rtype: oci.data_science.models.JobInfrastructureConfigurationDetails
        """
        return self._job_infrastructure_configuration_details

    @job_infrastructure_configuration_details.setter
    def job_infrastructure_configuration_details(self, job_infrastructure_configuration_details):
        """
        Sets the job_infrastructure_configuration_details of this JobNodeGroupConfigurationDetails.

        :param job_infrastructure_configuration_details: The job_infrastructure_configuration_details of this JobNodeGroupConfigurationDetails.
        :type: oci.data_science.models.JobInfrastructureConfigurationDetails
        """
        self._job_infrastructure_configuration_details = job_infrastructure_configuration_details

    @property
    def job_configuration_details(self):
        """
        Gets the job_configuration_details of this JobNodeGroupConfigurationDetails.

        :return: The job_configuration_details of this JobNodeGroupConfigurationDetails.
        :rtype: oci.data_science.models.JobConfigurationDetails
        """
        return self._job_configuration_details

    @job_configuration_details.setter
    def job_configuration_details(self, job_configuration_details):
        """
        Sets the job_configuration_details of this JobNodeGroupConfigurationDetails.

        :param job_configuration_details: The job_configuration_details of this JobNodeGroupConfigurationDetails.
        :type: oci.data_science.models.JobConfigurationDetails
        """
        self._job_configuration_details = job_configuration_details

    @property
    def job_environment_configuration_details(self):
        """
        Gets the job_environment_configuration_details of this JobNodeGroupConfigurationDetails.

        :return: The job_environment_configuration_details of this JobNodeGroupConfigurationDetails.
        :rtype: oci.data_science.models.JobEnvironmentConfigurationDetails
        """
        return self._job_environment_configuration_details

    @job_environment_configuration_details.setter
    def job_environment_configuration_details(self, job_environment_configuration_details):
        """
        Sets the job_environment_configuration_details of this JobNodeGroupConfigurationDetails.

        :param job_environment_configuration_details: The job_environment_configuration_details of this JobNodeGroupConfigurationDetails.
        :type: oci.data_science.models.JobEnvironmentConfigurationDetails
        """
        self._job_environment_configuration_details = job_environment_configuration_details

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
