# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20190101


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class ModelArtifactReferenceDetails(object):
    """
    Reference to the location where the model artifact is stored.
    """

    #: A constant which can be used with the model_artifact_reference_type property of a ModelArtifactReferenceDetails.
    #: This constant has a value of "OSS"
    MODEL_ARTIFACT_REFERENCE_TYPE_OSS = "OSS"

    def __init__(self, **kwargs):
        """
        Initializes a new ModelArtifactReferenceDetails object with values from keyword arguments. This class has the following subclasses and if you are using this class as input
        to a service operations then you should favor using a subclass over the base class:

        * :class:`~oci.data_science.models.OSSModelArtifactReferenceDetails`

        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param model_artifact_reference_type:
            The value to assign to the model_artifact_reference_type property of this ModelArtifactReferenceDetails.
            Allowed values for this property are: "OSS"
        :type model_artifact_reference_type: str

        """
        self.swagger_types = {
            'model_artifact_reference_type': 'str'
        }
        self.attribute_map = {
            'model_artifact_reference_type': 'modelArtifactReferenceType'
        }
        self._model_artifact_reference_type = None

    @staticmethod
    def get_subtype(object_dictionary):
        """
        Given the hash representation of a subtype of this class,
        use the info in the hash to return the class of the subtype.
        """
        type = object_dictionary['modelArtifactReferenceType']

        if type == 'OSS':
            return 'OSSModelArtifactReferenceDetails'
        else:
            return 'ModelArtifactReferenceDetails'

    @property
    def model_artifact_reference_type(self):
        """
        **[Required]** Gets the model_artifact_reference_type of this ModelArtifactReferenceDetails.
        The type of the model artifact reference.

        Allowed values for this property are: "OSS"


        :return: The model_artifact_reference_type of this ModelArtifactReferenceDetails.
        :rtype: str
        """
        return self._model_artifact_reference_type

    @model_artifact_reference_type.setter
    def model_artifact_reference_type(self, model_artifact_reference_type):
        """
        Sets the model_artifact_reference_type of this ModelArtifactReferenceDetails.
        The type of the model artifact reference.


        :param model_artifact_reference_type: The model_artifact_reference_type of this ModelArtifactReferenceDetails.
        :type: str
        """
        allowed_values = ["OSS"]
        if not value_allowed_none_or_none_sentinel(model_artifact_reference_type, allowed_values):
            raise ValueError(
                f"Invalid value for `model_artifact_reference_type`, must be None or one of {allowed_values}"
            )
        self._model_artifact_reference_type = model_artifact_reference_type

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
