# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20190101

from .workload_configuration_details import WorkloadConfigurationDetails
from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class ModelDeployWorkloadConfigurationDetails(WorkloadConfigurationDetails):
    """
    The model deployment workload configuration.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new ModelDeployWorkloadConfigurationDetails object with values from keyword arguments. The default value of the :py:attr:`~oci.data_science.models.ModelDeployWorkloadConfigurationDetails.workload_type` attribute
        of this class is ``MODEL_DEPLOYMENT`` and it should not be changed.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param workload_type:
            The value to assign to the workload_type property of this ModelDeployWorkloadConfigurationDetails.
            Allowed values for this property are: "MODEL_DEPLOYMENT", "JOB_RUN"
        :type workload_type: str

        :param cmd:
            The value to assign to the cmd property of this ModelDeployWorkloadConfigurationDetails.
        :type cmd: str

        :param server_port:
            The value to assign to the server_port property of this ModelDeployWorkloadConfigurationDetails.
        :type server_port: int

        :param health_check_port:
            The value to assign to the health_check_port property of this ModelDeployWorkloadConfigurationDetails.
        :type health_check_port: int

        :param additional_configurations:
            The value to assign to the additional_configurations property of this ModelDeployWorkloadConfigurationDetails.
        :type additional_configurations: dict(str, str)

        """
        self.swagger_types = {
            'workload_type': 'str',
            'cmd': 'str',
            'server_port': 'int',
            'health_check_port': 'int',
            'additional_configurations': 'dict(str, str)'
        }
        self.attribute_map = {
            'workload_type': 'workloadType',
            'cmd': 'cmd',
            'server_port': 'serverPort',
            'health_check_port': 'healthCheckPort',
            'additional_configurations': 'additionalConfigurations'
        }
        self._workload_type = None
        self._cmd = None
        self._server_port = None
        self._health_check_port = None
        self._additional_configurations = None
        self._workload_type = 'MODEL_DEPLOYMENT'

    @property
    def cmd(self):
        """
        **[Required]** Gets the cmd of this ModelDeployWorkloadConfigurationDetails.
        The container image run `CMD`__ as a list of strings.
        Use `CMD` as arguments to the `ENTRYPOINT` or the only command to run in the absence of an `ENTRYPOINT`.
        The combined size of `CMD` and `ENTRYPOINT` must be less than 2048 bytes.

        __ https://docs.docker.com/engine/reference/builder/#cmd


        :return: The cmd of this ModelDeployWorkloadConfigurationDetails.
        :rtype: str
        """
        return self._cmd

    @cmd.setter
    def cmd(self, cmd):
        """
        Sets the cmd of this ModelDeployWorkloadConfigurationDetails.
        The container image run `CMD`__ as a list of strings.
        Use `CMD` as arguments to the `ENTRYPOINT` or the only command to run in the absence of an `ENTRYPOINT`.
        The combined size of `CMD` and `ENTRYPOINT` must be less than 2048 bytes.

        __ https://docs.docker.com/engine/reference/builder/#cmd


        :param cmd: The cmd of this ModelDeployWorkloadConfigurationDetails.
        :type: str
        """
        self._cmd = cmd

    @property
    def server_port(self):
        """
        **[Required]** Gets the server_port of this ModelDeployWorkloadConfigurationDetails.
        The port on which the web server serving the inference is running.
        The port can be anything between `1024` and `65535`. The following ports cannot be used `24224`, `8446`, `8447`.


        :return: The server_port of this ModelDeployWorkloadConfigurationDetails.
        :rtype: int
        """
        return self._server_port

    @server_port.setter
    def server_port(self, server_port):
        """
        Sets the server_port of this ModelDeployWorkloadConfigurationDetails.
        The port on which the web server serving the inference is running.
        The port can be anything between `1024` and `65535`. The following ports cannot be used `24224`, `8446`, `8447`.


        :param server_port: The server_port of this ModelDeployWorkloadConfigurationDetails.
        :type: int
        """
        self._server_port = server_port

    @property
    def health_check_port(self):
        """
        **[Required]** Gets the health_check_port of this ModelDeployWorkloadConfigurationDetails.
        The port on which the container `HEALTHCHECK`__ would listen.
        The port can be anything between `1024` and `65535`. The following ports cannot be used `24224`, `8446`, `8447`.

        __ https://docs.docker.com/engine/reference/builder/#healthcheck


        :return: The health_check_port of this ModelDeployWorkloadConfigurationDetails.
        :rtype: int
        """
        return self._health_check_port

    @health_check_port.setter
    def health_check_port(self, health_check_port):
        """
        Sets the health_check_port of this ModelDeployWorkloadConfigurationDetails.
        The port on which the container `HEALTHCHECK`__ would listen.
        The port can be anything between `1024` and `65535`. The following ports cannot be used `24224`, `8446`, `8447`.

        __ https://docs.docker.com/engine/reference/builder/#healthcheck


        :param health_check_port: The health_check_port of this ModelDeployWorkloadConfigurationDetails.
        :type: int
        """
        self._health_check_port = health_check_port

    @property
    def additional_configurations(self):
        """
        Gets the additional_configurations of this ModelDeployWorkloadConfigurationDetails.
        The additional configurations


        :return: The additional_configurations of this ModelDeployWorkloadConfigurationDetails.
        :rtype: dict(str, str)
        """
        return self._additional_configurations

    @additional_configurations.setter
    def additional_configurations(self, additional_configurations):
        """
        Sets the additional_configurations of this ModelDeployWorkloadConfigurationDetails.
        The additional configurations


        :param additional_configurations: The additional_configurations of this ModelDeployWorkloadConfigurationDetails.
        :type: dict(str, str)
        """
        self._additional_configurations = additional_configurations

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
