# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20190101

from .job_node_configuration_details import JobNodeConfigurationDetails
from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class MultiNodeJobNodeConfigurationDetails(JobNodeConfigurationDetails):
    """
    MultiNodeJobNodeConfigurationDetails
    """

    #: A constant which can be used with the startup_order property of a MultiNodeJobNodeConfigurationDetails.
    #: This constant has a value of "IN_ORDER"
    STARTUP_ORDER_IN_ORDER = "IN_ORDER"

    #: A constant which can be used with the startup_order property of a MultiNodeJobNodeConfigurationDetails.
    #: This constant has a value of "IN_PARALLEL"
    STARTUP_ORDER_IN_PARALLEL = "IN_PARALLEL"

    def __init__(self, **kwargs):
        """
        Initializes a new MultiNodeJobNodeConfigurationDetails object with values from keyword arguments. The default value of the :py:attr:`~oci.data_science.models.MultiNodeJobNodeConfigurationDetails.job_node_type` attribute
        of this class is ``MULTI_NODE`` and it should not be changed.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param job_node_type:
            The value to assign to the job_node_type property of this MultiNodeJobNodeConfigurationDetails.
            Allowed values for this property are: "MULTI_NODE", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type job_node_type: str

        :param startup_order:
            The value to assign to the startup_order property of this MultiNodeJobNodeConfigurationDetails.
            Allowed values for this property are: "IN_ORDER", "IN_PARALLEL", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type startup_order: str

        :param maximum_runtime_in_minutes:
            The value to assign to the maximum_runtime_in_minutes property of this MultiNodeJobNodeConfigurationDetails.
        :type maximum_runtime_in_minutes: int

        :param job_network_configuration:
            The value to assign to the job_network_configuration property of this MultiNodeJobNodeConfigurationDetails.
        :type job_network_configuration: oci.data_science.models.JobNetworkConfiguration

        :param job_node_group_configuration_details_list:
            The value to assign to the job_node_group_configuration_details_list property of this MultiNodeJobNodeConfigurationDetails.
        :type job_node_group_configuration_details_list: list[oci.data_science.models.JobNodeGroupConfigurationDetails]

        """
        self.swagger_types = {
            'job_node_type': 'str',
            'startup_order': 'str',
            'maximum_runtime_in_minutes': 'int',
            'job_network_configuration': 'JobNetworkConfiguration',
            'job_node_group_configuration_details_list': 'list[JobNodeGroupConfigurationDetails]'
        }
        self.attribute_map = {
            'job_node_type': 'jobNodeType',
            'startup_order': 'startupOrder',
            'maximum_runtime_in_minutes': 'maximumRuntimeInMinutes',
            'job_network_configuration': 'jobNetworkConfiguration',
            'job_node_group_configuration_details_list': 'jobNodeGroupConfigurationDetailsList'
        }
        self._job_node_type = None
        self._startup_order = None
        self._maximum_runtime_in_minutes = None
        self._job_network_configuration = None
        self._job_node_group_configuration_details_list = None
        self._job_node_type = 'MULTI_NODE'

    @property
    def startup_order(self):
        """
        Gets the startup_order of this MultiNodeJobNodeConfigurationDetails.
        The execution order of node groups

        Allowed values for this property are: "IN_ORDER", "IN_PARALLEL", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The startup_order of this MultiNodeJobNodeConfigurationDetails.
        :rtype: str
        """
        return self._startup_order

    @startup_order.setter
    def startup_order(self, startup_order):
        """
        Sets the startup_order of this MultiNodeJobNodeConfigurationDetails.
        The execution order of node groups


        :param startup_order: The startup_order of this MultiNodeJobNodeConfigurationDetails.
        :type: str
        """
        allowed_values = ["IN_ORDER", "IN_PARALLEL"]
        if not value_allowed_none_or_none_sentinel(startup_order, allowed_values):
            startup_order = 'UNKNOWN_ENUM_VALUE'
        self._startup_order = startup_order

    @property
    def maximum_runtime_in_minutes(self):
        """
        Gets the maximum_runtime_in_minutes of this MultiNodeJobNodeConfigurationDetails.
        A time bound for the execution of the job run. Timer starts when the job run is in progress.


        :return: The maximum_runtime_in_minutes of this MultiNodeJobNodeConfigurationDetails.
        :rtype: int
        """
        return self._maximum_runtime_in_minutes

    @maximum_runtime_in_minutes.setter
    def maximum_runtime_in_minutes(self, maximum_runtime_in_minutes):
        """
        Sets the maximum_runtime_in_minutes of this MultiNodeJobNodeConfigurationDetails.
        A time bound for the execution of the job run. Timer starts when the job run is in progress.


        :param maximum_runtime_in_minutes: The maximum_runtime_in_minutes of this MultiNodeJobNodeConfigurationDetails.
        :type: int
        """
        self._maximum_runtime_in_minutes = maximum_runtime_in_minutes

    @property
    def job_network_configuration(self):
        """
        Gets the job_network_configuration of this MultiNodeJobNodeConfigurationDetails.

        :return: The job_network_configuration of this MultiNodeJobNodeConfigurationDetails.
        :rtype: oci.data_science.models.JobNetworkConfiguration
        """
        return self._job_network_configuration

    @job_network_configuration.setter
    def job_network_configuration(self, job_network_configuration):
        """
        Sets the job_network_configuration of this MultiNodeJobNodeConfigurationDetails.

        :param job_network_configuration: The job_network_configuration of this MultiNodeJobNodeConfigurationDetails.
        :type: oci.data_science.models.JobNetworkConfiguration
        """
        self._job_network_configuration = job_network_configuration

    @property
    def job_node_group_configuration_details_list(self):
        """
        Gets the job_node_group_configuration_details_list of this MultiNodeJobNodeConfigurationDetails.
        List of JobNodeGroupConfigurationDetails


        :return: The job_node_group_configuration_details_list of this MultiNodeJobNodeConfigurationDetails.
        :rtype: list[oci.data_science.models.JobNodeGroupConfigurationDetails]
        """
        return self._job_node_group_configuration_details_list

    @job_node_group_configuration_details_list.setter
    def job_node_group_configuration_details_list(self, job_node_group_configuration_details_list):
        """
        Sets the job_node_group_configuration_details_list of this MultiNodeJobNodeConfigurationDetails.
        List of JobNodeGroupConfigurationDetails


        :param job_node_group_configuration_details_list: The job_node_group_configuration_details_list of this MultiNodeJobNodeConfigurationDetails.
        :type: list[oci.data_science.models.JobNodeGroupConfigurationDetails]
        """
        self._job_node_group_configuration_details_list = job_node_group_configuration_details_list

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
