# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20190101

from .instance_component import InstanceComponent
from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class ObjectStorageObjectInstanceComponent(InstanceComponent):
    """
    Reference to Object Storage Object
    """

    def __init__(self, **kwargs):
        """
        Initializes a new ObjectStorageObjectInstanceComponent object with values from keyword arguments. The default value of the :py:attr:`~oci.data_science.models.ObjectStorageObjectInstanceComponent.type` attribute
        of this class is ``OBJECT_STORAGE_OBJECT`` and it should not be changed.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param type:
            The value to assign to the type property of this ObjectStorageObjectInstanceComponent.
            Allowed values for this property are: "DATA_SCIENCE_MODEL_DEPLOYMENT", "OBJECT_STORAGE_BUCKET", "OBJECT_STORAGE_OBJECT", "ML_APPLICATION_INSTANCE_INTERNAL_TRIGGER", "DATA_SCIENCE_SCHEDULE", "GENERIC_OCI_RESOURCE"
        :type type: str

        :param name:
            The value to assign to the name property of this ObjectStorageObjectInstanceComponent.
        :type name: str

        :param component_name:
            The value to assign to the component_name property of this ObjectStorageObjectInstanceComponent.
        :type component_name: str

        :param object_id:
            The value to assign to the object_id property of this ObjectStorageObjectInstanceComponent.
        :type object_id: str

        :param namespace:
            The value to assign to the namespace property of this ObjectStorageObjectInstanceComponent.
        :type namespace: str

        :param bucket_name:
            The value to assign to the bucket_name property of this ObjectStorageObjectInstanceComponent.
        :type bucket_name: str

        """
        self.swagger_types = {
            'type': 'str',
            'name': 'str',
            'component_name': 'str',
            'object_id': 'str',
            'namespace': 'str',
            'bucket_name': 'str'
        }
        self.attribute_map = {
            'type': 'type',
            'name': 'name',
            'component_name': 'componentName',
            'object_id': 'objectId',
            'namespace': 'namespace',
            'bucket_name': 'bucketName'
        }
        self._type = None
        self._name = None
        self._component_name = None
        self._object_id = None
        self._namespace = None
        self._bucket_name = None
        self._type = 'OBJECT_STORAGE_OBJECT'

    @property
    def object_id(self):
        """
        **[Required]** Gets the object_id of this ObjectStorageObjectInstanceComponent.
        OCID of Object Storage Object


        :return: The object_id of this ObjectStorageObjectInstanceComponent.
        :rtype: str
        """
        return self._object_id

    @object_id.setter
    def object_id(self, object_id):
        """
        Sets the object_id of this ObjectStorageObjectInstanceComponent.
        OCID of Object Storage Object


        :param object_id: The object_id of this ObjectStorageObjectInstanceComponent.
        :type: str
        """
        self._object_id = object_id

    @property
    def namespace(self):
        """
        **[Required]** Gets the namespace of this ObjectStorageObjectInstanceComponent.
        Object Storage namespace


        :return: The namespace of this ObjectStorageObjectInstanceComponent.
        :rtype: str
        """
        return self._namespace

    @namespace.setter
    def namespace(self, namespace):
        """
        Sets the namespace of this ObjectStorageObjectInstanceComponent.
        Object Storage namespace


        :param namespace: The namespace of this ObjectStorageObjectInstanceComponent.
        :type: str
        """
        self._namespace = namespace

    @property
    def bucket_name(self):
        """
        **[Required]** Gets the bucket_name of this ObjectStorageObjectInstanceComponent.
        Name of object storage bucket


        :return: The bucket_name of this ObjectStorageObjectInstanceComponent.
        :rtype: str
        """
        return self._bucket_name

    @bucket_name.setter
    def bucket_name(self, bucket_name):
        """
        Sets the bucket_name of this ObjectStorageObjectInstanceComponent.
        Name of object storage bucket


        :param bucket_name: The bucket_name of this ObjectStorageObjectInstanceComponent.
        :type: str
        """
        self._bucket_name = bucket_name

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
