# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20190101


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class WorkloadConfigurationDetails(object):
    """
    The workload configuration details
    """

    #: A constant which can be used with the workload_type property of a WorkloadConfigurationDetails.
    #: This constant has a value of "MODEL_DEPLOYMENT"
    WORKLOAD_TYPE_MODEL_DEPLOYMENT = "MODEL_DEPLOYMENT"

    #: A constant which can be used with the workload_type property of a WorkloadConfigurationDetails.
    #: This constant has a value of "JOB_RUN"
    WORKLOAD_TYPE_JOB_RUN = "JOB_RUN"

    def __init__(self, **kwargs):
        """
        Initializes a new WorkloadConfigurationDetails object with values from keyword arguments. This class has the following subclasses and if you are using this class as input
        to a service operations then you should favor using a subclass over the base class:

        * :class:`~oci.data_science.models.ModelDeployWorkloadConfigurationDetails`
        * :class:`~oci.data_science.models.JobRunWorkloadConfigurationDetails`

        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param workload_type:
            The value to assign to the workload_type property of this WorkloadConfigurationDetails.
            Allowed values for this property are: "MODEL_DEPLOYMENT", "JOB_RUN", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type workload_type: str

        """
        self.swagger_types = {
            'workload_type': 'str'
        }
        self.attribute_map = {
            'workload_type': 'workloadType'
        }
        self._workload_type = None

    @staticmethod
    def get_subtype(object_dictionary):
        """
        Given the hash representation of a subtype of this class,
        use the info in the hash to return the class of the subtype.
        """
        type = object_dictionary['workloadType']

        if type == 'MODEL_DEPLOYMENT':
            return 'ModelDeployWorkloadConfigurationDetails'

        if type == 'JOB_RUN':
            return 'JobRunWorkloadConfigurationDetails'
        else:
            return 'WorkloadConfigurationDetails'

    @property
    def workload_type(self):
        """
        **[Required]** Gets the workload_type of this WorkloadConfigurationDetails.
        The workload use case.

        Allowed values for this property are: "MODEL_DEPLOYMENT", "JOB_RUN", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The workload_type of this WorkloadConfigurationDetails.
        :rtype: str
        """
        return self._workload_type

    @workload_type.setter
    def workload_type(self, workload_type):
        """
        Sets the workload_type of this WorkloadConfigurationDetails.
        The workload use case.


        :param workload_type: The workload_type of this WorkloadConfigurationDetails.
        :type: str
        """
        allowed_values = ["MODEL_DEPLOYMENT", "JOB_RUN"]
        if not value_allowed_none_or_none_sentinel(workload_type, allowed_values):
            workload_type = 'UNKNOWN_ENUM_VALUE'
        self._workload_type = workload_type

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
