# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20160918


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class AdvancedClusterFileSystem(object):
    """
    Details of an advanced cluster file system.
    """

    #: A constant which can be used with the lifecycle_state property of a AdvancedClusterFileSystem.
    #: This constant has a value of "AVAILABLE"
    LIFECYCLE_STATE_AVAILABLE = "AVAILABLE"

    #: A constant which can be used with the lifecycle_state property of a AdvancedClusterFileSystem.
    #: This constant has a value of "CREATING"
    LIFECYCLE_STATE_CREATING = "CREATING"

    #: A constant which can be used with the lifecycle_state property of a AdvancedClusterFileSystem.
    #: This constant has a value of "FAILED"
    LIFECYCLE_STATE_FAILED = "FAILED"

    #: A constant which can be used with the lifecycle_state property of a AdvancedClusterFileSystem.
    #: This constant has a value of "UPDATING"
    LIFECYCLE_STATE_UPDATING = "UPDATING"

    #: A constant which can be used with the lifecycle_state property of a AdvancedClusterFileSystem.
    #: This constant has a value of "DELETED"
    LIFECYCLE_STATE_DELETED = "DELETED"

    #: A constant which can be used with the lifecycle_state property of a AdvancedClusterFileSystem.
    #: This constant has a value of "DELETING"
    LIFECYCLE_STATE_DELETING = "DELETING"

    def __init__(self, **kwargs):
        """
        Initializes a new AdvancedClusterFileSystem object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param id:
            The value to assign to the id property of this AdvancedClusterFileSystem.
        :type id: str

        :param name:
            The value to assign to the name property of this AdvancedClusterFileSystem.
        :type name: str

        :param compartment_id:
            The value to assign to the compartment_id property of this AdvancedClusterFileSystem.
        :type compartment_id: str

        :param vm_cluster_id:
            The value to assign to the vm_cluster_id property of this AdvancedClusterFileSystem.
        :type vm_cluster_id: str

        :param vault_id:
            The value to assign to the vault_id property of this AdvancedClusterFileSystem.
        :type vault_id: str

        :param description:
            The value to assign to the description property of this AdvancedClusterFileSystem.
        :type description: str

        :param lifecycle_state:
            The value to assign to the lifecycle_state property of this AdvancedClusterFileSystem.
            Allowed values for this property are: "AVAILABLE", "CREATING", "FAILED", "UPDATING", "DELETED", "DELETING", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type lifecycle_state: str

        :param lifecycle_details:
            The value to assign to the lifecycle_details property of this AdvancedClusterFileSystem.
        :type lifecycle_details: str

        :param storage_in_gbs:
            The value to assign to the storage_in_gbs property of this AdvancedClusterFileSystem.
        :type storage_in_gbs: int

        :param mount_point:
            The value to assign to the mount_point property of this AdvancedClusterFileSystem.
        :type mount_point: str

        :param is_mounted:
            The value to assign to the is_mounted property of this AdvancedClusterFileSystem.
        :type is_mounted: bool

        :param time_created:
            The value to assign to the time_created property of this AdvancedClusterFileSystem.
        :type time_created: datetime

        :param time_updated:
            The value to assign to the time_updated property of this AdvancedClusterFileSystem.
        :type time_updated: datetime

        :param freeform_tags:
            The value to assign to the freeform_tags property of this AdvancedClusterFileSystem.
        :type freeform_tags: dict(str, str)

        :param defined_tags:
            The value to assign to the defined_tags property of this AdvancedClusterFileSystem.
        :type defined_tags: dict(str, dict(str, object))

        :param system_tags:
            The value to assign to the system_tags property of this AdvancedClusterFileSystem.
        :type system_tags: dict(str, dict(str, object))

        """
        self.swagger_types = {
            'id': 'str',
            'name': 'str',
            'compartment_id': 'str',
            'vm_cluster_id': 'str',
            'vault_id': 'str',
            'description': 'str',
            'lifecycle_state': 'str',
            'lifecycle_details': 'str',
            'storage_in_gbs': 'int',
            'mount_point': 'str',
            'is_mounted': 'bool',
            'time_created': 'datetime',
            'time_updated': 'datetime',
            'freeform_tags': 'dict(str, str)',
            'defined_tags': 'dict(str, dict(str, object))',
            'system_tags': 'dict(str, dict(str, object))'
        }
        self.attribute_map = {
            'id': 'id',
            'name': 'name',
            'compartment_id': 'compartmentId',
            'vm_cluster_id': 'vmClusterId',
            'vault_id': 'vaultId',
            'description': 'description',
            'lifecycle_state': 'lifecycleState',
            'lifecycle_details': 'lifecycleDetails',
            'storage_in_gbs': 'storageInGBs',
            'mount_point': 'mountPoint',
            'is_mounted': 'isMounted',
            'time_created': 'timeCreated',
            'time_updated': 'timeUpdated',
            'freeform_tags': 'freeformTags',
            'defined_tags': 'definedTags',
            'system_tags': 'systemTags'
        }
        self._id = None
        self._name = None
        self._compartment_id = None
        self._vm_cluster_id = None
        self._vault_id = None
        self._description = None
        self._lifecycle_state = None
        self._lifecycle_details = None
        self._storage_in_gbs = None
        self._mount_point = None
        self._is_mounted = None
        self._time_created = None
        self._time_updated = None
        self._freeform_tags = None
        self._defined_tags = None
        self._system_tags = None

    @property
    def id(self):
        """
        **[Required]** Gets the id of this AdvancedClusterFileSystem.
        The `OCID`__ of the advanced cluster file system.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :return: The id of this AdvancedClusterFileSystem.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this AdvancedClusterFileSystem.
        The `OCID`__ of the advanced cluster file system.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :param id: The id of this AdvancedClusterFileSystem.
        :type: str
        """
        self._id = id

    @property
    def name(self):
        """
        **[Required]** Gets the name of this AdvancedClusterFileSystem.
        The user-friendly name for the Advanced cluster file system. The file system name is unique for a cluster.


        :return: The name of this AdvancedClusterFileSystem.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this AdvancedClusterFileSystem.
        The user-friendly name for the Advanced cluster file system. The file system name is unique for a cluster.


        :param name: The name of this AdvancedClusterFileSystem.
        :type: str
        """
        self._name = name

    @property
    def compartment_id(self):
        """
        **[Required]** Gets the compartment_id of this AdvancedClusterFileSystem.
        The `OCID`__ of the compartment.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :return: The compartment_id of this AdvancedClusterFileSystem.
        :rtype: str
        """
        return self._compartment_id

    @compartment_id.setter
    def compartment_id(self, compartment_id):
        """
        Sets the compartment_id of this AdvancedClusterFileSystem.
        The `OCID`__ of the compartment.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :param compartment_id: The compartment_id of this AdvancedClusterFileSystem.
        :type: str
        """
        self._compartment_id = compartment_id

    @property
    def vm_cluster_id(self):
        """
        **[Required]** Gets the vm_cluster_id of this AdvancedClusterFileSystem.
        The `OCID`__ of the VM cluster.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :return: The vm_cluster_id of this AdvancedClusterFileSystem.
        :rtype: str
        """
        return self._vm_cluster_id

    @vm_cluster_id.setter
    def vm_cluster_id(self, vm_cluster_id):
        """
        Sets the vm_cluster_id of this AdvancedClusterFileSystem.
        The `OCID`__ of the VM cluster.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :param vm_cluster_id: The vm_cluster_id of this AdvancedClusterFileSystem.
        :type: str
        """
        self._vm_cluster_id = vm_cluster_id

    @property
    def vault_id(self):
        """
        Gets the vault_id of this AdvancedClusterFileSystem.
        The `OCID`__ of the Oracle Cloud Infrastructure `vault`__. This parameter and `secretId` are required for Customer Managed Keys.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm
        __ https://docs.cloud.oracle.com/Content/KeyManagement/Concepts/keyoverview.htm#concepts


        :return: The vault_id of this AdvancedClusterFileSystem.
        :rtype: str
        """
        return self._vault_id

    @vault_id.setter
    def vault_id(self, vault_id):
        """
        Sets the vault_id of this AdvancedClusterFileSystem.
        The `OCID`__ of the Oracle Cloud Infrastructure `vault`__. This parameter and `secretId` are required for Customer Managed Keys.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm
        __ https://docs.cloud.oracle.com/Content/KeyManagement/Concepts/keyoverview.htm#concepts


        :param vault_id: The vault_id of this AdvancedClusterFileSystem.
        :type: str
        """
        self._vault_id = vault_id

    @property
    def description(self):
        """
        Gets the description of this AdvancedClusterFileSystem.
        Description of the advanced cluster file system.


        :return: The description of this AdvancedClusterFileSystem.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """
        Sets the description of this AdvancedClusterFileSystem.
        Description of the advanced cluster file system.


        :param description: The description of this AdvancedClusterFileSystem.
        :type: str
        """
        self._description = description

    @property
    def lifecycle_state(self):
        """
        **[Required]** Gets the lifecycle_state of this AdvancedClusterFileSystem.
        The current state of the advanced cluster file system. Valid states are CREATING, AVAILABLE, UPDATING, FAILED, DELETED.

        Allowed values for this property are: "AVAILABLE", "CREATING", "FAILED", "UPDATING", "DELETED", "DELETING", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The lifecycle_state of this AdvancedClusterFileSystem.
        :rtype: str
        """
        return self._lifecycle_state

    @lifecycle_state.setter
    def lifecycle_state(self, lifecycle_state):
        """
        Sets the lifecycle_state of this AdvancedClusterFileSystem.
        The current state of the advanced cluster file system. Valid states are CREATING, AVAILABLE, UPDATING, FAILED, DELETED.


        :param lifecycle_state: The lifecycle_state of this AdvancedClusterFileSystem.
        :type: str
        """
        allowed_values = ["AVAILABLE", "CREATING", "FAILED", "UPDATING", "DELETED", "DELETING"]
        if not value_allowed_none_or_none_sentinel(lifecycle_state, allowed_values):
            lifecycle_state = 'UNKNOWN_ENUM_VALUE'
        self._lifecycle_state = lifecycle_state

    @property
    def lifecycle_details(self):
        """
        Gets the lifecycle_details of this AdvancedClusterFileSystem.
        Additional information about the current lifecycle state.


        :return: The lifecycle_details of this AdvancedClusterFileSystem.
        :rtype: str
        """
        return self._lifecycle_details

    @lifecycle_details.setter
    def lifecycle_details(self, lifecycle_details):
        """
        Sets the lifecycle_details of this AdvancedClusterFileSystem.
        Additional information about the current lifecycle state.


        :param lifecycle_details: The lifecycle_details of this AdvancedClusterFileSystem.
        :type: str
        """
        self._lifecycle_details = lifecycle_details

    @property
    def storage_in_gbs(self):
        """
        **[Required]** Gets the storage_in_gbs of this AdvancedClusterFileSystem.
        The total storage allocated for advanced cluster file system in GBs.


        :return: The storage_in_gbs of this AdvancedClusterFileSystem.
        :rtype: int
        """
        return self._storage_in_gbs

    @storage_in_gbs.setter
    def storage_in_gbs(self, storage_in_gbs):
        """
        Sets the storage_in_gbs of this AdvancedClusterFileSystem.
        The total storage allocated for advanced cluster file system in GBs.


        :param storage_in_gbs: The storage_in_gbs of this AdvancedClusterFileSystem.
        :type: int
        """
        self._storage_in_gbs = storage_in_gbs

    @property
    def mount_point(self):
        """
        **[Required]** Gets the mount_point of this AdvancedClusterFileSystem.
        The mount point of file system.


        :return: The mount_point of this AdvancedClusterFileSystem.
        :rtype: str
        """
        return self._mount_point

    @mount_point.setter
    def mount_point(self, mount_point):
        """
        Sets the mount_point of this AdvancedClusterFileSystem.
        The mount point of file system.


        :param mount_point: The mount_point of this AdvancedClusterFileSystem.
        :type: str
        """
        self._mount_point = mount_point

    @property
    def is_mounted(self):
        """
        **[Required]** Gets the is_mounted of this AdvancedClusterFileSystem.
        True if the file system is mounted on all VMs within VM Cluster.


        :return: The is_mounted of this AdvancedClusterFileSystem.
        :rtype: bool
        """
        return self._is_mounted

    @is_mounted.setter
    def is_mounted(self, is_mounted):
        """
        Sets the is_mounted of this AdvancedClusterFileSystem.
        True if the file system is mounted on all VMs within VM Cluster.


        :param is_mounted: The is_mounted of this AdvancedClusterFileSystem.
        :type: bool
        """
        self._is_mounted = is_mounted

    @property
    def time_created(self):
        """
        Gets the time_created of this AdvancedClusterFileSystem.
        The date and time the advanced cluster file system was created.


        :return: The time_created of this AdvancedClusterFileSystem.
        :rtype: datetime
        """
        return self._time_created

    @time_created.setter
    def time_created(self, time_created):
        """
        Sets the time_created of this AdvancedClusterFileSystem.
        The date and time the advanced cluster file system was created.


        :param time_created: The time_created of this AdvancedClusterFileSystem.
        :type: datetime
        """
        self._time_created = time_created

    @property
    def time_updated(self):
        """
        Gets the time_updated of this AdvancedClusterFileSystem.
        The last date and time that the advanced cluster file system was updated.


        :return: The time_updated of this AdvancedClusterFileSystem.
        :rtype: datetime
        """
        return self._time_updated

    @time_updated.setter
    def time_updated(self, time_updated):
        """
        Sets the time_updated of this AdvancedClusterFileSystem.
        The last date and time that the advanced cluster file system was updated.


        :param time_updated: The time_updated of this AdvancedClusterFileSystem.
        :type: datetime
        """
        self._time_updated = time_updated

    @property
    def freeform_tags(self):
        """
        Gets the freeform_tags of this AdvancedClusterFileSystem.
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace.
        For more information, see `Resource Tags`__.

        Example: `{\"Department\": \"Finance\"}`

        __ https://docs.cloud.oracle.com/Content/General/Concepts/resourcetags.htm


        :return: The freeform_tags of this AdvancedClusterFileSystem.
        :rtype: dict(str, str)
        """
        return self._freeform_tags

    @freeform_tags.setter
    def freeform_tags(self, freeform_tags):
        """
        Sets the freeform_tags of this AdvancedClusterFileSystem.
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace.
        For more information, see `Resource Tags`__.

        Example: `{\"Department\": \"Finance\"}`

        __ https://docs.cloud.oracle.com/Content/General/Concepts/resourcetags.htm


        :param freeform_tags: The freeform_tags of this AdvancedClusterFileSystem.
        :type: dict(str, str)
        """
        self._freeform_tags = freeform_tags

    @property
    def defined_tags(self):
        """
        Gets the defined_tags of this AdvancedClusterFileSystem.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        For more information, see `Resource Tags`__.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/resourcetags.htm


        :return: The defined_tags of this AdvancedClusterFileSystem.
        :rtype: dict(str, dict(str, object))
        """
        return self._defined_tags

    @defined_tags.setter
    def defined_tags(self, defined_tags):
        """
        Sets the defined_tags of this AdvancedClusterFileSystem.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        For more information, see `Resource Tags`__.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/resourcetags.htm


        :param defined_tags: The defined_tags of this AdvancedClusterFileSystem.
        :type: dict(str, dict(str, object))
        """
        self._defined_tags = defined_tags

    @property
    def system_tags(self):
        """
        Gets the system_tags of this AdvancedClusterFileSystem.
        System tags for this resource. Each key is predefined and scoped to a namespace.
        For more information, see `Resource Tags`__.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/resourcetags.htm


        :return: The system_tags of this AdvancedClusterFileSystem.
        :rtype: dict(str, dict(str, object))
        """
        return self._system_tags

    @system_tags.setter
    def system_tags(self, system_tags):
        """
        Sets the system_tags of this AdvancedClusterFileSystem.
        System tags for this resource. Each key is predefined and scoped to a namespace.
        For more information, see `Resource Tags`__.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/resourcetags.htm


        :param system_tags: The system_tags of this AdvancedClusterFileSystem.
        :type: dict(str, dict(str, object))
        """
        self._system_tags = system_tags

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
