# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20160918


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class EncryptionKeyLocationDetails(object):
    """
    Types of providers supported for managing database encryption keys
    """

    #: A constant which can be used with the provider_type property of a EncryptionKeyLocationDetails.
    #: This constant has a value of "EXTERNAL"
    PROVIDER_TYPE_EXTERNAL = "EXTERNAL"

    #: A constant which can be used with the provider_type property of a EncryptionKeyLocationDetails.
    #: This constant has a value of "AZURE"
    PROVIDER_TYPE_AZURE = "AZURE"

    #: A constant which can be used with the provider_type property of a EncryptionKeyLocationDetails.
    #: This constant has a value of "GCP"
    PROVIDER_TYPE_GCP = "GCP"

    #: A constant which can be used with the provider_type property of a EncryptionKeyLocationDetails.
    #: This constant has a value of "AWS"
    PROVIDER_TYPE_AWS = "AWS"

    def __init__(self, **kwargs):
        """
        Initializes a new EncryptionKeyLocationDetails object with values from keyword arguments. This class has the following subclasses and if you are using this class as input
        to a service operations then you should favor using a subclass over the base class:

        * :class:`~oci.database.models.ExternalHsmEncryptionDetails`
        * :class:`~oci.database.models.GoogleCloudProviderEncryptionKeyDetails`
        * :class:`~oci.database.models.AzureEncryptionKeyDetails`
        * :class:`~oci.database.models.AwsEncryptionKeyDetails`

        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param provider_type:
            The value to assign to the provider_type property of this EncryptionKeyLocationDetails.
            Allowed values for this property are: "EXTERNAL", "AZURE", "GCP", "AWS", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type provider_type: str

        """
        self.swagger_types = {
            'provider_type': 'str'
        }
        self.attribute_map = {
            'provider_type': 'providerType'
        }
        self._provider_type = None

    @staticmethod
    def get_subtype(object_dictionary):
        """
        Given the hash representation of a subtype of this class,
        use the info in the hash to return the class of the subtype.
        """
        type = object_dictionary['providerType']

        if type == 'EXTERNAL':
            return 'ExternalHsmEncryptionDetails'

        if type == 'GCP':
            return 'GoogleCloudProviderEncryptionKeyDetails'

        if type == 'AZURE':
            return 'AzureEncryptionKeyDetails'

        if type == 'AWS':
            return 'AwsEncryptionKeyDetails'
        else:
            return 'EncryptionKeyLocationDetails'

    @property
    def provider_type(self):
        """
        **[Required]** Gets the provider_type of this EncryptionKeyLocationDetails.
        Use 'EXTERNAL' for creating a new database or migrating a database key to an External HSM.
        Use 'AZURE' for creating a new database or migrating a database key to Azure.
        Use 'GCP' for creating a new database or migrating a database key to Google Cloud Provider.
        Use 'AWS' for creating a new database or migrating a database key to Aws.

        Allowed values for this property are: "EXTERNAL", "AZURE", "GCP", "AWS", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The provider_type of this EncryptionKeyLocationDetails.
        :rtype: str
        """
        return self._provider_type

    @provider_type.setter
    def provider_type(self, provider_type):
        """
        Sets the provider_type of this EncryptionKeyLocationDetails.
        Use 'EXTERNAL' for creating a new database or migrating a database key to an External HSM.
        Use 'AZURE' for creating a new database or migrating a database key to Azure.
        Use 'GCP' for creating a new database or migrating a database key to Google Cloud Provider.
        Use 'AWS' for creating a new database or migrating a database key to Aws.


        :param provider_type: The provider_type of this EncryptionKeyLocationDetails.
        :type: str
        """
        allowed_values = ["EXTERNAL", "AZURE", "GCP", "AWS"]
        if not value_allowed_none_or_none_sentinel(provider_type, allowed_values):
            provider_type = 'UNKNOWN_ENUM_VALUE'
        self._provider_type = provider_type

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
