# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20160918

from .autonomous_database_encryption_key_details import AutonomousDatabaseEncryptionKeyDetails
from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class OkvKeyDetails(AutonomousDatabaseEncryptionKeyDetails):
    """
    Details for OKV encryption key.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new OkvKeyDetails object with values from keyword arguments. The default value of the :py:attr:`~oci.database.models.OkvKeyDetails.provider` attribute
        of this class is ``OKV`` and it should not be changed.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param provider:
            The value to assign to the provider property of this OkvKeyDetails.
            Allowed values for this property are: "AWS", "AZURE", "OCI", "ORACLE_MANAGED", "OKV"
        :type provider: str

        :param okv_uri:
            The value to assign to the okv_uri property of this OkvKeyDetails.
        :type okv_uri: str

        :param okv_kms_key:
            The value to assign to the okv_kms_key property of this OkvKeyDetails.
        :type okv_kms_key: str

        :param directory_name:
            The value to assign to the directory_name property of this OkvKeyDetails.
        :type directory_name: str

        :param certificate_directory_name:
            The value to assign to the certificate_directory_name property of this OkvKeyDetails.
        :type certificate_directory_name: str

        :param certificate_id:
            The value to assign to the certificate_id property of this OkvKeyDetails.
        :type certificate_id: str

        """
        self.swagger_types = {
            'provider': 'str',
            'okv_uri': 'str',
            'okv_kms_key': 'str',
            'directory_name': 'str',
            'certificate_directory_name': 'str',
            'certificate_id': 'str'
        }
        self.attribute_map = {
            'provider': 'provider',
            'okv_uri': 'okvUri',
            'okv_kms_key': 'okvKmsKey',
            'directory_name': 'directoryName',
            'certificate_directory_name': 'certificateDirectoryName',
            'certificate_id': 'certificateId'
        }
        self._provider = None
        self._okv_uri = None
        self._okv_kms_key = None
        self._directory_name = None
        self._certificate_directory_name = None
        self._certificate_id = None
        self._provider = 'OKV'

    @property
    def okv_uri(self):
        """
        **[Required]** Gets the okv_uri of this OkvKeyDetails.
        URI of OKV server


        :return: The okv_uri of this OkvKeyDetails.
        :rtype: str
        """
        return self._okv_uri

    @okv_uri.setter
    def okv_uri(self, okv_uri):
        """
        Sets the okv_uri of this OkvKeyDetails.
        URI of OKV server


        :param okv_uri: The okv_uri of this OkvKeyDetails.
        :type: str
        """
        self._okv_uri = okv_uri

    @property
    def okv_kms_key(self):
        """
        **[Required]** Gets the okv_kms_key of this OkvKeyDetails.
        UUID of OKV KMS Key


        :return: The okv_kms_key of this OkvKeyDetails.
        :rtype: str
        """
        return self._okv_kms_key

    @okv_kms_key.setter
    def okv_kms_key(self, okv_kms_key):
        """
        Sets the okv_kms_key of this OkvKeyDetails.
        UUID of OKV KMS Key


        :param okv_kms_key: The okv_kms_key of this OkvKeyDetails.
        :type: str
        """
        self._okv_kms_key = okv_kms_key

    @property
    def directory_name(self):
        """
        **[Required]** Gets the directory_name of this OkvKeyDetails.
        OKV wallet directory name


        :return: The directory_name of this OkvKeyDetails.
        :rtype: str
        """
        return self._directory_name

    @directory_name.setter
    def directory_name(self, directory_name):
        """
        Sets the directory_name of this OkvKeyDetails.
        OKV wallet directory name


        :param directory_name: The directory_name of this OkvKeyDetails.
        :type: str
        """
        self._directory_name = directory_name

    @property
    def certificate_directory_name(self):
        """
        **[Required]** Gets the certificate_directory_name of this OkvKeyDetails.
        OKV certificate directory name


        :return: The certificate_directory_name of this OkvKeyDetails.
        :rtype: str
        """
        return self._certificate_directory_name

    @certificate_directory_name.setter
    def certificate_directory_name(self, certificate_directory_name):
        """
        Sets the certificate_directory_name of this OkvKeyDetails.
        OKV certificate directory name


        :param certificate_directory_name: The certificate_directory_name of this OkvKeyDetails.
        :type: str
        """
        self._certificate_directory_name = certificate_directory_name

    @property
    def certificate_id(self):
        """
        Gets the certificate_id of this OkvKeyDetails.
        OKV certificate id


        :return: The certificate_id of this OkvKeyDetails.
        :rtype: str
        """
        return self._certificate_id

    @certificate_id.setter
    def certificate_id(self, certificate_id):
        """
        Sets the certificate_id of this OkvKeyDetails.
        OKV certificate id


        :param certificate_id: The certificate_id of this OkvKeyDetails.
        :type: str
        """
        self._certificate_id = certificate_id

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
