# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20160918


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class UpdateAdvancedClusterFileSystemDetails(object):
    """
    Describes the modification parameters for the advanced cluster file system.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new UpdateAdvancedClusterFileSystemDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param storage_in_gbs:
            The value to assign to the storage_in_gbs property of this UpdateAdvancedClusterFileSystemDetails.
        :type storage_in_gbs: int

        :param vm_cluster_id:
            The value to assign to the vm_cluster_id property of this UpdateAdvancedClusterFileSystemDetails.
        :type vm_cluster_id: str

        :param freeform_tags:
            The value to assign to the freeform_tags property of this UpdateAdvancedClusterFileSystemDetails.
        :type freeform_tags: dict(str, str)

        :param defined_tags:
            The value to assign to the defined_tags property of this UpdateAdvancedClusterFileSystemDetails.
        :type defined_tags: dict(str, dict(str, object))

        """
        self.swagger_types = {
            'storage_in_gbs': 'int',
            'vm_cluster_id': 'str',
            'freeform_tags': 'dict(str, str)',
            'defined_tags': 'dict(str, dict(str, object))'
        }
        self.attribute_map = {
            'storage_in_gbs': 'storageInGBs',
            'vm_cluster_id': 'vmClusterId',
            'freeform_tags': 'freeformTags',
            'defined_tags': 'definedTags'
        }
        self._storage_in_gbs = None
        self._vm_cluster_id = None
        self._freeform_tags = None
        self._defined_tags = None

    @property
    def storage_in_gbs(self):
        """
        Gets the storage_in_gbs of this UpdateAdvancedClusterFileSystemDetails.
        The total storage needed for advanced cluster file system in GBs.


        :return: The storage_in_gbs of this UpdateAdvancedClusterFileSystemDetails.
        :rtype: int
        """
        return self._storage_in_gbs

    @storage_in_gbs.setter
    def storage_in_gbs(self, storage_in_gbs):
        """
        Sets the storage_in_gbs of this UpdateAdvancedClusterFileSystemDetails.
        The total storage needed for advanced cluster file system in GBs.


        :param storage_in_gbs: The storage_in_gbs of this UpdateAdvancedClusterFileSystemDetails.
        :type: int
        """
        self._storage_in_gbs = storage_in_gbs

    @property
    def vm_cluster_id(self):
        """
        Gets the vm_cluster_id of this UpdateAdvancedClusterFileSystemDetails.
        The `OCID`__ of the VM cluster.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :return: The vm_cluster_id of this UpdateAdvancedClusterFileSystemDetails.
        :rtype: str
        """
        return self._vm_cluster_id

    @vm_cluster_id.setter
    def vm_cluster_id(self, vm_cluster_id):
        """
        Sets the vm_cluster_id of this UpdateAdvancedClusterFileSystemDetails.
        The `OCID`__ of the VM cluster.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :param vm_cluster_id: The vm_cluster_id of this UpdateAdvancedClusterFileSystemDetails.
        :type: str
        """
        self._vm_cluster_id = vm_cluster_id

    @property
    def freeform_tags(self):
        """
        Gets the freeform_tags of this UpdateAdvancedClusterFileSystemDetails.
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace.
        For more information, see `Resource Tags`__.

        Example: `{\"Department\": \"Finance\"}`

        __ https://docs.cloud.oracle.com/Content/General/Concepts/resourcetags.htm


        :return: The freeform_tags of this UpdateAdvancedClusterFileSystemDetails.
        :rtype: dict(str, str)
        """
        return self._freeform_tags

    @freeform_tags.setter
    def freeform_tags(self, freeform_tags):
        """
        Sets the freeform_tags of this UpdateAdvancedClusterFileSystemDetails.
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace.
        For more information, see `Resource Tags`__.

        Example: `{\"Department\": \"Finance\"}`

        __ https://docs.cloud.oracle.com/Content/General/Concepts/resourcetags.htm


        :param freeform_tags: The freeform_tags of this UpdateAdvancedClusterFileSystemDetails.
        :type: dict(str, str)
        """
        self._freeform_tags = freeform_tags

    @property
    def defined_tags(self):
        """
        Gets the defined_tags of this UpdateAdvancedClusterFileSystemDetails.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        For more information, see `Resource Tags`__.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/resourcetags.htm


        :return: The defined_tags of this UpdateAdvancedClusterFileSystemDetails.
        :rtype: dict(str, dict(str, object))
        """
        return self._defined_tags

    @defined_tags.setter
    def defined_tags(self, defined_tags):
        """
        Sets the defined_tags of this UpdateAdvancedClusterFileSystemDetails.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        For more information, see `Resource Tags`__.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/resourcetags.htm


        :param defined_tags: The defined_tags of this UpdateAdvancedClusterFileSystemDetails.
        :type: dict(str, dict(str, object))
        """
        self._defined_tags = defined_tags

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
